/*
 * Decompiled with CFR 0.152.
 */
package de.mkammerer.argon2;

import com.sun.jna.Native;
import de.mkammerer.argon2.Argon2;
import de.mkammerer.argon2.Argon2Advanced;
import de.mkammerer.argon2.Argon2Factory;
import de.mkammerer.argon2.jna.Argon2Library;
import de.mkammerer.argon2.jna.JnaUint32;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.security.SecureRandom;
import java.util.Arrays;

abstract class BaseArgon2
implements Argon2,
Argon2Advanced {
    private static final String ASCII = "ASCII";
    private static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");
    private final SecureRandom secureRandom = new SecureRandom();
    private final int defaultSaltLength;
    private final int defaultHashLength;

    BaseArgon2(int defaultSaltLength, int defaultHashLength) {
        this.defaultSaltLength = defaultSaltLength;
        this.defaultHashLength = defaultHashLength;
    }

    protected int getDefaultHashLength() {
        return this.defaultHashLength;
    }

    protected abstract Argon2Factory.Argon2Types getType();

    private byte[] generateSalt() {
        byte[] salt = new byte[this.defaultSaltLength];
        this.secureRandom.nextBytes(salt);
        return salt;
    }

    @Override
    public String hash(int iterations, int memory, int parallelism, char[] password) {
        return this.hash(iterations, memory, parallelism, password, DEFAULT_CHARSET);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String hash(int iterations, int memory, int parallelism, char[] password, Charset charset) {
        byte[] pwd = this.toByteArray(password, charset);
        try {
            String string = this.hashBytes(iterations, memory, parallelism, pwd);
            return string;
        }
        finally {
            this.wipeArray(pwd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String hash(int iterations, int memory, int parallelism, String password, Charset charset) {
        byte[] pwd = password.getBytes(charset);
        try {
            String string = this.hashBytes(iterations, memory, parallelism, pwd);
            return string;
        }
        finally {
            this.wipeArray(pwd);
        }
    }

    @Override
    public String hash(int iterations, int memory, int parallelism, String password) {
        return this.hash(iterations, memory, parallelism, password, DEFAULT_CHARSET);
    }

    @Override
    public byte[] rawHash(int iterations, int memory, int parallelism, char[] password, byte[] salt) {
        return this.rawHash(iterations, memory, parallelism, password, DEFAULT_CHARSET, salt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] rawHash(int iterations, int memory, int parallelism, char[] password, Charset charset, byte[] salt) {
        byte[] pwd = this.toByteArray(password, charset);
        try {
            byte[] byArray = this.rawHashBytes(iterations, memory, parallelism, pwd, salt);
            return byArray;
        }
        finally {
            this.wipeArray(pwd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] rawHash(int iterations, int memory, int parallelism, String password, Charset charset, byte[] salt) {
        byte[] pwd = password.getBytes(charset);
        try {
            byte[] byArray = this.rawHashBytes(iterations, memory, parallelism, pwd, salt);
            return byArray;
        }
        finally {
            this.wipeArray(pwd);
        }
    }

    @Override
    public byte[] rawHash(int iterations, int memory, int parallelism, String password, byte[] salt) {
        return this.rawHash(iterations, memory, parallelism, password, DEFAULT_CHARSET, salt);
    }

    private String hashBytes(int iterations, int memory, int parallelism, byte[] pwd) {
        int len;
        byte[] encoded;
        JnaUint32 jnaParallelism;
        JnaUint32 jnaMemory;
        JnaUint32 jnaIterations;
        byte[] salt = this.generateSalt();
        int result = this.callLibraryHash(pwd, salt, jnaIterations = new JnaUint32(iterations), jnaMemory = new JnaUint32(memory), jnaParallelism = new JnaUint32(parallelism), encoded = new byte[len = Argon2Library.INSTANCE.argon2_encodedlen(jnaIterations, jnaMemory, jnaParallelism, new JnaUint32(salt.length), new JnaUint32(this.defaultHashLength), this.getType().getJnaType()).intValue()]);
        if (result != 0) {
            String errMsg = Argon2Library.INSTANCE.argon2_error_message(result);
            throw new IllegalStateException(String.format("%s (%d)", errMsg, result));
        }
        return Native.toString((byte[])encoded, (String)ASCII);
    }

    private byte[] rawHashBytes(int iterations, int memory, int parallelism, byte[] pwd, byte[] salt) {
        JnaUint32 jnaIterations = new JnaUint32(iterations);
        JnaUint32 jnaMemory = new JnaUint32(memory);
        JnaUint32 jnaParallelism = new JnaUint32(parallelism);
        byte[] hash = new byte[this.defaultHashLength];
        int result = this.callLibraryRawHash(pwd, salt, jnaIterations, jnaMemory, jnaParallelism, hash);
        if (result != 0) {
            String errMsg = Argon2Library.INSTANCE.argon2_error_message(result);
            throw new IllegalStateException(String.format("%s (%d)", errMsg, result));
        }
        return hash;
    }

    @Override
    public boolean verify(String hash, String password) {
        return this.verify(hash, password, DEFAULT_CHARSET);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean verify(String hash, String password, Charset charset) {
        byte[] pwd = password.getBytes(charset);
        try {
            boolean bl = this.verifyBytes(hash, pwd);
            return bl;
        }
        finally {
            this.wipeArray(pwd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean verify(String hash, char[] password, Charset charset) {
        byte[] pwd = this.toByteArray(password, charset);
        try {
            boolean bl = this.verifyBytes(hash, pwd);
            return bl;
        }
        finally {
            this.wipeArray(pwd);
        }
    }

    @Override
    public boolean verify(String hash, char[] password) {
        return this.verify(hash, password, DEFAULT_CHARSET);
    }

    private boolean verifyBytes(String hash, byte[] pwd) {
        byte[] encoded = Native.toByteArray((String)hash, (String)ASCII);
        int result = this.callLibraryVerify(encoded, pwd);
        return result == 0;
    }

    protected abstract int callLibraryHash(byte[] var1, byte[] var2, JnaUint32 var3, JnaUint32 var4, JnaUint32 var5, byte[] var6);

    protected abstract int callLibraryRawHash(byte[] var1, byte[] var2, JnaUint32 var3, JnaUint32 var4, JnaUint32 var5, byte[] var6);

    protected abstract int callLibraryVerify(byte[] var1, byte[] var2);

    private void wipeArray(byte[] array) {
        assert (array != null);
        Arrays.fill(array, (byte)0);
    }

    @Override
    public void wipeArray(char[] array) {
        Arrays.fill(array, '\u0000');
    }

    private byte[] toByteArray(char[] chars, Charset charset) {
        assert (chars != null);
        CharBuffer charBuffer = CharBuffer.wrap(chars);
        ByteBuffer byteBuffer = charset.encode(charBuffer);
        byte[] bytes = Arrays.copyOfRange(byteBuffer.array(), byteBuffer.position(), byteBuffer.limit());
        Arrays.fill(byteBuffer.array(), (byte)0);
        return bytes;
    }
}

