/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.commons.exec;

import de.mklinger.commons.exec.JavaCmdBuilderBase;
import java.io.File;
import java.util.List;

public class JavaClassCmdBuilder
extends JavaCmdBuilderBase<JavaClassCmdBuilder> {
    private final String className;
    private StringBuilder classpath;

    public JavaClassCmdBuilder(String className) {
        this.className = className;
    }

    public JavaClassCmdBuilder classpath(String ... classpathEntries) {
        if (classpathEntries == null || classpathEntries.length == 0) {
            return (JavaClassCmdBuilder)this.getBuilder();
        }
        if (this.classpath == null) {
            this.classpath = new StringBuilder();
        }
        for (String classpathEntry : classpathEntries) {
            if (this.classpath.length() > 0) {
                this.classpath.append(File.pathSeparatorChar);
            }
            this.classpath.append(classpathEntry);
        }
        return (JavaClassCmdBuilder)this.getBuilder();
    }

    @Override
    protected List<String> getJavaCommandParts() {
        List<String> javaCommandParts = super.getJavaCommandParts();
        if (this.classpath != null && this.classpath.length() > 0) {
            javaCommandParts.add("-cp");
            javaCommandParts.add(this.classpath.toString());
        }
        javaCommandParts.add(this.className);
        return javaCommandParts;
    }
}

