/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.commons.exec;

import de.mklinger.commons.exec.CmdUtil;
import java.io.File;

public class JavaHome {
    private final File javaHome;

    public JavaHome(File javaHome) {
        this.javaHome = javaHome;
    }

    public static JavaHome getByRuntime() {
        String javaHomeProp = System.getProperty("java.home");
        if (javaHomeProp == null || javaHomeProp.isEmpty()) {
            return null;
        }
        File f = new File(javaHomeProp);
        if (!JavaHome.isValidJavaHome(f)) {
            return null;
        }
        return new JavaHome(f);
    }

    public static JavaHome getJavaHomeByEnvironmentVariable() {
        String javaHomeEnv = System.getenv("JAVA_HOME");
        if (javaHomeEnv == null || javaHomeEnv.isEmpty()) {
            return null;
        }
        File f = new File(javaHomeEnv);
        if (!JavaHome.isValidJavaHome(f)) {
            return null;
        }
        return new JavaHome(f);
    }

    public static JavaHome getByPath() {
        String s = CmdUtil.findExecutable("java", "java.exe");
        if (s == null || s.isEmpty()) {
            return null;
        }
        File java = new File(s);
        File bin = java.getParentFile();
        if (!bin.getName().equals("bin")) {
            return null;
        }
        File javaHome = bin.getParentFile();
        if (!JavaHome.isValidJavaHome(javaHome)) {
            return null;
        }
        return new JavaHome(javaHome);
    }

    private static boolean isValidJavaHome(File f) {
        return f.isDirectory() && f.canRead();
    }

    public File getJavaHome() {
        return this.javaHome;
    }

    public File getJavaExecutable() {
        File f = new File(this.javaHome, "bin");
        f = CmdUtil.isWindows() ? new File(f, "java.exe") : new File(f, "java");
        if (f.exists() && f.canExecute()) {
            return f;
        }
        return null;
    }
}

