/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.commons.junitsupport;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.LongSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestValueFactory {
    private static final Logger LOG = LoggerFactory.getLogger(TestValueFactory.class);
    private static final int TIME_MULT = 100000;
    private static final int CREATED_ARRAY_MIN_LENGTH = 3;
    private static final int CREATED_ARRAY_MAX_LENGTH = 10;
    private final LongSupplier testValueGenerator;

    public TestValueFactory() {
        this((String)null);
    }

    public TestValueFactory(String seedPropertyName) {
        Random random = new Random(this.getSeed(seedPropertyName));
        this.testValueGenerator = () -> random.nextLong();
    }

    public TestValueFactory(LongSupplier testValueGenerator) {
        this.testValueGenerator = testValueGenerator;
    }

    private final long getSeed(String seedPropertyName) {
        String s;
        if (seedPropertyName == null) {
            seedPropertyName = this.getClass().getName() + ".seed";
        }
        long value = (s = System.getProperty(seedPropertyName)) != null && !s.isEmpty() ? Long.parseLong(s) : new SecureRandom().nextLong();
        LOG.info("Set system property {}={} to reproduce test values", (Object)seedPropertyName, (Object)value);
        return value;
    }

    protected long getNextTestValue() {
        return this.testValueGenerator.getAsLong();
    }

    protected Object createValue(Type type) {
        Type rawType;
        Class clazz = null;
        ParameterizedType parameterizedType = null;
        if (type instanceof Class) {
            clazz = (Class)type;
        } else if (type instanceof ParameterizedType && (rawType = (parameterizedType = (ParameterizedType)type).getRawType()) instanceof Class) {
            clazz = (Class)rawType;
        }
        if (clazz != null && clazz.isArray()) {
            int len = this.createArrayLength();
            Object array = Array.newInstance(clazz.getComponentType(), len);
            for (int i = 0; i < len; ++i) {
                Array.set(array, i, this.createValue(clazz.getComponentType()));
            }
            return array;
        }
        if (clazz != null && clazz.isEnum()) {
            try {
                Method valuesMethod = clazz.getMethod("values", new Class[0]);
                Object[] values = (Object[])valuesMethod.invoke(null, new Object[0]);
                int n = this.createUnsignedInt();
                return values[n % values.length];
            }
            catch (Exception e) {
                LOG.debug("Error getting enum value", (Throwable)e);
            }
        } else {
            Serializable result;
            if (parameterizedType != null && parameterizedType.getRawType() == Map.class) {
                result = new HashMap();
                Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
                if (actualTypeArguments.length != 2) {
                    throw new IllegalStateException("Have map with actualTypeArguments.length != 2");
                }
                int len = this.createArrayLength();
                for (int i = 0; i < len; ++i) {
                    result.put(this.createValue(actualTypeArguments[0]), this.createValue(actualTypeArguments[1]));
                }
                return Collections.unmodifiableMap(result);
            }
            if (parameterizedType != null && parameterizedType.getRawType() == List.class) {
                result = new ArrayList();
                this.addValuesToCollection((Collection<Object>)((Object)result), parameterizedType);
                return Collections.unmodifiableList(result);
            }
            if (parameterizedType != null && parameterizedType.getRawType() == Set.class) {
                result = new HashSet();
                this.addValuesToCollection((Collection<Object>)((Object)result), parameterizedType);
                return Collections.unmodifiableSet(result);
            }
            if (parameterizedType != null && parameterizedType.getRawType() == Collection.class) {
                result = new HashSet();
                this.addValuesToCollection((Collection<Object>)((Object)result), parameterizedType);
                return Collections.unmodifiableCollection(result);
            }
            if (parameterizedType != null && parameterizedType.getRawType() == AtomicReference.class) {
                result = new AtomicReference();
                Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
                if (actualTypeArguments.length != 1) {
                    throw new IllegalStateException("Have parameterizedType with actualTypeArguments.length != 1");
                }
                ((AtomicReference)result).set(this.createValue(actualTypeArguments[0]));
                return result;
            }
            if (type == Long.TYPE || type == Long.class) {
                return this.getNextTestValue();
            }
            if (type == Integer.TYPE || type == Integer.class) {
                return (int)this.getNextTestValue();
            }
            if (type == Character.TYPE || type == Character.class) {
                return Character.valueOf((char)this.getNextTestValue());
            }
            if (type == Short.TYPE || type == Short.class) {
                return (short)this.getNextTestValue();
            }
            if (type == Byte.TYPE || type == Byte.class) {
                return (byte)this.getNextTestValue();
            }
            if (type == Float.TYPE || type == Float.class) {
                return Float.valueOf(this.getNextTestValue());
            }
            if (type == Double.TYPE || type == Double.class) {
                return (double)this.getNextTestValue();
            }
            if (type == Boolean.TYPE || type == Boolean.class) {
                return this.getNextTestValue() % 2L == 0L;
            }
            if (type == String.class) {
                return Long.toHexString(this.getNextTestValue());
            }
            if (type == Date.class) {
                return new Date(System.currentTimeMillis() - this.getNextTestValue() * 100000L);
            }
            if (type == Object.class) {
                return this.createValue((Type)((Object)String.class));
            }
        }
        throw new UnsupportedOperationException("Test " + this.getClass() + " must override createValue(Type type) and return a value for type " + type);
    }

    private int createArrayLength() {
        return this.createUnsignedInt(3, 10);
    }

    private int createUnsignedInt() {
        int n;
        while ((n = ((Integer)this.createValue(Integer.TYPE)).intValue()) == Integer.MAX_VALUE) {
        }
        n = Math.abs(n);
        assert (n >= 0);
        return n;
    }

    private int createUnsignedInt(int max) {
        assert (max >= 0);
        int n = this.createUnsignedInt() % (max + 1);
        assert (n >= 0);
        assert (n <= max);
        return n;
    }

    private int createUnsignedInt(int min, int max) {
        assert (min >= 0);
        assert (max >= 0);
        assert (min <= max);
        int n = this.createUnsignedInt(max - min) + min;
        assert (n >= 0);
        assert (n >= min);
        assert (n <= max);
        return n;
    }

    private void addValuesToCollection(Collection<Object> result, ParameterizedType parameterizedType) {
        Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
        if (actualTypeArguments.length != 1) {
            throw new IllegalStateException("Have collection with actualTypeArguments.length != 1");
        }
        int len = this.createArrayLength();
        for (int i = 0; i < len; ++i) {
            result.add(this.createValue(actualTypeArguments[0]));
        }
    }
}

