/*
 * Decompiled with CFR 0.152.
 */
package javatools.administrative;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javatools.administrative.Announce;
import javatools.administrative.D;
import javatools.database.Database;
import javatools.database.MySQLDatabase;
import javatools.database.OracleDatabase;
import javatools.database.PostgresDatabase;
import javatools.datatypes.FinalSet;
import javatools.filehandlers.FileLines;

public class Parameters {
    public static File iniFile = null;
    public static Map<String, String> values = null;
    public static Pattern INIPATTERN = Pattern.compile(" *(\\w+) *= *(.*) *");
    public static FinalSet<String> no = new FinalSet((Comparable[])new String[]{"inactive", "off", "false", "no", "none"});

    public static File getFile(String s) throws UndefinedParameterException {
        return new File(Parameters.get(s));
    }

    public static File getFile(String s, File defaultValue) throws UndefinedParameterException {
        return Parameters.isDefined(s) ? new File(Parameters.get(s)) : defaultValue;
    }

    public static int getInt(String s) throws UndefinedParameterException {
        return Integer.parseInt(Parameters.get(s));
    }

    public static int getInt(String s, int defaultValue) throws UndefinedParameterException {
        return Parameters.isDefined(s) ? Integer.parseInt(Parameters.get(s)) : defaultValue;
    }

    public static double getDouble(String s) throws UndefinedParameterException {
        return Double.parseDouble(Parameters.get(s));
    }

    public static double getDouble(String s, double defaultValue) throws UndefinedParameterException {
        return Parameters.isDefined(s) ? Double.parseDouble(Parameters.get(s)) : defaultValue;
    }

    public static boolean getBoolean(String s) throws UndefinedParameterException {
        String v = Parameters.get(s);
        return !no.contains(v.toLowerCase());
    }

    public static boolean getBoolean(String s, boolean defaultValue) {
        String v = Parameters.get(s, defaultValue ? "yes" : "no");
        return !no.contains(v.toLowerCase());
    }

    public static List<String> getList(String s) throws UndefinedParameterException {
        if (!Parameters.isDefined(s)) {
            return null;
        }
        return Arrays.asList(Parameters.get(s).split("\\s*,\\s*"));
    }

    public static String get(String s) throws UndefinedParameterException {
        if (values == null) {
            throw new RuntimeException("Call init() before get()!");
        }
        String pname = s.indexOf(32) == -1 ? s : s.substring(0, s.indexOf(32));
        String v = values.get(pname.toLowerCase());
        if (v == null) {
            throw new UndefinedParameterException(s, iniFile);
        }
        return v;
    }

    public static String get(String s, String defaultValue) {
        if (values == null) {
            throw new RuntimeException("Call init() before get()!");
        }
        String pname = s.indexOf(32) == -1 ? s : s.substring(0, s.indexOf(32));
        String v = values.get(pname.toLowerCase());
        if (v == null) {
            return defaultValue;
        }
        return v;
    }

    public static String getOrRequest(String s, String description) {
        if (values == null) {
            throw new RuntimeException("Call init() before get()!");
        }
        String v = values.get(s.toLowerCase());
        if (v == null) {
            D.println(description);
            v = D.read();
        }
        return v;
    }

    public static String getOrRequestAndAdd(String s, String description) throws IOException {
        String v = Parameters.getOrRequest(s, description);
        Parameters.add(s, v);
        return v;
    }

    public static int getOrRequestAndAddInt(String s, String description) throws IOException {
        int v = Parameters.getOrRequestInteger(s, description);
        Parameters.add(s, "" + v);
        return v;
    }

    public static File getOrRequestAndAddFile(String s, String description) throws IOException {
        File v = Parameters.getOrRequestFileParameter(s, description);
        Parameters.add(s, "" + v);
        return v;
    }

    public static boolean getOrRequestAndAddBoolean(String s, String description) throws IOException {
        boolean v = Parameters.getOrRequestBoolean(s, description);
        Parameters.add(s, v ? "yes" : "no");
        return v;
    }

    public static File getOrRequestFileParameter(String s, String description) {
        String fn;
        File f;
        while (!(f = new File(fn = Parameters.getOrRequest(s, description))).exists()) {
            D.println("File not found", fn);
            Parameters.remove(s);
        }
        return f;
    }

    public static String remove(String parameter) {
        return values.remove(parameter.toLowerCase());
    }

    public static boolean getOrRequestBoolean(String s, String description) {
        String fn;
        do {
            if (!(fn = Parameters.getOrRequest(s, description).toLowerCase()).equals("true") && !fn.equals("yes")) continue;
            return true;
        } while (!fn.equals("false") && !fn.equals("no"));
        return false;
    }

    public static int getOrRequestInteger(String s, String description) {
        while (true) {
            String fn = Parameters.getOrRequest(s, description);
            try {
                return Integer.parseInt(fn);
            }
            catch (Exception exception) {
                Parameters.remove(s);
                continue;
            }
            break;
        }
    }

    public static void add(String key, String value) throws IOException {
        if (values == null || iniFile == null) {
            throw new RuntimeException("Call init() before get()!");
        }
        if (values.containsKey(key.toLowerCase())) {
            return;
        }
        values.put(key.toLowerCase(), value);
        FileWriter w = new FileWriter(iniFile, true);
        w.write(key + " = " + value + "\n");
        ((Writer)w).close();
    }

    public static void init(File f) throws IOException {
        if (f.equals(iniFile)) {
            return;
        }
        values = new TreeMap<String, String>();
        iniFile = f;
        if (!iniFile.exists()) {
            Announce.error("The initialisation file", iniFile.getCanonicalPath(), "was not found.");
        }
        String lastAttrib = null;
        for (String l : new FileLines(iniFile)) {
            Matcher m = INIPATTERN.matcher(l);
            if (!m.matches()) {
                if (lastAttrib == null) continue;
                values.put(lastAttrib, values.get(lastAttrib) + l);
                if (l.trim().endsWith(",")) continue;
                lastAttrib = null;
                continue;
            }
            String s = m.group(2).trim();
            if (s.startsWith("\"")) {
                s = s.substring(1);
            }
            if (s.endsWith("\"")) {
                s = s.substring(0, s.length() - 1);
            }
            values.put(m.group(1).toLowerCase(), s);
            if (s.trim().endsWith(",")) {
                lastAttrib = m.group(1).toLowerCase();
                continue;
            }
            lastAttrib = null;
        }
    }

    public static void init(String filename, File ... folders) throws IOException {
        boolean found = false;
        for (File folder : folders) {
            if (!new File(folder, filename).exists()) continue;
            if (found) {
                throw new IOException("INI-file " + filename + "occurs twice in given folders");
            }
            Parameters.init(new File(folder, filename));
            found = true;
        }
    }

    public static boolean isDefined(String s) {
        if (values == null) {
            throw new RuntimeException("Call init() before get()!");
        }
        String pname = s.indexOf(32) == -1 ? s : s.substring(0, s.indexOf(32));
        return values.containsKey(pname.toLowerCase());
    }

    public static void init(String file) throws IOException {
        Parameters.init(new File(file));
    }

    public static void ensureParameters(String ... p) {
        if (values == null) {
            throw new RuntimeException("Call init() before ensureParameters()!");
        }
        boolean OK = true;
        StringBuilder b = new StringBuilder("The following parameters are undefined in ").append(iniFile);
        for (String s : p) {
            if (Parameters.isDefined(s)) continue;
            b.append("\n       ").append(s);
            OK = false;
        }
        if (OK) {
            return;
        }
        Announce.error(b.toString());
    }

    public static boolean getBooleanArgument(String[] args, String ... argnames) {
        Matcher m;
        String arg = " ";
        for (String s : args) {
            arg = arg + s + ' ';
        }
        String p = "\\W(";
        for (String s : argnames) {
            p = p + s + '|';
        }
        if (p.endsWith("|")) {
            p = p.substring(0, p.length() - 1);
        }
        if (!(m = Pattern.compile(p = p + ")\\W").matcher(arg)).find()) {
            return false;
        }
        String next = arg.substring(m.end()).toLowerCase();
        if (next.indexOf(32) != -1) {
            next = next.substring(0, next.indexOf(32));
        }
        if (next.equals("off")) {
            return false;
        }
        if (next.equals("0")) {
            return false;
        }
        if (next.equals("false")) {
            return false;
        }
        String previous = arg.substring(0, m.start()).toLowerCase();
        if (previous.indexOf(32) != -1) {
            previous = previous.substring(previous.lastIndexOf(32) + 1);
        }
        return !previous.equals("no");
    }

    public static void reset() {
        iniFile = null;
        values = null;
    }

    public static Database getDatabase() throws Exception {
        Parameters.ensureParameters("databaseSystem - either Oracle, Postgres or MySQL", "databaseUser - the user name for the database (also: databaseDatabase, databaseInst,databasePort,databaseHost,databaseSchema)", "databasePassword - the password for the database");
        String system = Parameters.get("databaseSystem").toUpperCase();
        String user = Parameters.get("databaseUser");
        String password = Parameters.get("databasePassword");
        String host = null;
        String schema = null;
        String inst = null;
        String port = null;
        String database = null;
        try {
            host = Parameters.get("databaseHost");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            schema = Parameters.get("databaseSchema");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            port = Parameters.get("databasePort");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            inst = Parameters.get("databaseSID");
        }
        catch (UndefinedParameterException undefinedParameterException) {
            // empty catch block
        }
        try {
            database = Parameters.get("databaseDatabase");
        }
        catch (UndefinedParameterException undefinedParameterException) {
            // empty catch block
        }
        if (system.equals("ORACLE")) {
            return new OracleDatabase(user, password, host, port, inst);
        }
        if (system.equals("MYSQL")) {
            return new MySQLDatabase(user, password, database, host, port);
        }
        if (system.equals("POSTGRES")) {
            return new PostgresDatabase(user, password, database, host, port, schema);
        }
        throw new RuntimeException("Unsupported database system " + system);
    }

    public static Set<String> parameters() {
        return values.keySet();
    }

    public static void main(String[] args) throws Exception {
        String initFile = args == null || args.length == 0 ? "yago.ini" : args[0];
        Parameters.init(initFile);
        D.p(values);
    }

    public static class UndefinedParameterException
    extends RuntimeException {
        private static final long serialVersionUID = -7648653481162390258L;

        public UndefinedParameterException(String s, File f) {
            super("The parameter " + s + " is undefined in " + f);
        }
    }
}

