/*
 * Decompiled with CFR 0.152.
 */
package javatools.administrative;

import javatools.administrative.Announce;
import javatools.parsers.NumberFormatter;
import javatools.parsers.NumberParser;

public class Sleep {
    public static void sleep(String time) throws NumberFormatException, InterruptedException {
        Sleep.sleep((long)Double.parseDouble(NumberParser.getNumber(NumberParser.normalize(time))));
    }

    public static void sleep(long seconds) throws InterruptedException {
        Announce.progressStart("Sleeping " + NumberFormatter.formatMS(seconds * 1000L), seconds);
        for (long slept = 0L; slept < seconds; ++slept) {
            Announce.progressAt(slept);
            Thread.sleep(1000L);
        }
        Announce.progressDone();
    }

    public static void main(String[] args) throws Exception {
        if (args == null || args.length == 0) {
            Announce.help("Sleep for a given time. E.g. 'sleep 3h 5min'");
        }
        String time = "";
        for (int i = 0; i < args.length; ++i) {
            time = time + " " + args[i];
        }
        Sleep.sleep(time);
    }
}

