/*
 * Decompiled with CFR 0.152.
 */
package javatools.database;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javatools.administrative.Announce;
import javatools.administrative.D;

public class WordNet
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static Pattern SYNSETPATTERN = Pattern.compile("s\\((\\d{9}),\\d*,'(.*)',(.),(\\d*),.*");
    public static final int IDGROUP = 1;
    public static final int WORDGROUP = 2;
    public static final int CLASSGROUP = 3;
    public static final int SENSENUMGROUP = 4;
    public static Pattern RELATIONPATTERN = Pattern.compile("\\w*\\((\\d{9}),(\\d{9})\\)\\.");
    public static final int DOWNGROUP = 1;
    public static final int UPGROUP = 2;
    protected Synset source;
    public Map<String, List<Synset>> word2synsets = new HashMap<String, List<Synset>>(114700);
    protected Map<Integer, Synset> id2synset = null;

    public Map<Integer, Synset> getId2SynsetMap() {
        return this.id2synset;
    }

    public Synset getSynset(int id) {
        return this.id2synset.get(id);
    }

    public Collection<Synset> getSynsets() {
        return this.id2synset.values();
    }

    public List<Synset> synsetsFor(String s) {
        return this.word2synsets.get(s.replace('_', ' '));
    }

    public int numSynsets() {
        return this.id2synset.size();
    }

    public Synset synsetFor(String word, String otherWord) {
        for (Synset s : this.word2synsets.get(word)) {
            if (!s.words.contains(otherWord)) continue;
            return s;
        }
        return null;
    }

    public WordNet(File wn_s, EnumSet<WordType> lextypes, int sensesPerWord) throws IOException {
        this(wn_s, null, lextypes, sensesPerWord);
    }

    public WordNet(File wn_s, WordType lextype, int sensesPerWord) throws IOException {
        this(wn_s, null, EnumSet.of(lextype), sensesPerWord);
    }

    public WordNet(File wn_s, File relation, WordType lextype, int sensesPerWord) throws IOException {
        this(wn_s, relation, EnumSet.of(lextype), sensesPerWord);
    }

    public WordNet(File wn_s, File relation, EnumSet<WordType> lextypes, int sensesPerWord) throws IOException {
        Matcher m;
        int type;
        int maxId = 0;
        for (WordType w : lextypes) {
            if (w.ordinal() + 1 <= maxId) continue;
            maxId = w.ordinal() + 1;
        }
        this.id2synset = new HashMap<Integer, Synset>();
        BufferedReader in = new BufferedReader(new FileReader(wn_s));
        String s = in.readLine();
        if (!SYNSETPATTERN.matcher(s).matches()) {
            throw new IOException(wn_s + " does not contain WordNet synsets");
        }
        while (s != null && (type = s.charAt(2) - 48) <= maxId) {
            if (!lextypes.contains((Object)WordType.values()[type - 1])) {
                s = in.readLine();
                continue;
            }
            while (s != null && s.charAt(2) - 48 == type) {
                int senseNumber;
                m = SYNSETPATTERN.matcher(s);
                if (!m.matches()) continue;
                int id = Integer.parseInt(m.group(1));
                Synset currentSS = this.id2synset.get(id);
                if (currentSS == null) {
                    currentSS = new Synset(id);
                    this.id2synset.put(id, currentSS);
                }
                if ((senseNumber = Integer.parseInt(m.group(4))) <= sensesPerWord) {
                    String word = m.group(2).replace("''", "'");
                    currentSS.words.add(word);
                    List<Synset> synsets = this.word2synsets.get(word);
                    if (synsets == null) {
                        synsets = new ArrayList<Synset>(sensesPerWord);
                        this.word2synsets.put(word, synsets);
                    }
                    while (synsets.size() < senseNumber) {
                        synsets.add(null);
                    }
                    synsets.set(senseNumber - 1, currentSS);
                }
                s = in.readLine();
            }
        }
        in.close();
        for (List<Synset> l : this.word2synsets.values()) {
            for (int i = 0; i < l.size(); ++i) {
                if (l.get(i) != null) continue;
                l.remove(i--);
            }
        }
        if (relation == null) {
            return;
        }
        in = new BufferedReader(new FileReader(relation));
        s = in.readLine();
        if (!RELATIONPATTERN.matcher(s).matches()) {
            throw new IOException(relation + " does not contain a WordNet relation");
        }
        block6: while (s != null && (type = s.charAt(s.indexOf(40) + 1) - 48) <= maxId) {
            if (!lextypes.contains((Object)WordType.values()[type - 1])) {
                s = in.readLine();
                continue;
            }
            while (s != null) {
                m = RELATIONPATTERN.matcher(s);
                if (m.matches()) {
                    if (m.group(2).charAt(0) - 48 != type) continue block6;
                    Synset down = this.id2synset.get(Integer.parseInt(m.group(1)));
                    Synset up = this.id2synset.get(Integer.parseInt(m.group(2)));
                    if (up != null && down != null) {
                        down.ups.add(up);
                        up.downs.add(down);
                    }
                }
                s = in.readLine();
            }
        }
        in.close();
    }

    public String toString() {
        return "WordNet: " + this.word2synsets.size() + " synsets";
    }

    protected void setSource(Synset start, int dist) {
        if (start.marker == this.source && start.intMarker <= dist) {
            dist = start.intMarker;
        }
        start.marker = this.source;
        start.intMarker = dist;
        for (Synset s : start.ups) {
            this.setSource(s, dist + 1);
        }
    }

    protected void setSource(Synset start) {
        if (this.source == start) {
            return;
        }
        this.source = start;
        this.setSource(start, 0);
    }

    protected Synset nca(Synset destination, int[] dist, int d) {
        if (destination.marker == this.source) {
            dist[0] = d + destination.intMarker;
            return destination;
        }
        if (destination.marker == dist) {
            System.err.println("Found a loop in WordNet with " + destination);
            return null;
        }
        destination.marker = dist;
        Synset bestSS = null;
        dist[0] = Integer.MAX_VALUE;
        for (Synset s : destination.ups) {
            int[] dist2 = new int[1];
            Synset c = this.nca(s, dist2, d + 1);
            if (dist2[0] >= dist[0]) continue;
            dist[0] = dist2[0];
            bestSS = c;
        }
        return bestSS;
    }

    public Synset nca(Synset source, Synset destination, int[] dist1, int[] dist2) {
        if (source == destination) {
            dist2[0] = 0;
            dist1[0] = 0;
            return source;
        }
        this.setSource(source);
        Synset nca = this.nca(destination, dist2, 0);
        if (nca == null) {
            dist1[0] = -1;
            dist2[0] = -1;
        } else {
            dist1[0] = nca.intMarker;
        }
        return nca;
    }

    public Synset nca(Synset s1, Synset s2) {
        int[] dist1 = new int[1];
        int[] dist2 = new int[2];
        return this.nca(s1, s2, dist1, dist2);
    }

    public int distance(Synset s1, Synset s2) {
        int[] d1 = new int[1];
        int[] d2 = new int[1];
        if (this.nca(s1, s2, d1, d2) != null) {
            return d1[0] + d2[0];
        }
        return -1;
    }

    public int ancestor(Synset s1, Synset s2) {
        this.setSource(s1);
        if (s2.marker != s1) {
            return -1;
        }
        return s2.intMarker;
    }

    public void remove(Synset s) {
        this.id2synset.remove(s.id);
        for (String w : s.getWords()) {
            Collection synsets = this.word2synsets.get(w);
            if (synsets == null) continue;
            synsets.remove(s);
            if (synsets.size() != 0) continue;
            this.word2synsets.remove(w);
        }
        for (Synset up : s.getUps()) {
            up.downs.remove(s);
        }
        for (Synset down : s.getDowns()) {
            down.ups.remove(s);
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void main(String[] argv) throws Exception {
        Announce.doing(new Object[]{"Loading"});
        wordNet = new WordNet(new File("c:\\Program Files\\WordNet\\2.1\\Prolog\\wn_s.pl"), new File("c:\\Program Files\\WordNet\\2.1\\Prolog\\wn_hyp.pl"), WordType.NOUN, 13);
        Announce.done();
        block0: while (true) {
            D.p(new Object[]{"Enter an English and press ENTER (CTRL+C to abort)"});
            targetSynsets = wordNet.synsetsFor(D.r());
            if (targetSynsets == null) continue;
            var3_3 = targetSynsets.iterator();
            while (true) {
                if (var3_3.hasNext()) ** break;
                continue block0;
                s = var3_3.next();
                D.p(new Object[]{s.toSmallString()});
            }
            break;
        }
    }

    public static class Synset
    implements Serializable,
    Comparable<Synset> {
        private static final long serialVersionUID = 1L;
        protected int id;
        protected List<String> words = new ArrayList<String>(8);
        protected List<Synset> ups = new ArrayList<Synset>(0);
        protected List<Synset> downs = new ArrayList<Synset>(0);
        public Object marker = null;
        public int intMarker = 0;

        public Synset(int idnum) {
            this.id = idnum;
        }

        public int hashCode() {
            return this.id;
        }

        public boolean equals(Object o) {
            return o != null && o instanceof Synset && ((Synset)o).id == this.id;
        }

        @Override
        public int compareTo(Synset o) {
            return o.id == this.id ? 0 : (o.id < this.id ? 1 : -1);
        }

        public final String toString() {
            StringBuilder result = new StringBuilder("Synset #").append(this.id).append(" (").append((Object)this.getWordType()).append("): [");
            for (String s : this.words) {
                result.append(s).append(", ");
            }
            return result.append("]").toString();
        }

        public List<Synset> getDowns() {
            return this.downs;
        }

        public int getId() {
            return this.id;
        }

        public List<Synset> getUps() {
            return this.ups;
        }

        public List<String> getWords() {
            return this.words;
        }

        public String toSmallString() {
            if (this.words.size() == 0) {
                return "#" + this.id;
            }
            if (this.ups.size() == 0 || this.ups.get((int)0).words.size() == 0) {
                return this.words.get(0);
            }
            return this.words.get(0) + " (" + this.ups.get((int)0).words.get(0) + ")";
        }

        public WordType getWordType() {
            return WordType.values()[this.id / 100000000 - 1];
        }

        public Set<Synset> ancestors() {
            TreeSet<Synset> set = new TreeSet<Synset>();
            this.ancestors(set);
            return set;
        }

        protected void ancestors(Set<Synset> set) {
            for (Synset s : this.ups) {
                if (!set.add(s)) continue;
                s.ancestors(set);
            }
        }

        public Set<Synset> descendants() {
            TreeSet<Synset> set = new TreeSet<Synset>();
            this.descendants(set);
            return set;
        }

        protected void descendants(Set<Synset> set) {
            for (Synset s : this.downs) {
                if (!set.add(s)) continue;
                s.descendants(set);
            }
        }
    }

    public static enum WordType {
        NOUN,
        VERB,
        ADJECTIVE,
        ADVERB;

    }
}

