/*
 * Decompiled with CFR 0.152.
 */
package javatools.datatypes;

import java.util.AbstractQueue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javatools.administrative.D;
import javatools.datatypes.CombinedIterator;

public class ArrayQueue<T>
extends AbstractQueue<T> {
    protected List<T> data = new ArrayList<T>();
    protected int first = 0;
    protected int last = 0;
    protected static Object[] blanks = new Object[10];

    @Override
    public Iterator<T> iterator() {
        if (this.first <= this.last) {
            return this.data.subList(this.first, this.last).iterator();
        }
        return new CombinedIterator<T>(this.data.subList(this.first, this.data.size()).iterator(), this.data.subList(0, this.last).iterator());
    }

    @Override
    public int size() {
        if (this.first <= this.last) {
            return this.last - this.first;
        }
        return this.data.size() - this.first + this.last;
    }

    @Override
    public boolean offer(T o) {
        this.data.set(this.last, o);
        this.last = (this.last + 1) % this.data.size();
        if (this.last == this.first) {
            this.data.addAll(this.last, Arrays.asList(blanks));
            this.first += blanks.length;
        }
        return true;
    }

    @Override
    public T peek() {
        if (this.size() == 0) {
            return null;
        }
        return this.data.get(this.first);
    }

    @Override
    public T poll() {
        T result = this.peek();
        if (this.size() != 0) {
            this.first = (this.first + 1) % this.data.size();
        }
        return result;
    }

    public ArrayQueue(T ... initialData) {
        this((Collection<T>)Arrays.asList(initialData));
    }

    public ArrayQueue(Collection<T> initialData) {
        this.data.add(null);
        for (T element : initialData) {
            this.offer(element);
        }
    }

    public ArrayQueue(int size) {
        this.data = new ArrayList<T>(size + 1);
        this.data.add(null);
    }

    public static void main(String[] args) {
        ArrayQueue<Integer> a = new ArrayQueue<Integer>(new Integer[0]);
        a.offer(1);
        D.p(a.peek());
        int counter = 9;
        while (a.size() != 0) {
            a.offer(counter++);
            D.p(a.poll());
            D.p(a.poll());
        }
    }
}

