/*
 * Decompiled with CFR 0.152.
 */
package javatools.datatypes;

import java.util.AbstractSet;
import java.util.Arrays;
import javatools.administrative.D;
import javatools.datatypes.PeekIterator;

public class BitVector
extends AbstractSet<Integer> {
    protected long[] data;
    protected int size = 0;

    public BitVector(int capacity) {
        this.data = new long[capacity / 64 + 1];
    }

    public BitVector(BitVector v) {
        this.data = Arrays.copyOf(v.data, v.data.length);
        this.size = v.size;
    }

    public BitVector() {
        this(10);
    }

    protected void ensureCapacity(int c) {
        if (this.data.length * 64 > c) {
            return;
        }
        long[] newdta = new long[c / 64 + 1];
        System.arraycopy(this.data, 0, newdta, 0, this.data.length);
        this.data = newdta;
    }

    @Override
    public boolean add(Integer pos) {
        return this.add((int)pos);
    }

    @Override
    public boolean add(int pos) {
        this.ensureCapacity(pos);
        if (this.contains(pos)) {
            return false;
        }
        long add = 1L << pos % 64;
        int n = pos / 64;
        this.data[n] = this.data[n] | add;
        ++this.size;
        return true;
    }

    @Override
    public boolean remove(Object pos) {
        if (!(pos instanceof Integer)) {
            return false;
        }
        return this.remove((Integer)pos);
    }

    public boolean remove(int pos) {
        if (!this.contains(pos)) {
            return false;
        }
        long add = 1L << pos % 64;
        int n = pos / 64;
        this.data[n] = this.data[n] & (add ^ 0xFFFFFFFFFFFFFFFFL);
        --this.size;
        return true;
    }

    @Override
    public boolean contains(Object arg0) {
        if (!(arg0 instanceof Integer)) {
            return false;
        }
        return this.contains((Integer)arg0);
    }

    public boolean contains(int index) {
        if (index / 64 >= this.data.length) {
            return false;
        }
        long l = this.data[index / 64];
        return (l >> index % 64 & 1L) > 0L;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        this.data = new long[1];
        this.size = 0;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder(this.size * 5).append("[");
        for (Integer i : this) {
            b.append(i).append(", ");
        }
        return b.append("]").toString();
    }

    public void compress() {
        for (int i = this.data.length - 1; i >= 0; --i) {
            if (this.data[i] == 0L) continue;
            if (i < this.data.length - 10) {
                long[] newdta = new long[i + 1];
                System.arraycopy(this.data, 0, newdta, 0, newdta.length);
                this.data = newdta;
            }
            return;
        }
    }

    @Override
    public PeekIterator<Integer> iterator() {
        this.compress();
        return new PeekIterator<Integer>(){
            int i = -1;

            @Override
            protected Integer internalNext() throws Exception {
                do {
                    if (this.i / 64 >= BitVector.this.data.length) {
                        return null;
                    }
                    if (this.i >= 0 && BitVector.this.data[this.i / 64] == 0L) {
                        this.i += 64;
                        continue;
                    }
                    ++this.i;
                } while (!BitVector.this.contains(this.i));
                return this.i;
            }
        };
    }

    public static void main(String[] args) {
        BitVector v = new BitVector();
        v.add(1);
        v.add(63);
        v.add(64);
        v.add(10000000);
        v.remove(10);
        v.remove(63);
        D.p(v);
    }
}

