/*
 * Decompiled with CFR 0.152.
 */
package javatools.datatypes;

import javatools.administrative.D;
import javatools.datatypes.DoubleHashMap;
import javatools.datatypes.IntHashMap;

public class FastFrequencyVector {
    public static <K> double fuzzyPrecision(DoubleHashMap<K> me, DoubleHashMap<K> other) {
        return FastFrequencyVector.fuzzyRecall(other, me);
    }

    public static <K> double fuzzyPrecision(IntHashMap<K> me, IntHashMap<K> other) {
        return FastFrequencyVector.fuzzyRecall(other, me);
    }

    public static <K> double fuzzyRecall(DoubleHashMap<K> me, DoubleHashMap<K> other) {
        if (other.isEmpty()) {
            return 1.0;
        }
        double myMax = me.findMax();
        double otherMax = other.findMax();
        double fuzzyRecall = 0.0;
        for (K trueTerm : other.keys()) {
            double guessedValue;
            double trueValue = other.get(trueTerm) / otherMax;
            if (!(trueValue > (guessedValue = me.get(trueTerm) / myMax))) continue;
            fuzzyRecall += trueValue - guessedValue;
        }
        if ((fuzzyRecall = 1.0 - fuzzyRecall / other.computeSum() * otherMax) < 0.0) {
            fuzzyRecall = 0.0;
        }
        return fuzzyRecall;
    }

    public static <K> double fuzzyRecall(IntHashMap<K> me, IntHashMap<K> other) {
        if (other.isEmpty()) {
            return 1.0;
        }
        double myMax = me.findMax();
        double otherMax = other.findMax();
        double fuzzyRecall = 0.0;
        for (K trueTerm : other.keys()) {
            double guessedValue;
            double trueValue = (double)other.get(trueTerm) / otherMax;
            if (!(trueValue > (guessedValue = (double)me.get(trueTerm) / myMax))) continue;
            fuzzyRecall += trueValue - guessedValue;
        }
        if ((fuzzyRecall = 1.0 - fuzzyRecall / (double)other.computeSum() * otherMax) < 0.0) {
            fuzzyRecall = 0.0;
        }
        return fuzzyRecall;
    }

    public static void main(String[] args) throws Exception {
        IntHashMap<String> person = new IntHashMap<String>();
        person.put("birthDate", 100);
        person.put("birthPlace", 80);
        person.put("deathPlace", 50);
        person.put("wonPrize", 10);
        IntHashMap<String> livingPerson = new IntHashMap<String>();
        livingPerson.put("birthDate", 20);
        livingPerson.put("birthPlace", 16);
        IntHashMap<String> scientist = new IntHashMap<String>();
        scientist.put("birthDate", 10);
        scientist.put("birthPlace", 10);
        scientist.put("deathPlace", 8);
        scientist.put("wonPrize", 8);
        D.p("LivingPerson covers what person has:", FastFrequencyVector.fuzzyRecall(livingPerson, person));
        D.p("LivingPerson is covered by person:", FastFrequencyVector.fuzzyPrecision(livingPerson, person));
        D.p("Scientist covers what person has:", FastFrequencyVector.fuzzyRecall(scientist, person));
        D.p("Scientist is covered by person:", FastFrequencyVector.fuzzyPrecision(scientist, person));
    }
}

