/*
 * Decompiled with CFR 0.152.
 */
package javatools.datatypes;

import java.util.AbstractMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class MultiMap<A, B>
implements Iterable<Map.Entry<A, B>> {
    private Map<A, Set<B>> relation;

    public MultiMap() {
        this.relation = new HashMap<A, Set<B>>();
    }

    public MultiMap(int initialSize) {
        this.relation = new HashMap<A, Set<B>>(initialSize);
    }

    public void put(A a, B b) {
        Set<B> bs = this.relation.get(a);
        if (bs == null) {
            bs = new HashSet<B>();
            this.relation.put(a, bs);
        }
        bs.add(b);
    }

    public void putAll(MultiMap<A, B> otherMap) {
        for (Map.Entry<A, B> e : otherMap) {
            this.put(e.getKey(), e.getValue());
        }
    }

    public Set<B> get(A a) {
        return this.relation.get(a);
    }

    public boolean contains(Map.Entry<A, B> e) {
        Set<B> test = this.relation.get(e.getKey());
        if (test == null) {
            return false;
        }
        return test.contains(e.getValue());
    }

    public boolean isEmpty() {
        return this.relation.isEmpty();
    }

    @Override
    public Iterator<Map.Entry<A, B>> iterator() {
        return new MultiMapIterator();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<A, B> e : this) {
            sb.append(e.getKey() + " - " + e.getValue() + ", ");
        }
        return sb.toString();
    }

    private class MultiMapIterator
    implements Iterator<Map.Entry<A, B>> {
        private Iterator<A> aIterator;
        private A currentA;
        private Iterator<B> bIterator;

        public MultiMapIterator() {
            this.aIterator = MultiMap.this.relation.keySet().iterator();
        }

        @Override
        public boolean hasNext() {
            if (this.aIterator.hasNext()) {
                if (this.bIterator == null) {
                    this.currentA = this.aIterator.next();
                    this.bIterator = ((Set)MultiMap.this.relation.get(this.currentA)).iterator();
                }
                return true;
            }
            if (this.bIterator != null) {
                return this.bIterator.hasNext();
            }
            return false;
        }

        @Override
        public Map.Entry<A, B> next() {
            Object currentB = this.bIterator.next();
            if (!this.bIterator.hasNext()) {
                this.bIterator = null;
            }
            return new AbstractMap.SimpleEntry(this.currentA, currentB);
        }

        @Override
        public void remove() {
        }
    }
}

