/*
 * Decompiled with CFR 0.152.
 */
package javatools.datatypes;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import javatools.administrative.D;

public abstract class PeekIterator<T>
implements Iterator<T>,
Iterable<T>,
Closeable {
    public T next = null;
    public boolean fetchedNextValue = false;
    public boolean closed = false;
    protected static PeekIterator<Object> EMPTY = new PeekIterator<Object>(){
        {
            this.closed = true;
            this.fetchedNextValue = true;
            this.next = null;
        }

        @Override
        protected Object internalNext() throws Exception {
            return null;
        }

        @Override
        public String toString() {
            return "EmptyPeekIterator";
        }
    };

    @Override
    public final boolean hasNext() {
        if (!this.fetchedNextValue) {
            this.next = this.internalSilentNext();
        }
        if (this.next == null && !this.closed) {
            this.close();
            this.closed = true;
        }
        return this.next != null;
    }

    protected final T internalSilentNext() {
        try {
            T next = this.internalNext();
            this.fetchedNextValue = true;
            return next;
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    protected abstract T internalNext() throws Exception;

    @Override
    public final T next() {
        if (this.hasNext()) {
            T returnMe = this.next;
            this.fetchedNextValue = false;
            return returnMe;
        }
        throw new NoSuchElementException();
    }

    public final T nextOrNull() {
        if (this.hasNext()) {
            return this.next();
        }
        return null;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public final T peek() {
        if (this.hasNext()) {
            return this.next;
        }
        throw new NoSuchElementException();
    }

    @Override
    public Iterator<T> iterator() {
        return this;
    }

    @Override
    public void close() {
    }

    public static <T> List<T> asList(Iterator<T> i) {
        ArrayList<T> l = new ArrayList<T>();
        while (i.hasNext()) {
            l.add(i.next());
        }
        return l;
    }

    public List<T> asList() {
        return PeekIterator.asList(this);
    }

    public static <T> Set<T> asSet(Iterator<T> i, Set<T> set) {
        while (i.hasNext()) {
            set.add(i.next());
        }
        return set;
    }

    public static <T> Set<T> asSet(Iterator<T> i) {
        return PeekIterator.asSet(i, new HashSet());
    }

    public Set<T> asSet() {
        return PeekIterator.asSet(this);
    }

    public String toString() {
        return "PeekIterator[initialized=" + this.fetchedNextValue + ", closed=" + this.closed + ", next=" + this.next + "]";
    }

    public static <K> PeekIterator<K> emptyIterator() {
        return EMPTY;
    }

    public static <S> int numElements(Iterator<S> it) {
        int num = 0;
        while (it.hasNext()) {
            it.next();
            ++num;
        }
        return num;
    }

    public static <S> int numElements(Iterable<S> it) {
        return PeekIterator.numElements(it.iterator());
    }

    public static <S> StringBuilder toString(Iterable<S> it) {
        return PeekIterator.toString(it.iterator());
    }

    public static <S> StringBuilder toString(Iterator<S> it) {
        StringBuilder res = new StringBuilder();
        while (it.hasNext()) {
            res.append(", ").append(it.next());
        }
        if (res.length() == 0) {
            return res.append("[]");
        }
        res.setCharAt(0, '[');
        return res.append("]");
    }

    public static <S> List<S> list(Iterable<S> it) {
        return PeekIterator.list(it.iterator());
    }

    public static <S> List<S> list(Iterator<S> it) {
        ArrayList<S> res = new ArrayList<S>();
        while (it.hasNext()) {
            res.add(it.next());
        }
        return res;
    }

    public static void main(String[] args) throws Exception {
        SimplePeekIterator<Integer[]> it = new SimplePeekIterator<Integer[]>(new Integer[]{1, 2, 3, 4});
        D.p(it.peek());
        D.p(it.peek());
        D.p(it.next());
        D.p(it.peek());
        D.p(it.peek());
    }

    public static class ElementaryPeekIterator<T>
    extends PeekIterator<T> {
        protected T element;

        public ElementaryPeekIterator(T element) {
            this.element = element;
        }

        @Override
        protected T internalNext() throws Exception {
            T e = this.element;
            this.element = null;
            return e;
        }

        @Override
        public String toString() {
            return "ElementaryPeekIterator[next=" + this.element + "]";
        }
    }

    public static class SimplePeekIterator<T>
    extends PeekIterator<T> {
        public Iterator<T> iterator;

        @Override
        protected T internalNext() throws Exception {
            if (!this.iterator.hasNext()) {
                return null;
            }
            return this.iterator.next();
        }

        public SimplePeekIterator(Iterator<T> i) {
            this.iterator = i;
        }

        public SimplePeekIterator(Iterable<T> i) {
            this(i.iterator());
        }

        public SimplePeekIterator(T ... elements) {
            this(Arrays.asList(elements));
        }

        public SimplePeekIterator(T element) {
            this(Arrays.asList(element));
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }

        @Override
        public String toString() {
            return "Simple:" + super.toString();
        }
    }
}

