/*
 * Decompiled with CFR 0.152.
 */
package javatools.datatypes;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.Serializable;
import javatools.administrative.D;
import javatools.datatypes.SparseVector;

public class SVMModel
implements Serializable {
    private static final long serialVersionUID = 1L;
    private KernelType kernel_type;
    private int poly_degree;
    private double rbf_gamma;
    private double coef_lin;
    private double coef_const;
    private int totwords;
    private int totdoc;
    private double b;
    private SparseVector[] sv;

    private double readDouble(BufferedReader in) throws Exception {
        String s = in.readLine();
        s = s.substring(0, s.indexOf(32));
        return Double.parseDouble(s);
    }

    private int readInt(BufferedReader in) throws Exception {
        String s = in.readLine();
        s = s.substring(0, s.indexOf(32));
        return Integer.parseInt(s);
    }

    public SVMModel(String f) throws Exception {
        this(new File(f));
    }

    public SVMModel(File f) throws Exception {
        BufferedReader in = new BufferedReader(new FileReader(f));
        if (!in.readLine().equals("SVM-light Version V6.01")) {
            // empty if block
        }
        switch (this.readInt(in)) {
            case 0: {
                this.kernel_type = KernelType.LINEAR;
                break;
            }
            case 1: {
                this.kernel_type = KernelType.POLY;
                break;
            }
            case 2: {
                this.kernel_type = KernelType.RBF;
                break;
            }
            case 3: {
                this.kernel_type = KernelType.SIGMOID;
                break;
            }
            default: {
                throw new Exception("Unsupported kernel type");
            }
        }
        this.poly_degree = this.readInt(in);
        this.rbf_gamma = this.readDouble(in);
        this.coef_lin = this.readDouble(in);
        this.coef_const = this.readDouble(in);
        in.readLine();
        this.totwords = this.readInt(in);
        this.totdoc = this.readInt(in);
        int sv_num = this.readInt(in) - 1;
        this.b = this.readDouble(in);
        this.sv = new SparseVector[sv_num];
        for (int i = 0; i < this.sv.length; ++i) {
            this.sv[i] = new SparseVector(in.readLine());
        }
        in.close();
    }

    public double classify(SparseVector v) {
        double dist = 0.0;
        for (int i = 0; i < this.sv.length; ++i) {
            dist += this.kernel(this.sv[i], v) * this.sv[i].label;
        }
        return dist - this.b;
    }

    public double kernel(SparseVector a, SparseVector b) {
        switch (this.kernel_type) {
            case LINEAR: {
                return a.sprod(b);
            }
            case POLY: {
                return Math.pow(this.coef_lin * a.sprod(b) + this.coef_const, this.poly_degree);
            }
            case RBF: {
                return Math.exp(-this.rbf_gamma * (a.squaredl2norm() - 2.0 * a.sprod(b) + b.squaredl2norm()));
            }
            case SIGMOID: {
                return Math.tanh(this.coef_lin * a.sprod(b) + this.coef_const);
            }
        }
        return 0.0;
    }

    public String toString() {
        StringBuilder s = new StringBuilder("Kernel: " + (Object)((Object)this.kernel_type) + "\nPoly-Degree: " + this.poly_degree + "\nRBF-Gamma: " + this.rbf_gamma + "\nLinear coefficient: " + this.coef_lin + "\nConstant coefficient: " + this.coef_const + "\nNumber of features: " + this.totwords + "\nNumber of feature vectors: " + this.totdoc + "\nThreshold of the hyperplane: " + this.b + "\nSupport Vectors:\n");
        for (SparseVector v : this.sv) {
            s.append(v).append('\n');
        }
        return s.toString();
    }

    public static void main(String[] argv) throws Exception {
        D.p("Enter the name of an SVM-light model file");
        SVMModel m = new SVMModel(D.r());
        D.p("Enter a vector in SVM-light notation and hit ENTER. Press CTRL+C to abort");
        D.p("SVM-light notation:  <label> <dimension>:<value> ... [# <comment>]");
        while (true) {
            D.p(m.classify(new SparseVector(D.r())));
        }
    }

    public static enum KernelType {
        LINEAR,
        POLY,
        RBF,
        SIGMOID;

    }
}

