/*
 * Decompiled with CFR 0.152.
 */
package javatools.datatypes;

import java.util.NoSuchElementException;

public class SmallStack {
    protected long[] values = new long[10];
    protected int nextFree = 0;

    public SmallStack() {
    }

    public SmallStack(double d) {
        this();
        this.push(d);
    }

    public SmallStack(long d) {
        this();
        this.push(d);
    }

    public SmallStack(float d) {
        this();
        this.push(d);
    }

    public long push(long l) {
        if (this.nextFree == this.values.length) {
            long[] oldval = this.values;
            this.values = new long[this.values.length + 10];
            System.arraycopy(oldval, 0, this.values, 0, this.nextFree);
        }
        long l2 = l;
        this.values[this.nextFree++] = l2;
        return l2;
    }

    public boolean push(boolean b) {
        this.push(b ? 1L : 0L);
        return b;
    }

    public double push(double d) {
        this.push(Double.doubleToRawLongBits(d));
        return d;
    }

    public double push(float d) {
        this.push(Float.floatToIntBits(d));
        return d;
    }

    public long peekLong() {
        if (this.nextFree == 0) {
            throw new NoSuchElementException("SmallStack is empty");
        }
        return this.values[this.nextFree];
    }

    public boolean peekBoolean() {
        return this.peekLong() == 1L;
    }

    public int peekInt() {
        return (int)this.peekLong();
    }

    public float peekFloat() {
        return Float.intBitsToFloat((int)this.peekLong());
    }

    public double peekDouble() {
        return Double.longBitsToDouble(this.peekLong());
    }

    public long popLong() {
        if (this.nextFree == 0) {
            throw new NoSuchElementException("SmallStack is empty");
        }
        return this.values[--this.nextFree];
    }

    public boolean popBoolean() {
        return this.popLong() == 1L;
    }

    public int popInt() {
        return (int)this.popLong();
    }

    public float popFloat() {
        return Float.intBitsToFloat((int)this.popLong());
    }

    public double popDouble() {
        return Double.longBitsToDouble(this.popLong());
    }

    public int size() {
        return this.nextFree;
    }

    public boolean empty() {
        return this.size() == 0;
    }

    public int search(long l) {
        for (int i = 0; i < this.nextFree; ++i) {
            if (this.values[i] != l) continue;
            return i;
        }
        return -1;
    }

    public int search(double d) {
        return this.search(Double.doubleToRawLongBits(d));
    }

    public int search(boolean d) {
        return this.search(d ? 1L : 0L);
    }

    public boolean equals(Object o) {
        if (!(o instanceof SmallStack)) {
            return false;
        }
        SmallStack other = (SmallStack)o;
        if (this.nextFree != other.nextFree) {
            return false;
        }
        for (int i = 0; i < this.nextFree; ++i) {
            if (this.values[i] == other.values[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 0;
        for (int i = 0; i < this.nextFree; ++i) {
            result = (int)((long)result + this.values[i]);
            result <<= 1;
        }
        return result;
    }

    public double[] toDoubleArray() {
        double[] result = new double[this.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = Double.longBitsToDouble(this.values[i]);
        }
        return result;
    }

    public long[] toLongArray() {
        long[] result = new long[this.size()];
        System.arraycopy(this.values, 0, result, 0, this.size());
        return result;
    }

    public int[] toIntArray() {
        int[] result = new int[this.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (int)this.values[i];
        }
        return result;
    }
}

