/*
 * Decompiled with CFR 0.152.
 */
package javatools.datatypes;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javatools.administrative.D;
import javatools.datatypes.MappedIterator;
import javatools.datatypes.PeekIterator;

public class TrieMap<V>
extends AbstractMap<CharSequence, V>
implements Iterable<Map.Entry<CharSequence, V>> {
    protected TreeMap<Character, TrieMap<V>> children = new TreeMap();
    protected V value;
    protected int size = 0;
    protected TrieMap<V> parent;

    public TrieMap() {
    }

    protected TrieMap(TrieMap<V> p) {
        this.parent = p;
    }

    @Override
    public V put(CharSequence key, V value) {
        TrieMap<V> trie = this.get(key, 0, true);
        V old = trie.value;
        trie.value = value;
        ++this.size;
        return old;
    }

    @Override
    public void clear() {
        this.children.clear();
        this.value = null;
        this.size = 0;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    protected TrieMap<V> get(CharSequence s, int start, boolean create) {
        if (s.length() == start) {
            return create ? this : null;
        }
        Character c = Character.valueOf(s.charAt(start));
        if (this.children.get(c) == null) {
            this.children.put(c, new TrieMap<V>(this));
        }
        return this.children.get(c).get(s, start + 1, create);
    }

    @Override
    public boolean containsKey(Object s) {
        return s instanceof CharSequence && this.get((CharSequence)s, 0, false) != null;
    }

    @Override
    public Iterator<Map.Entry<CharSequence, V>> iterator() {
        return this.iterator("");
    }

    private Iterator<Map.Entry<CharSequence, V>> iterator(final String prefix) {
        return new PeekIterator<Map.Entry<CharSequence, V>>(){
            Iterator<Map.Entry<Character, TrieMap<V>>> treeMapIt = null;
            Iterator<Map.Entry<CharSequence, V>> subtrieIt = null;
            String localPrefix;
            boolean isInitialized = false;

            @Override
            protected Map.Entry<CharSequence, V> internalNext() throws Exception {
                if (this.treeMapIt == null) {
                    if (!this.isInitialized) {
                        this.isInitialized = true;
                        if (TrieMap.this.children != null) {
                            this.treeMapIt = TrieMap.this.children.entrySet().iterator();
                        }
                    } else {
                        return null;
                    }
                    if (TrieMap.this.value != null) {
                        return new AbstractMap.SimpleEntry(prefix, TrieMap.this.value);
                    }
                }
                while (this.subtrieIt == null || !this.subtrieIt.hasNext()) {
                    if (!this.treeMapIt.hasNext()) {
                        return null;
                    }
                    Map.Entry e = this.treeMapIt.next();
                    this.localPrefix = prefix + e.getKey();
                    TrieMap subtrie = e.getValue();
                    if (subtrie == null) continue;
                    this.subtrieIt = subtrie.iterator(this.localPrefix);
                }
                return this.subtrieIt.next();
            }
        };
    }

    @Override
    public String toString() {
        return "Trie with " + this.size() + " elements and " + this.children.size() + " children";
    }

    @Override
    public int size() {
        return this.size;
    }

    public int containedLength(CharSequence s, int startPos) {
        int terminationValue;
        int n = terminationValue = this.value != null ? 0 : -1;
        if (s.length() <= startPos) {
            return terminationValue;
        }
        Character c = Character.valueOf(s.charAt(startPos));
        if (this.children.get(c) == null) {
            return terminationValue;
        }
        int subtreelength = this.children.get(c).containedLength(s, startPos + 1);
        if (subtreelength == -1) {
            return terminationValue;
        }
        return subtreelength + 1;
    }

    public PeekIterator<CharSequence> wordsIn(final CharSequence text) {
        return new PeekIterator<CharSequence>(){
            int pos = -1;

            @Override
            public CharSequence internalNext() {
                while (++this.pos < text.length()) {
                    int subtreeLength = TrieMap.this.containedLength(text, this.pos);
                    if (subtreeLength == -1) continue;
                    return text.subSequence(this.pos, subtreeLength + this.pos);
                }
                return null;
            }
        };
    }

    public PeekIterator<Map.Entry<CharSequence, V>> entriesIn(CharSequence text) {
        final PeekIterator<CharSequence> cs = this.wordsIn(text);
        return new PeekIterator<Map.Entry<CharSequence, V>>(){

            @Override
            public Map.Entry<CharSequence, V> internalNext() {
                try {
                    CharSequence word = (CharSequence)cs.internalNext();
                    Object val = TrieMap.this.get(word);
                    return new AbstractMap.SimpleEntry(word, val);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }
        };
    }

    public static void main(String[] args) {
        TrieMap<String> t = new TrieMap<String>();
        t.put("hallo", "<hallo>");
        t.put("key", "<key>");
        t.put("du", "<du>");
        t.put("dublin", "<dublin>");
        for (Map.Entry e : t) {
            D.p(e.getKey() + ": " + (String)e.getValue());
        }
        D.p(t.wordsIn("Blah hallo blub hallo fasel du aus dublin").asList());
    }

    @Override
    public Set<Map.Entry<CharSequence, V>> entrySet() {
        return new AbstractSet<Map.Entry<CharSequence, V>>(){

            @Override
            public Iterator<Map.Entry<CharSequence, V>> iterator() {
                return TrieMap.this.iterator("");
            }

            @Override
            public int size() {
                return TrieMap.this.size();
            }
        };
    }

    public Iterable<String> strings() {
        return new MappedIterator(this.iterator(), new MappedIterator.Map<Map.Entry<CharSequence, V>, String>(){

            @Override
            public String map(Map.Entry<CharSequence, V> e) {
                return e.getKey().toString();
            }
        });
    }
}

