/*
 * Decompiled with CFR 0.152.
 */
package javatools.filehandlers;

import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Stack;
import java.util.regex.Pattern;
import javatools.administrative.D;
import javatools.datatypes.PeekIterator;

public class DeepFileSet
extends PeekIterator<File> {
    protected final Stack<File> paths = new Stack();
    protected final Pattern wildcard;
    protected Iterator<File> currentIterator;

    public Pattern patternForWildcard(String wildcard) {
        return Pattern.compile("(?i)" + wildcard.replace(".", "\\.").replace("*", ".*").replace('?', '.'));
    }

    public DeepFileSet(File folderPlusWildcard) {
        this(folderPlusWildcard.getParentFile() == null ? new File(".") : folderPlusWildcard.getParentFile(), folderPlusWildcard.getName());
    }

    public DeepFileSet(String folderPlusWildcard) {
        this(new File(folderPlusWildcard));
    }

    public DeepFileSet(File folder, String wildcard) {
        File path = folder;
        this.paths.push(path);
        this.wildcard = this.patternForWildcard(wildcard);
        this.setIterator();
    }

    protected boolean setIterator() {
        if (this.paths.size() == 0) {
            return false;
        }
        File folder = this.paths.pop();
        this.currentIterator = Arrays.asList(folder.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                if (pathname.isDirectory()) {
                    DeepFileSet.this.paths.push(pathname);
                }
                return DeepFileSet.this.wildcard.matcher(pathname.getName()).matches();
            }
        })).iterator();
        return true;
    }

    @Override
    protected File internalNext() throws Exception {
        while (!this.currentIterator.hasNext()) {
            if (this.setIterator()) continue;
            return null;
        }
        return this.currentIterator.next();
    }

    @Override
    public String toString() {
        return "DeepFileSet at " + this.paths;
    }

    public static void main(String[] argv) {
        D.p("Enter a filename with wildcards and hit ENTER. Press CTRL+C to abort");
        block0: while (true) {
            Iterator iterator = new DeepFileSet(D.r()).iterator();
            while (true) {
                if (!iterator.hasNext()) continue block0;
                File f = (File)iterator.next();
                D.p(f);
            }
            break;
        }
    }
}

