/*
 * Decompiled with CFR 0.152.
 */
package javatools.filehandlers;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javatools.parsers.Char17;
import javatools.parsers.NumberFormatter;
import javax.imageio.ImageIO;

public class FigureProducer {
    public static String latexTable(Table table) {
        StringBuilder result = new StringBuilder();
        result.append("\\begin{tabular}{|");
        for (ColumnDescriptor columnDescriptor : table.columnDescriptors) {
            result.append(Character.toLowerCase(columnDescriptor.alignment.toString().charAt(0))).append('|');
        }
        result.setLength(result.length() - 1);
        result.append("|}\n\\hline\n    ");
        if (table.hasHeader()) {
            for (ColumnDescriptor columnDescriptor : table.columnDescriptors) {
                result.append(columnDescriptor.render(columnDescriptor.header)).append(" & ");
            }
            result.setLength(result.length() - 2);
            result.append("\\\\\n\\hline\n");
        }
        for (List list : table.rows) {
            result.append("    ");
            for (int i = 0; i < table.numColumns(); ++i) {
                result.append(table.descriptorFor(i).render(list.get(i)));
                result.append(" & ");
            }
            result.setLength(result.length() - 2);
            result.append(" \\\\\n");
        }
        result.append("\\hline\n\\end{tabular}\n");
        return result.toString();
    }

    public static void latexTable(Table table, File output) throws IOException {
        BufferedWriter out = new BufferedWriter(new FileWriter(output));
        out.write(FigureProducer.latexTable(table));
        ((Writer)out).close();
    }

    public static void figure(Table table, File output) throws IOException {
        int COLHEIGHT = 100;
        int LABELHEIGHT = 20;
        int COLWIDTH = 10;
        int ROWWIDTH = 50;
        int SPACELEFT = 30;
        int SPACERIGHT = table.numColumns() == 2 ? 0 : 60;
        int TITLEHEIGHT = 20;
        int TEXTHEIGHT = 10;
        int SPACEBELOW = TEXTHEIGHT + 2;
        double maxValue = 0.0;
        for (List<Object> row : table.rows) {
            for (int i = 1; i < table.numColumns(); ++i) {
                double v = ((Number)row.get(i)).doubleValue();
                if (!(v > maxValue)) continue;
                maxValue = v;
            }
        }
        double scale = (double)COLHEIGHT / maxValue;
        Color[] colors = new Color[]{null, Color.RED, Color.BLUE, Color.GREEN, Color.MAGENTA};
        BufferedImage image = new BufferedImage(SPACELEFT + ROWWIDTH * table.numRows() + SPACERIGHT, TITLEHEIGHT + COLHEIGHT + LABELHEIGHT + SPACEBELOW, 1);
        Graphics2D graphics = image.createGraphics();
        graphics.setColor(Color.WHITE);
        graphics.fillRect(0, 0, image.getWidth() - 1, image.getHeight() - 1);
        graphics.setColor(Color.BLACK);
        graphics.drawString(table.title, SPACELEFT, 2 + TEXTHEIGHT);
        graphics.drawString(table.descriptorFor((int)0).header, SPACELEFT + ROWWIDTH / 2, image.getHeight() - 2);
        graphics.drawLine(SPACELEFT, TITLEHEIGHT, SPACELEFT, TITLEHEIGHT + COLHEIGHT);
        graphics.drawLine(SPACELEFT - 2, TITLEHEIGHT + COLHEIGHT, ROWWIDTH * table.numRows(), TITLEHEIGHT + COLHEIGHT);
        int exponent = (int)Math.floor(Math.log10(maxValue));
        int step = (int)Math.floor(Math.pow(10.0, exponent) * scale);
        graphics.drawString("0", SPACELEFT - 10, TITLEHEIGHT + COLHEIGHT + TEXTHEIGHT / 2);
        for (int pos = step; pos < COLHEIGHT; pos += step) {
            graphics.drawLine(SPACELEFT - 2, TITLEHEIGHT + COLHEIGHT - pos, SPACELEFT, TITLEHEIGHT + COLHEIGHT - pos);
            String label = "";
            switch (exponent) {
                case 0: {
                    label = "    " + pos / step;
                    break;
                }
                case 1: {
                    label = "   " + pos / step + "0";
                    break;
                }
                case 2: {
                    label = " " + pos / step + "00";
                    break;
                }
                case -1: {
                    label = "   ." + pos / step;
                    break;
                }
                case -2: {
                    label = "  .0" + pos / step;
                    break;
                }
                default: {
                    label = pos / step + "E" + exponent;
                }
            }
            graphics.drawString(label, 2, TITLEHEIGHT + COLHEIGHT - pos + TEXTHEIGHT / 2);
        }
        if (table.numColumns() > 2) {
            for (int i = 1; i < table.numColumns(); ++i) {
                graphics.setColor(colors[i]);
                graphics.drawString(table.descriptorFor((int)i).header, SPACELEFT + ROWWIDTH * table.numRows(), TITLEHEIGHT + TEXTHEIGHT * i);
            }
        }
        for (int row = 0; row < table.numRows(); ++row) {
            graphics.setColor(Color.BLACK);
            String header = table.rows.get(row).get(0).toString();
            while (graphics.getFontMetrics().stringWidth(header) > ROWWIDTH) {
                header = Char17.cutLast(header);
            }
            if (header.length() != table.rows.get(row).get(0).toString().length()) {
                header = header + '.';
            }
            graphics.drawString(header, SPACELEFT + ROWWIDTH * row, TITLEHEIGHT + COLHEIGHT + LABELHEIGHT - 2);
            for (int column = 1; column < table.numColumns(); ++column) {
                graphics.setColor(colors[column]);
                int h = (int)(((Number)table.rows.get(row).get(column)).doubleValue() * scale);
                graphics.fillRect(SPACELEFT + 2 + row * ROWWIDTH + (column - 1) * COLWIDTH, TITLEHEIGHT + COLHEIGHT - h, COLWIDTH, h);
            }
        }
        ImageIO.write((RenderedImage)image, "jpg", output);
    }

    public static void main(String[] args) throws Exception {
        Table test = new Table("Avg # edges, 3 terminals", new ColumnDescriptor("k", Alignment.LEFT, true), new ColumnDescriptor("SIN", "#.###"), new ColumnDescriptor("SIN(BI)", "#.###"), new ColumnDescriptor("BANKS I", "#.###"), new ColumnDescriptor("BANKS II", "#.###"));
        test.addRow("1", 6981, 85931, 84171, 81462);
        test.addRow("3", 18027, 124566, 153078, 132141);
        test.addRow("6", 43474, 138852, 159130, 175045);
        FigureProducer.figure(test, new File("3term.jpg"));
        test = new Table("Avg # edges, 6 terminals", new ColumnDescriptor("k", Alignment.LEFT, true), new ColumnDescriptor("SIN", "#.###"), new ColumnDescriptor("SIN(BI)", "#.###"), new ColumnDescriptor("BANKS I", "#.###"), new ColumnDescriptor("BANKS II", "#.###"));
        test.addRow("1", 9559, 375523, 372634, 365004);
        test.addRow("3", 27085, 397004, 460521, 409414);
        test.addRow("6", 76259, 447813, 503054, 491786);
        FigureProducer.figure(test, new File("6term.jpg"));
    }

    public static class Table {
        protected List<ColumnDescriptor> columnDescriptors;
        protected List<List<Object>> rows = new ArrayList<List<Object>>();
        protected String title;
        protected boolean hasHead;

        public Table(String title, ColumnDescriptor ... columnDescriptors) {
            this.columnDescriptors = Arrays.asList(columnDescriptors);
            this.title = title;
            this.hasHead = columnDescriptors.length > 0 && columnDescriptors[0].header != null;
        }

        public int numColumns() {
            return this.columnDescriptors.size();
        }

        public int numRows() {
            return this.rows.size();
        }

        public void addRow(Object ... values) {
            this.rows.add(Arrays.asList(values));
        }

        public ColumnDescriptor descriptorFor(int i) {
            return this.columnDescriptors.get(i);
        }

        public boolean hasHeader() {
            return this.hasHead;
        }
    }

    public static class ColumnDescriptor {
        public String header;
        public Alignment alignment;
        public boolean emphasize;
        public NumberFormatter formi;

        public ColumnDescriptor(String header, Alignment alignment, boolean emphasize) {
            this.header = header;
            this.alignment = alignment;
            this.emphasize = emphasize;
        }

        public ColumnDescriptor(String header, Alignment alignment) {
            this(header, alignment, false);
        }

        public ColumnDescriptor(String header) {
            this(header, Alignment.LEFT);
        }

        public ColumnDescriptor(String header, String numberPattern, boolean alignment) {
            this(header, Alignment.LEFT, alignment);
            this.formi = new NumberFormatter(numberPattern);
        }

        public ColumnDescriptor(String header, String numberPattern) {
            this(header, numberPattern, false);
        }

        public String render(Object value) {
            String result;
            String string = result = this.formi == null || !(value instanceof Number) ? value.toString() : this.formi.format(((Number)value).doubleValue());
            if (this.emphasize) {
                result = "{\\textbf " + result + "}";
            }
            return result;
        }
    }

    public static enum Alignment {
        LEFT,
        RIGHT,
        CENTER;

    }
}

