/*
 * Decompiled with CFR 0.152.
 */
package javatools.filehandlers;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javatools.administrative.Announce;
import javatools.administrative.D;
import javatools.datatypes.PeekIterator;

public class MatchReader
extends PeekIterator<MatchResult>
implements Closeable {
    public final int BUFSIZE = 1000;
    public final int MAXPATTERNLENGTH = 400;
    protected Reader in;
    protected Matcher matcher;
    protected StringBuilder buffer = new StringBuilder(1400);
    protected Pattern pattern;
    protected long chars = -1L;
    protected int lastMatchEnd = 0;
    public static final String QUOTE = "FabianSuchanek";
    protected boolean crossLines = false;

    public MatchReader(Reader i, Pattern p) {
        this.in = i;
        this.pattern = p;
        this.next();
    }

    public MatchReader(Reader i, String p) {
        this(i, Pattern.compile(p));
    }

    public MatchReader(File f, Pattern p, String announceMsg) throws FileNotFoundException {
        this.pattern = p;
        this.matcher = p.matcher(this.buffer);
        if (announceMsg != null) {
            Announce.progressStart(announceMsg, f.length());
            this.chars = 0L;
        }
        this.in = new BufferedReader(new FileReader(f));
    }

    public MatchReader(String f, Pattern p, String announceMsg) throws FileNotFoundException {
        this(new File(f), p, announceMsg);
    }

    public MatchReader(String f, String p, String announceMsg) throws FileNotFoundException {
        this(new File(f), Pattern.compile(p), announceMsg);
    }

    public MatchReader(File f, String p, String announceMsg) throws FileNotFoundException {
        this(f, Pattern.compile(p), announceMsg);
    }

    public MatchReader(File f, String p, boolean crossLines) throws FileNotFoundException {
        this(f, Pattern.compile(p), null);
        this.crossLines = crossLines;
    }

    public MatchReader(File f, String p) throws FileNotFoundException {
        this(f, p, false);
    }

    public MatchReader(String f, String p) throws FileNotFoundException {
        this(new File(f), Pattern.compile(p), null);
    }

    public MatchReader(String f, Pattern p) throws FileNotFoundException {
        this(new File(f), p, null);
    }

    public MatchReader(File f, Pattern p) throws FileNotFoundException {
        this(f, p, null);
    }

    protected MatchReader() {
    }

    protected int read() throws IOException {
        return this.in.read();
    }

    @Override
    public MatchResult internalNext() {
        while (true) {
            int len;
            if (this.matcher.find()) {
                this.lastMatchEnd = this.matcher.end();
                return new MyMatchResult(this.matcher);
            }
            if (this.lastMatchEnd < this.buffer.length() - 400) {
                this.lastMatchEnd = this.buffer.length() - 400;
            }
            this.buffer.delete(0, this.lastMatchEnd);
            for (len = 0; len < 1000; ++len) {
                int c;
                try {
                    c = this.read();
                }
                catch (IOException e) {
                    return null;
                }
                if (c == -1) break;
                if ((c == 10 || c == 13) && this.crossLines) {
                    c = 32;
                }
                if (c == 39 && this.buffer.length() > 0 && this.buffer.charAt(this.buffer.length() - 1) == '\\') {
                    this.buffer.setLength(this.buffer.length() - 1);
                    this.buffer.append(QUOTE);
                    continue;
                }
                this.buffer.append((char)c);
            }
            if (this.chars != -1L) {
                Announce.progressAt(this.chars += (long)len);
            }
            if (len == 0) {
                this.close();
                if (this.chars != -1L) {
                    Announce.progressDone();
                }
                return null;
            }
            this.matcher = this.pattern.matcher(this.buffer);
            this.lastMatchEnd = 0;
        }
    }

    @Override
    public void close() {
        try {
            this.in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void finalize() {
        this.close();
    }

    public static void main(String[] args) throws Exception {
        for (MatchResult idAndEntity : new MatchReader("c:\\Fabian\\Data\\yago\\search\\pairings.txt", Pattern.compile("(\\d+)\tu:http://[^\\:\n]*/([^/]+)\n"), "Parsing url mappings")) {
            D.p(idAndEntity.group(1), idAndEntity.group(2));
            D.r();
        }
    }

    public static class MyMatchResult
    implements MatchResult {
        public MatchResult inner;

        public MyMatchResult(Matcher m) {
            this.inner = m.toMatchResult();
        }

        @Override
        public int end() {
            return this.inner.end();
        }

        @Override
        public int end(int group) {
            return this.inner.end(group);
        }

        @Override
        public String group() {
            return this.group(0);
        }

        @Override
        public String group(int group) {
            return this.inner.group(group).replace(MatchReader.QUOTE, "'");
        }

        @Override
        public int groupCount() {
            return this.groupCount();
        }

        @Override
        public int start() {
            return this.inner.start();
        }

        @Override
        public int start(int group) {
            return this.inner.start(group);
        }
    }
}

