/*
 * Decompiled with CFR 0.152.
 */
package javatools.filehandlers;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

public class SimpleInputStreamReader
extends Reader {
    public InputStream in;

    public SimpleInputStreamReader(InputStream i) {
        this.in = i;
    }

    public SimpleInputStreamReader(File f) throws FileNotFoundException {
        this(new FileInputStream(f));
    }

    public SimpleInputStreamReader(String f) throws FileNotFoundException {
        this(new File(f));
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        byte[] bbuf = new byte[len];
        int result = this.in.read(bbuf, 0, len);
        for (int i = 0; i < result; ++i) {
            cbuf[off + i] = (char)bbuf[i];
        }
        return result;
    }

    @Override
    public int read() throws IOException {
        return this.in.read();
    }

    public static void main(String[] args) throws Exception {
        Reader r = new InputStreamReader(new ByteArrayInputStream(new byte[]{-112}));
        System.out.println(r.read());
        r.close();
        r = new SimpleInputStreamReader(new ByteArrayInputStream(new byte[]{-112}));
        System.out.println(r.read());
        r.close();
    }
}

