/*
 * Decompiled with CFR 0.152.
 */
package javatools.parsers;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.BitSet;
import java.util.Collection;

public class BloomFilter<E>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private BitSet bitset;
    private int bitSetSize;
    private int expectedNumberOfFilterElements;
    private int numberOfAddedElements;
    private int k;
    static String hashName;
    static final MessageDigest digestFunction;

    public BloomFilter(int bitSetSize, int expectedNumberOfFilterElements) {
        this.expectedNumberOfFilterElements = expectedNumberOfFilterElements;
        this.k = (int)Math.round((double)(bitSetSize / expectedNumberOfFilterElements) * Math.log(2.0));
        this.bitset = new BitSet(bitSetSize);
        this.bitSetSize = bitSetSize;
        this.numberOfAddedElements = 0;
    }

    public static long createHash(String val, String charset) throws UnsupportedEncodingException {
        return BloomFilter.createHash(val.getBytes(charset));
    }

    public static long createHash(String val) throws UnsupportedEncodingException {
        return BloomFilter.createHash(val.getBytes("UTF-8"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long createHash(byte[] data) {
        byte[] res;
        long h = 0L;
        MessageDigest messageDigest = digestFunction;
        synchronized (messageDigest) {
            res = digestFunction.digest(data);
        }
        for (int i = 0; i < 4; ++i) {
            h <<= 8;
            h |= (long)(res[i] & 0xFF);
        }
        return h;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BloomFilter other = (BloomFilter)obj;
        if (!(this.bitset == other.bitset || this.bitset != null && this.bitset.equals(other.bitset))) {
            return false;
        }
        if (this.expectedNumberOfFilterElements != other.expectedNumberOfFilterElements) {
            return false;
        }
        if (this.k != other.k) {
            return false;
        }
        return this.bitSetSize == other.bitSetSize;
    }

    public int hashCode() {
        int hash = 7;
        hash = 61 * hash + (this.bitset != null ? this.bitset.hashCode() : 0);
        hash = 61 * hash + this.expectedNumberOfFilterElements;
        hash = 61 * hash + this.bitSetSize;
        hash = 61 * hash + this.k;
        return hash;
    }

    public double expectedFalsePositiveProbability() {
        return this.getFalsePositiveProbability(this.expectedNumberOfFilterElements);
    }

    public double getFalsePositiveProbability(double numberOfElements) {
        return Math.pow(1.0 - Math.exp((double)(-this.k) * numberOfElements / (double)this.bitSetSize), this.k);
    }

    public double getFalsePositiveProbability() {
        return this.getFalsePositiveProbability(this.numberOfAddedElements);
    }

    public int getK() {
        return this.k;
    }

    public void clear() {
        this.bitset.clear();
        this.numberOfAddedElements = 0;
    }

    public void add(E element) throws UnsupportedEncodingException {
        String valString = element.toString();
        for (int x = 0; x < this.k; ++x) {
            long hash = BloomFilter.createHash(valString + Integer.toString(x));
            this.bitset.set(Math.abs((int)(hash %= (long)this.bitSetSize)), true);
        }
        ++this.numberOfAddedElements;
    }

    public void addAll(Collection<? extends E> c) throws UnsupportedEncodingException {
        for (E element : c) {
            this.add(element);
        }
    }

    public boolean contains(E element) throws UnsupportedEncodingException {
        String valString = element.toString();
        for (int x = 0; x < this.k; ++x) {
            long hash = BloomFilter.createHash(valString + Integer.toString(x));
            if (this.bitset.get(Math.abs((int)(hash %= (long)this.bitSetSize)))) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(Collection<? extends E> c) throws UnsupportedEncodingException {
        for (E element : c) {
            if (this.contains(element)) continue;
            return false;
        }
        return true;
    }

    public boolean getBit(int bit) {
        return this.bitset.get(bit);
    }

    public void setBit(int bit, boolean value) {
        this.bitset.set(bit, value);
    }

    public int size() {
        return this.bitSetSize;
    }

    public int count() {
        return this.numberOfAddedElements;
    }

    static {
        MessageDigest tmp;
        hashName = "MD5";
        try {
            tmp = MessageDigest.getInstance(hashName);
        }
        catch (NoSuchAlgorithmException e) {
            tmp = null;
        }
        digestFunction = tmp;
    }
}

