/*
 * Decompiled with CFR 0.152.
 */
package javatools.parsers;

import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javatools.administrative.D;
import javatools.datatypes.FinalMap;
import javatools.datatypes.FinalSet;
import javatools.filehandlers.FileLines;
import javatools.parsers.Char17;

public class Name {
    public static final String ANYNAME = "NAME";
    public static String roman = "\\b(?:[XIV]++)\\b";
    public static String of = "\\bof\\b";
    public static final String U = "\\p{Lu}";
    public static final String L = "\\p{Ll}";
    public static final String A = "\\p{L}";
    public static final String B = "(?:[\\s_]++)";
    public static final String BD = "\\b";
    public static final String BC = "[,\\s_]++";
    public static final String DG = "\\d";
    public static final String H = "-";
    public static final String or = "|";
    public static final String familyNamePrefix = "(?:[aA]l|[dD][ea]|[dD]el|[dD]e las|[bB]in|[dD]e la|[dD]e los|[dD]i|[zZ]u[mr]|[aA]m|[vV][oa]n de[rnm]|[vV][oa][nm]|[dD]o|[dD]')";
    public static final Pattern familyNamePrefixPattern = Pattern.compile("(?:[aA]l|[dD][ea]|[dD]el|[dD]e las|[bB]in|[dD]e la|[dD]e los|[dD]i|[zZ]u[mr]|[aA]m|[vV][oa]n de[rnm]|[vV][oa][nm]|[dD]o|[dD]')");
    public static String attributePrefix = "(?:the|der|die|il|la|le)";
    public static Pattern attributePrefixPattern = Pattern.compile(attributePrefix);
    public static final String familyNameSuffix = "(?:CBE|DBE|GBE|[jJ]r\\.?|[jJ]unior|hijo|hija|P[hH]\\.?[dD]\\.?|KBE|MBE|M\\.?D\\.|OBE|[sS]enior|[sS]r\\.?)";
    public static final Pattern familyNameSuffixPattern = Pattern.compile("(?:CBE|DBE|GBE|[jJ]r\\.?|[jJ]unior|hijo|hija|P[hH]\\.?[dD]\\.?|KBE|MBE|M\\.?D\\.|OBE|[sS]enior|[sS]r\\.?)");
    public static final String title = "\\b(?:[aA]dmiral\\b|[aA]mbassador\\b|[bB]ishop\\b|[bB]brother\\b|[cC]aptain\\b|[cC]hancellor\\b|[cC]ol\\.|[cC]olonel\\b|[cC]ommander\\b|[cC]ongressman\\b|[cC]ongresswoman\\b|[dD]rs?\\.?|[fF]ather\\b|[gG]gouverneur\\b|[gG]ov\\.\\b|[gG]overnor\\b|[hH]onorable\\b|[hH]onourable\\b|[jJ]udge\\b|[kK]ing\\b|[lL]ady\\b|[lL]ieutenant\\b|[lL]ieutenant [gG]overnor\\b|[lL]ord\\b|[mM]aj\\.|[mM]ajor\\b|[mM]aster\\b|[mM]essrs\\.?|[mM]iss\\b|[mM]rs?\\.|[mM]rs?\\b|[mM]s\\.|[mM]s\\b|[pP]ope\\b|[pP][hH]\\.?[dD]\\b|[pP]resident\\b|[pP]rof\\.?|[pP]rofessor\\b|[pP]rince\\b|[pP]rincess\\b|[rR]abbi\\b|[rR]evd?\\.|[rR]everend\\b|[qQ]ueen\\b|[sS]aint\\b|[sS]t\\.|[sS]t\\b|[sS]ecretary\\b|[sS]enator\\b|[sS]ergeant\\b|[sS]ir\\b|[sS]ister\\b|[sS]ultan\\b|[eE]mperor\\b|[eE]mpress)";
    public static final Pattern titlePattern = Pattern.compile("\\b(?:[aA]dmiral\\b|[aA]mbassador\\b|[bB]ishop\\b|[bB]brother\\b|[cC]aptain\\b|[cC]hancellor\\b|[cC]ol\\.|[cC]olonel\\b|[cC]ommander\\b|[cC]ongressman\\b|[cC]ongresswoman\\b|[dD]rs?\\.?|[fF]ather\\b|[gG]gouverneur\\b|[gG]ov\\.\\b|[gG]overnor\\b|[hH]onorable\\b|[hH]onourable\\b|[jJ]udge\\b|[kK]ing\\b|[lL]ady\\b|[lL]ieutenant\\b|[lL]ieutenant [gG]overnor\\b|[lL]ord\\b|[mM]aj\\.|[mM]ajor\\b|[mM]aster\\b|[mM]essrs\\.?|[mM]iss\\b|[mM]rs?\\.|[mM]rs?\\b|[mM]s\\.|[mM]s\\b|[pP]ope\\b|[pP][hH]\\.?[dD]\\b|[pP]resident\\b|[pP]rof\\.?|[pP]rofessor\\b|[pP]rince\\b|[pP]rincess\\b|[rR]abbi\\b|[rR]evd?\\.|[rR]everend\\b|[qQ]ueen\\b|[sS]aint\\b|[sS]t\\.|[sS]t\\b|[sS]ecretary\\b|[sS]enator\\b|[sS]ergeant\\b|[sS]ir\\b|[sS]ister\\b|[sS]ultan\\b|[eE]mperor\\b|[eE]mpress)");
    public static final String titles = "(?:\\b(?:[aA]dmiral\\b|[aA]mbassador\\b|[bB]ishop\\b|[bB]brother\\b|[cC]aptain\\b|[cC]hancellor\\b|[cC]ol\\.|[cC]olonel\\b|[cC]ommander\\b|[cC]ongressman\\b|[cC]ongresswoman\\b|[dD]rs?\\.?|[fF]ather\\b|[gG]gouverneur\\b|[gG]ov\\.\\b|[gG]overnor\\b|[hH]onorable\\b|[hH]onourable\\b|[jJ]udge\\b|[kK]ing\\b|[lL]ady\\b|[lL]ieutenant\\b|[lL]ieutenant [gG]overnor\\b|[lL]ord\\b|[mM]aj\\.|[mM]ajor\\b|[mM]aster\\b|[mM]essrs\\.?|[mM]iss\\b|[mM]rs?\\.|[mM]rs?\\b|[mM]s\\.|[mM]s\\b|[pP]ope\\b|[pP][hH]\\.?[dD]\\b|[pP]resident\\b|[pP]rof\\.?|[pP]rofessor\\b|[pP]rince\\b|[pP]rincess\\b|[rR]abbi\\b|[rR]evd?\\.|[rR]everend\\b|[qQ]ueen\\b|[sS]aint\\b|[sS]t\\.|[sS]t\\b|[sS]ecretary\\b|[sS]enator\\b|[sS]ergeant\\b|[sS]ir\\b|[sS]ister\\b|[sS]ultan\\b|[eE]mperor\\b|[eE]mpress)(?:[\\s_]++))*(?:[\\s_]++)\\b(?:[aA]dmiral\\b|[aA]mbassador\\b|[bB]ishop\\b|[bB]brother\\b|[cC]aptain\\b|[cC]hancellor\\b|[cC]ol\\.|[cC]olonel\\b|[cC]ommander\\b|[cC]ongressman\\b|[cC]ongresswoman\\b|[dD]rs?\\.?|[fF]ather\\b|[gG]gouverneur\\b|[gG]ov\\.\\b|[gG]overnor\\b|[hH]onorable\\b|[hH]onourable\\b|[jJ]udge\\b|[kK]ing\\b|[lL]ady\\b|[lL]ieutenant\\b|[lL]ieutenant [gG]overnor\\b|[lL]ord\\b|[mM]aj\\.|[mM]ajor\\b|[mM]aster\\b|[mM]essrs\\.?|[mM]iss\\b|[mM]rs?\\.|[mM]rs?\\b|[mM]s\\.|[mM]s\\b|[pP]ope\\b|[pP][hH]\\.?[dD]\\b|[pP]resident\\b|[pP]rof\\.?|[pP]rofessor\\b|[pP]rince\\b|[pP]rincess\\b|[rR]abbi\\b|[rR]evd?\\.|[rR]everend\\b|[qQ]ueen\\b|[sS]aint\\b|[sS]t\\.|[sS]t\\b|[sS]ecretary\\b|[sS]enator\\b|[sS]ergeant\\b|[sS]ir\\b|[sS]ister\\b|[sS]ultan\\b|[eE]mperor\\b|[eE]mpress)";
    public static Set<String> titlesForGivenNames = new FinalSet((Comparable[])new String[]{"brother", "father", "king", "lady", "pope", "prince", "princess", "queen", "sister", "sultan", "emperor", "empress", "st", "st."});
    public static final String companyNameSuffix = "(?:[cC][oO]\\.|[cC][oO]\\b|&(?:[\\s_]++)?[cC][oO]\\.|&(?:[\\s_]++)?[cC][oO]\\b|\\b[cC][oO][rR][pP]\\.|\\b[cC][oO][rR][pP]\\b|\\b[cC]orporation\\b|\\b[iI][nN][cC]\\.|\\b[iI][nN][cC]\\b|\\b[iI]ncorporated\\b|\\b[iI]ncorporation\\b|\\b[iI]ncorp\\.?|\\b[iI]ncorp\\b|\\b[lL][tT][dD]\\.|\\b[lL][tT][dD]\\b|\\b[lL]imited\\b)";
    public static final Pattern companyNameSuffixPattern = Pattern.compile("(?:[cC][oO]\\.|[cC][oO]\\b|&(?:[\\s_]++)?[cC][oO]\\.|&(?:[\\s_]++)?[cC][oO]\\b|\\b[cC][oO][rR][pP]\\.|\\b[cC][oO][rR][pP]\\b|\\b[cC]orporation\\b|\\b[iI][nN][cC]\\.|\\b[iI][nN][cC]\\b|\\b[iI]ncorporated\\b|\\b[iI]ncorporation\\b|\\b[iI]ncorp\\.?|\\b[iI]ncorp\\b|\\b[lL][tT][dD]\\.|\\b[lL][tT][dD]\\b|\\b[lL]imited\\b)");
    public static final String teamName = "\\b\\p{Lu}[\\w\\s\\.]+\\b";
    public static final Pattern teamNamePattern = Pattern.compile("\\b\\p{Lu}[\\w\\s\\.]+\\b");
    public static final String prep = "(?:on|of|for)";
    public static final String laxName = "\\b\\p{Lu}.*\\b";
    public static final Pattern laxNamePattern = Pattern.compile("\\b\\p{Lu}.*\\b");
    public static final String safeName = "\\b\\p{Lu}(-[\\p{Lu}\\d]|[\\p{Lu}\\p{Ll}\\d]){2,}\\b";
    public static final Pattern safeNamePattern = Pattern.compile("\\b\\p{Lu}(-[\\p{Lu}\\d]|[\\p{Lu}\\p{Ll}\\d]){2,}\\b");
    public static final Pattern safeNamesPattern = Pattern.compile("\\b\\p{Lu}(-[\\p{Lu}\\d]|[\\p{Lu}\\p{Ll}\\d]){2,}\\b" + Name.optMul("(?:[\\s_]++)" + Name.opt("(?:on|of|for)(?:[\\s_]++)") + "\\b\\p{Lu}(-[\\p{Lu}\\d]|[\\p{Lu}\\p{Ll}\\d]){2,}\\b"));
    public static final Pattern safeNamesPatternNoPrep = Pattern.compile("\\b\\p{Lu}(-[\\p{Lu}\\d]|[\\p{Lu}\\p{Ll}\\d]){2,}\\b" + Name.optMul("(?:[\\s_]++)\\b\\p{Lu}(-[\\p{Lu}\\d]|[\\p{Lu}\\p{Ll}\\d]){2,}\\b"));
    protected String original;
    protected String normalized;
    public static final Pattern laxAbbreviationPattern = Pattern.compile("\\b\\p{Lu}[\\p{Lu}\\d(?:[\\s_]++)-]++\\b");
    public static final Pattern safeAbbreviationPattern = Pattern.compile("\\b\\p{Lu}[\\p{Lu}\\d-\\.]++\\b");
    public static final Pattern laxCompanyPattern = Pattern.compile("(" + laxNamePattern + ")" + "[,\\s_]++" + "(" + "(?:[cC][oO]\\.|[cC][oO]\\b|&(?:[\\s_]++)?[cC][oO]\\.|&(?:[\\s_]++)?[cC][oO]\\b|\\b[cC][oO][rR][pP]\\.|\\b[cC][oO][rR][pP]\\b|\\b[cC]orporation\\b|\\b[iI][nN][cC]\\.|\\b[iI][nN][cC]\\b|\\b[iI]ncorporated\\b|\\b[iI]ncorporation\\b|\\b[iI]ncorp\\.?|\\b[iI]ncorp\\b|\\b[lL][tT][dD]\\.|\\b[lL][tT][dD]\\b|\\b[lL]imited\\b)" + ")");
    public static final Pattern safeCompanyPattern = Pattern.compile("(" + safeNamesPatternNoPrep + Name.opt(Name.opt("(?:[\\s_]++)") + "&" + Name.opt("(?:[\\s_]++)") + safeNamesPatternNoPrep) + ")" + "[,\\s_]++" + "(" + "(?:[cC][oO]\\.|[cC][oO]\\b|&(?:[\\s_]++)?[cC][oO]\\.|&(?:[\\s_]++)?[cC][oO]\\b|\\b[cC][oO][rR][pP]\\.|\\b[cC][oO][rR][pP]\\b|\\b[cC]orporation\\b|\\b[iI][nN][cC]\\.|\\b[iI][nN][cC]\\b|\\b[iI]ncorporated\\b|\\b[iI]ncorporation\\b|\\b[iI]ncorp\\.?|\\b[iI]ncorp\\b|\\b[lL][tT][dD]\\.|\\b[lL][tT][dD]\\b|\\b[lL]imited\\b)" + ")");
    public static final String directFamilyNamePrefix = "\\b(?:(?:al-|Mc|Di|De|Mac|O')(?:[\\s_]++)?)";
    public static final String personNameComponent = "\\p{Lu}\\p{Ll}+";
    public static final String givenNameComponent = Name.or(Name.or("\\p{Lu}\\p{Ll}+\\b", "\\p{Lu}\\p{Ll}*+\\."), "\\p{Lu}\\b");
    public static final String givenName = "\\b" + Name.mulHyp(givenNameComponent);
    public static final String givenNames = Name.mul(givenName);
    public static final String familyName = "\\b" + Name.mulHyp(Name.opt("\\b(?:(?:al-|Mc|Di|De|Mac|O')(?:[\\s_]++)?)") + "\\p{Lu}\\p{Ll}+") + "\\b";
    public static final String nickName = "(?:'[^']')";
    public static final Pattern laxPersonNamePattern = Pattern.compile(Name.c(Name.optMul("\\b(?:[aA]dmiral\\b|[aA]mbassador\\b|[bB]ishop\\b|[bB]brother\\b|[cC]aptain\\b|[cC]hancellor\\b|[cC]ol\\.|[cC]olonel\\b|[cC]ommander\\b|[cC]ongressman\\b|[cC]ongresswoman\\b|[dD]rs?\\.?|[fF]ather\\b|[gG]gouverneur\\b|[gG]ov\\.\\b|[gG]overnor\\b|[hH]onorable\\b|[hH]onourable\\b|[jJ]udge\\b|[kK]ing\\b|[lL]ady\\b|[lL]ieutenant\\b|[lL]ieutenant [gG]overnor\\b|[lL]ord\\b|[mM]aj\\.|[mM]ajor\\b|[mM]aster\\b|[mM]essrs\\.?|[mM]iss\\b|[mM]rs?\\.|[mM]rs?\\b|[mM]s\\.|[mM]s\\b|[pP]ope\\b|[pP][hH]\\.?[dD]\\b|[pP]resident\\b|[pP]rof\\.?|[pP]rofessor\\b|[pP]rince\\b|[pP]rincess\\b|[rR]abbi\\b|[rR]evd?\\.|[rR]everend\\b|[qQ]ueen\\b|[sS]aint\\b|[sS]t\\.|[sS]t\\b|[sS]ecretary\\b|[sS]enator\\b|[sS]ergeant\\b|[sS]ir\\b|[sS]ister\\b|[sS]ultan\\b|[eE]mperor\\b|[eE]mpress)(?:[\\s_]++)")) + Name.c(Name.optMul(givenName + "(?:[\\s_]++)")) + Name.opt(Name.c("(?:'[^']')") + "(?:[\\s_]++)") + Name.opt(Name.c(attributePrefix) + "(?:[\\s_]++)") + Name.opt(Name.c("(?:[aA]l|[dD][ea]|[dD]el|[dD]e las|[bB]in|[dD]e la|[dD]e los|[dD]i|[zZ]u[mr]|[aA]m|[vV][oa]n de[rnm]|[vV][oa][nm]|[dD]o|[dD]')") + "(?:[\\s_]++)") + Name.c(familyName) + Name.opt("[,\\s_]++" + Name.c("(?:CBE|DBE|GBE|[jJ]r\\.?|[jJ]unior|hijo|hija|P[hH]\\.?[dD]\\.?|KBE|MBE|M\\.?D\\.|OBE|[sS]enior|[sS]r\\.?)")) + Name.opt("(?:[\\s_]++)" + Name.c(roman)) + Name.opt("(?:[\\s_]++)" + of + "(?:[\\s_]++)" + Name.c("\\p{Lu}\\p{Ll}+")) + Name.opt("(?:[\\s_]++)" + Name.c("(?:'[^']')")));
    public static final String safePersonName = "\\b(?:[aA]dmiral\\b|[aA]mbassador\\b|[bB]ishop\\b|[bB]brother\\b|[cC]aptain\\b|[cC]hancellor\\b|[cC]ol\\.|[cC]olonel\\b|[cC]ommander\\b|[cC]ongressman\\b|[cC]ongresswoman\\b|[dD]rs?\\.?|[fF]ather\\b|[gG]gouverneur\\b|[gG]ov\\.\\b|[gG]overnor\\b|[hH]onorable\\b|[hH]onourable\\b|[jJ]udge\\b|[kK]ing\\b|[lL]ady\\b|[lL]ieutenant\\b|[lL]ieutenant [gG]overnor\\b|[lL]ord\\b|[mM]aj\\.|[mM]ajor\\b|[mM]aster\\b|[mM]essrs\\.?|[mM]iss\\b|[mM]rs?\\.|[mM]rs?\\b|[mM]s\\.|[mM]s\\b|[pP]ope\\b|[pP][hH]\\.?[dD]\\b|[pP]resident\\b|[pP]rof\\.?|[pP]rofessor\\b|[pP]rince\\b|[pP]rincess\\b|[rR]abbi\\b|[rR]evd?\\.|[rR]everend\\b|[qQ]ueen\\b|[sS]aint\\b|[sS]t\\.|[sS]t\\b|[sS]ecretary\\b|[sS]enator\\b|[sS]ergeant\\b|[sS]ir\\b|[sS]ister\\b|[sS]ultan\\b|[eE]mperor\\b|[eE]mpress)(?:[\\s_]++)" + givenNames + "(?:[\\s_]++)" + Name.opt("(?:[aA]l|[dD][ea]|[dD]el|[dD]e las|[bB]in|[dD]e la|[dD]e los|[dD]i|[zZ]u[mr]|[aA]m|[vV][oa]n de[rnm]|[vV][oa][nm]|[dD]o|[dD]')(?:[\\s_]++)") + familyName + Name.opt("[,\\s_]++(?:CBE|DBE|GBE|[jJ]r\\.?|[jJ]unior|hijo|hija|P[hH]\\.?[dD]\\.?|KBE|MBE|M\\.?D\\.|OBE|[sS]enior|[sS]r\\.?)") + "|" + "\\b(?:[aA]dmiral\\b|[aA]mbassador\\b|[bB]ishop\\b|[bB]brother\\b|[cC]aptain\\b|[cC]hancellor\\b|[cC]ol\\.|[cC]olonel\\b|[cC]ommander\\b|[cC]ongressman\\b|[cC]ongresswoman\\b|[dD]rs?\\.?|[fF]ather\\b|[gG]gouverneur\\b|[gG]ov\\.\\b|[gG]overnor\\b|[hH]onorable\\b|[hH]onourable\\b|[jJ]udge\\b|[kK]ing\\b|[lL]ady\\b|[lL]ieutenant\\b|[lL]ieutenant [gG]overnor\\b|[lL]ord\\b|[mM]aj\\.|[mM]ajor\\b|[mM]aster\\b|[mM]essrs\\.?|[mM]iss\\b|[mM]rs?\\.|[mM]rs?\\b|[mM]s\\.|[mM]s\\b|[pP]ope\\b|[pP][hH]\\.?[dD]\\b|[pP]resident\\b|[pP]rof\\.?|[pP]rofessor\\b|[pP]rince\\b|[pP]rincess\\b|[rR]abbi\\b|[rR]evd?\\.|[rR]everend\\b|[qQ]ueen\\b|[sS]aint\\b|[sS]t\\.|[sS]t\\b|[sS]ecretary\\b|[sS]enator\\b|[sS]ergeant\\b|[sS]ir\\b|[sS]ister\\b|[sS]ultan\\b|[eE]mperor\\b|[eE]mpress)" + "(?:[\\s_]++)" + Name.opt("(?:[aA]l|[dD][ea]|[dD]el|[dD]e las|[bB]in|[dD]e la|[dD]e los|[dD]i|[zZ]u[mr]|[aA]m|[vV][oa]n de[rnm]|[vV][oa][nm]|[dD]o|[dD]')(?:[\\s_]++)") + familyName + Name.opt("[,\\s_]++(?:CBE|DBE|GBE|[jJ]r\\.?|[jJ]unior|hijo|hija|P[hH]\\.?[dD]\\.?|KBE|MBE|M\\.?D\\.|OBE|[sS]enior|[sS]r\\.?)") + "|" + givenName + "(?:[\\s_]++)" + roman + "|" + givenNames + "(?:[\\s_]++)" + Name.opt("(?:[aA]l|[dD][ea]|[dD]el|[dD]e las|[bB]in|[dD]e la|[dD]e los|[dD]i|[zZ]u[mr]|[aA]m|[vV][oa]n de[rnm]|[vV][oa][nm]|[dD]o|[dD]')(?:[\\s_]++)") + familyName + "[,\\s_]++" + "(?:CBE|DBE|GBE|[jJ]r\\.?|[jJ]unior|hijo|hija|P[hH]\\.?[dD]\\.?|KBE|MBE|M\\.?D\\.|OBE|[sS]enior|[sS]r\\.?)" + "|" + Name.opt("(?:[aA]l|[dD][ea]|[dD]el|[dD]e las|[bB]in|[dD]e la|[dD]e los|[dD]i|[zZ]u[mr]|[aA]m|[vV][oa]n de[rnm]|[vV][oa][nm]|[dD]o|[dD]')(?:[\\s_]++)") + familyName + "[,\\s_]++" + "(?:CBE|DBE|GBE|[jJ]r\\.?|[jJ]unior|hijo|hija|P[hH]\\.?[dD]\\.?|KBE|MBE|M\\.?D\\.|OBE|[sS]enior|[sS]r\\.?)" + "|" + givenName + "(?:[\\s_]++)" + "\\p{Lu}" + "\\." + "(?:[\\s_]++)" + Name.opt("(?:[aA]l|[dD][ea]|[dD]el|[dD]e las|[bB]in|[dD]e la|[dD]e los|[dD]i|[zZ]u[mr]|[aA]m|[vV][oa]n de[rnm]|[vV][oa][nm]|[dD]o|[dD]')(?:[\\s_]++)") + familyName + Name.opt("[,\\s_]++(?:CBE|DBE|GBE|[jJ]r\\.?|[jJ]unior|hijo|hija|P[hH]\\.?[dD]\\.?|KBE|MBE|M\\.?D\\.|OBE|[sS]enior|[sS]r\\.?)") + "|" + givenName + "(?:[\\s_]++)" + "\\p{Lu}" + "\\." + "(?:[\\s_]++)" + "\\p{Lu}" + "\\." + "(?:[\\s_]++)" + Name.opt("(?:[aA]l|[dD][ea]|[dD]el|[dD]e las|[bB]in|[dD]e la|[dD]e los|[dD]i|[zZ]u[mr]|[aA]m|[vV][oa]n de[rnm]|[vV][oa][nm]|[dD]o|[dD]')(?:[\\s_]++)") + familyName + Name.opt("[,\\s_]++(?:CBE|DBE|GBE|[jJ]r\\.?|[jJ]unior|hijo|hija|P[hH]\\.?[dD]\\.?|KBE|MBE|M\\.?D\\.|OBE|[sS]enior|[sS]r\\.?)");
    public static final Pattern safePersonNamePattern = Pattern.compile(safePersonName);
    public static FinalSet<String> stopWords = new FinalSet((Comparable[])new String[]{"a", "about", "above", "across", "after", "afterwards", "again", "against", "all", "almost", "alone", "along", "also", "although", "always", "am", "among", "amongst", "an", "and", "another", "any", "anybody", "anyhow", "anyone", "anything", "anyway", "anyways", "anywhere", "apart", "appear", "appreciate", "appropriate", "around", "as", "aside", "ask", "asking", "associated", "at", "available", "away", "awfully", "b", "because", "before", "beforehand", "behind", "being", "below", "beside", "besides", "best", "better", "between", "beyond", "both", "brief", "but", "by", "c", "c'mon", "c's", "cause", "certain", "certainly", "changes", "clearly", "co", "com", "concerning", "consequently", "corresponding", "course", "currently", "d", "definitely", "described", "despite", "different", "down", "downwards", "during", "e", "each", "edu", "eg", "eight", "either", "else", "elsewhere", "enough", "entirely", "especially", "et", "etc", "even", "ever", "every", "everybody", "everyone", "everything", "everywhere", "ex", "exactly", "example", "except", "f", "far", "few", "fifth", "first", "five", "for", "former", "formerly", "forth", "four", "from", "further", "furthermore", "g", "greetings", "h", "happens", "hardly", "he", "he's", "hello", "help", "hence", "her", "here", "here's", "hereafter", "hereby", "herein", "hereupon", "hers", "herself", "hi", "him", "himself", "his", "hither", "hopefully", "how", "howbeit", "however", "i", "i'd", "i'll", "i'm", "i've", "ie", "if", "immediate", "in", "inasmuch", "inc", "indeed", "inner", "insofar", "instead", "into", "inward", "is", "isn't", "it", "it'd", "it'll", "it's", "its", "itself", "j", "just", "k", "l", "last", "lately", "later", "latter", "latterly", "least", "less", "lest", "let", "let's", "likely", "little", "ltd", "m", "mainly", "many", "may", "maybe", "me", "mean", "meanwhile", "merely", "might", "more", "moreover", "most", "mostly", "much", "must", "my", "myself", "n", "name", "namely", "nd", "near", "nearly", "necessary", "need", "needs", "neither", "never", "nevertheless", "next", "nine", "no", "nobody", "non", "none", "noone", "nor", "normally", "not", "nothing", "novel", "now", "nowhere", "o", "obviously", "of", "off", "often", "oh", "ok", "okay", "old", "on", "once", "one", "ones", "only", "onto", "or", "other", "others", "otherwise", "ought", "our", "ours", "ourselves", "out", "outside", "over", "overall", "own", "p", "particular", "particularly", "per", "perhaps", "placed", "please", "plus", "possible", "presumably", "probably", "provides", "q", "que", "quite", "qv", "r", "rather", "rd", "re", "really", "reasonably", "regardless", "relatively", "respectively", "s", "same", "saw", "second", "secondly", "see", "seeing", "self", "selves", "sensible", "sent", "serious", "seriously", "seven", "several", "shall", "she", "since", "six", "so", "some", "somebody", "somehow", "someone", "something", "sometime", "sometimes", "somewhat", "somewhere", "soon", "sorry", "still", "sub", "such", "sup", "sure", "t", "t's", "th", "than", "thank", "thanks", "thanx", "that", "that's", "thats", "the", "their", "theirs", "them", "themselves", "then", "thence", "there", "there's", "thereafter", "thereby", "therefore", "therein", "theres", "thereupon", "these", "they", "they'd", "they'll", "they're", "they've", "think", "third", "this", "thorough", "thoroughly", "those", "though", "three", "through", "throughout", "thru", "thus", "to", "together", "too", "toward", "towards", "truly", "twice", "two", "u", "un", "under", "unfortunately", "unless", "unlikely", "until", "unto", "up", "upon", "us", "useful", "usually", "uucp", "v", "value", "various", "very", "via", "viz", "vs", "w", "way", "we", "we'd", "we'll", "we're", "we've", "well", "went", "what", "what's", "whatever", "when", "whence", "whenever", "where", "where's", "whereafter", "whereas", "whereby", "wherein", "whereupon", "wherever", "whether", "which", "while", "whither", "who", "who's", "whoever", "whole", "whom", "whose", "why", "willing", "wish", "with", "within", "without", "wonder", "x", "y", "yes", "yet", "you", "you'd", "you'll", "you're", "you've", "your", "yours", "yourself", "yourselves", "z", "zero"});
    public static Map<String, String> usStates = new FinalMap<String, String>("AL", "Alabama", "AK", "Alaska", "AS", "American Samoa", "AZ", "Arizona", "AR", "Arkansas", "CA", "California", "CALIF", "California", "CO", "Colorado", "CT", "Connecticut", "DE", "Delaware", "DC", "District of Columbia", "FM", "Federated States of Micronesia", "FL", "Florida", "GA", "Georgia", "GU", "Guam", "HI", "Hawaii", "ID", "Idaho", "IL", "Illinois", "IN", "Indiana", "IA", "Iowa", "KS", "Kansas", "KY", "Kentucky", "LA", "Louisiana", "ME", "Maine", "MH", "Marshall Islands", "MD", "Maryland", "MA", "Massachusetts", "MI", "Michigan", "MN", "Minnesota", "MS", "Mississippi", "MO", "Missouri", "MT", "Montana", "NE", "Nebraska", "NV", "Nevada", "NH", "New Hampshire", "NJ", "New Jersey", "NM", "New Mexico", "NY", "New York", "NC", "North Carolina", "ND", "North Dakota", "MP", "Northern Mariana Islands", "OH", "Ohio", "OK", "Oklahoma", "OR", "Oregon", "PW", "Palau", "PA", "Pennsylvania", "PR", "Puerto Rico", "RI", "Rhode Island", "SC", "South Carolina", "SD", "South Dakota", "TN", "Tennessee", "TX", "Texas", "UT", "Utah", "VT", "Vermont", "VI", "Virgin Islands", "VA", "Virginia", "WA", "Washington", "WV", "West Virginia", "WI", "Wisconsin", "WY", "Wyoming");
    public static Map<String, String> languageCodes = new FinalMap<String, String>("aa", "Afar", "ab", "Abkhazian", "ae", "Avestan", "af", "Afrikaans", "ak", "Akan", "am", "Amharic", "an", "Aragonese", "ar", "Arabic", "as", "Assamese", "av", "Avaric", "ay", "Aymara", "az", "Azerbaijani", "ba", "Bashkir", "be", "Belarusian", "bg", "Bulgarian", "bh", "Bihari", "bi", "Bislama", "bm", "Bambara", "bn", "Bengali", "bo", "Tibetan", "br", "Breton", "bs", "Bosnian", "ca", "Catalan", "ce", "Chechen", "ch", "Chamorro", "co", "Corsican", "cr", "Cree", "cs", "Czech", "cu", "Church", "cv", "Chuvash", "cy", "Welsh", "da", "Danish", "de", "German", "dv", "Divehi", "dz", "Dzongkha", "ee", "Ewe", "el", "Greek", "en", "English", "eo", "Esperanto", "es", "Spanish", "et", "Estonian", "eu", "Basque", "fa", "Persian", "ff", "Fulah", "fi", "Finnish", "fj", "Fijian", "fo", "Faroese", "fr", "French", "fy", "Western Frisian", "ga", "Irish", "gd", "Scottish", "gl", "Galician", "gn", "Guaran\ufffd", "gu", "Gujarati", "gv", "Manx", "ha", "Hausa", "he", "Hebrew", "hi", "Hindi", "ho", "Hiri", "hr", "Croatian", "ht", "Haitian", "hu", "Hungarian", "hy", "Armenian", "hz", "Herero", "ia", "Interlingua", "id", "Indonesian", "ie", "Interlingue", "ig", "Igbo", "ii", "Sichuan", "ik", "Inupiaq", "io", "Ido", "is", "Icelandic", "it", "Italian", "iu", "Inuktitut", "ja", "Japanese", "jv", "Javanese", "ka", "Georgian", "kg", "Kongo", "ki", "Kikuyu", "kj", "Kwanyama", "kk", "Kazakh", "kl", "Kalaallisut", "km", "Khmer", "kn", "Kannada", "ko", "Korean", "kr", "Kanuri", "ks", "Kashmiri", "ku", "Kurdish", "kv", "Komi", "kw", "Cornish", "ky", "Kirghiz", "la", "Latin", "lb", "Luxembourgish", "lg", "Ganda", "li", "Limburgish", "ln", "Lingala", "lo", "Lao", "lt", "Lithuanian", "lu", "Luba-Katanga", "lv", "Latvian", "mg", "Malagasy", "mh", "Marshallese", "mi", "Maori", "mk", "Macedonian", "ml", "Malayalam", "mn", "Mongolian", "mo", "Moldavian", "mr", "Marathi", "ms", "Malay", "mt", "Maltese", "my", "Burmese", "na", "Nauru", "nb", "Norwegian", "nd", "North", "ne", "Nepali", "ng", "Ndonga", "nl", "Dutch", "nn", "Norwegian", "no", "Norwegian", "nr", "South", "nv", "Navajo", "ny", "Chichewa", "oc", "Occitan", "oj", "Ojibwa", "om", "Oromo", "or", "Oriya", "os", "Ossetian", "pa", "Panjabi", "pi", "Pali", "pl", "Polish", "ps", "Pashto", "pt", "Portuguese", "qu", "Quechua", "rm", "Raeto-Romance", "rn", "Kirundi", "ro", "Romanian", "ru", "Russian", "rw", "Kinyarwanda", "ry", "Rusyn", "sa", "Sanskrit", "sc", "Sardinian", "sd", "Sindhi", "se", "Northern", "sg", "Sango", "sh", "Serbo-Croatian", "si", "Sinhalese", "sk", "Slovak", "sl", "Slovenian", "sm", "Samoan", "sn", "Shona", "so", "Somali", "sq", "Albanian", "sr", "Serbian", "ss", "Swati", "st", "Sotho", "su", "Sundanese", "sv", "Swedish", "sw", "Swahili", "ta", "Tamil", "te", "Telugu", "tg", "Tajik", "th", "Thai", "ti", "Tigrinya", "tk", "Turkmen", "tl", "Tagalog", "tn", "Tswana", "to", "Tonga", "tr", "Turkish", "ts", "Tsonga", "tt", "Tatar", "tw", "Twi", "ty", "Tahitian", "ug", "Uighur", "uk", "Ukrainian", "ur", "Urdu", "uz", "Uzbek", "ve", "Venda", "vi", "Vietnamese", "vo", "Volap\ufffdk", "wa", "Walloon", "wo", "Wolof", "xh", "Xhosa", "yi", "Yiddish", "yo", "Yoruba", "za", "Zhuang", "zh", "Chinese", "zu", "Zulu");
    public static Map<String, String> nationality2country = new FinalMap<String, String>("African", "Africa", "Antarctic", "Antarctica", "Americana", "Americas", "Asian", "Asia", "Middle Eastern", "Middle East", "Australasian", "Australasia", "Australian", "Australia", "Eurasian", "Eurasia", "European", "Europe", "North American", "North America", "Oceanian", "Oceania", "South American", "South America", "Afghan", "Afghanistan", "Albanian", "Albania", "Algerian", "Algeria", "American Samoan", "American Samoa", "Andorran", "Andorra", "Angolan", "Angola", "Anguillan", "Anguilla", "Antiguan", "Antigua and Barbuda", "Argentine", "Argentina", "Argentinean", "Argentina", "Argentinian", "Argentina", "Armenian", "Armenia", "Aruban", "Aruba", "Austrian", "Austria", "Azerbaijani", "Azerbaijan", "Azeri", "Azerbaijan", "Bahamian", "Bahamas", "Bahraini", "Bahrain", "Bangladeshi", "Bangladesh", "Barbadian", "Barbados", "Bajan", "Barbados", "Belarusian", "Belarus", "Belgian", "Belgium", "Belizean", "Belize", "Beninese", "Benin", "Bermudian", "Bermuda", "Bermudan", "Bermuda", "Bhutanese", "Bhutan", "Bolivian", "Bolivia", "Bosnian", "Bosnia and Herzegovina", "Bosniak", "Bosnia and Herzegovina", "Herzegovinian", "Bosnia and Herzegovina", "Botswanan", "Botswana", "Brazilian", "Brazil", "British Virgin Island", "British Virgin Islands", "Bruneian", "Brunei", "Bulgarian", "Bulgaria", "Burkinabe", "Burkina Fasoa", "Burmese", "Burmab", "Burundian", "Burundi", "Cambodian", "Cambodia", "Cameroonian", "Cameroon", "Canadian", "Canada", "Cape Verdean", "Cape Verde", "Caymanian", "Cayman Islands", "Central African", "Central African Republic", "Chadian", "Chad", "Chilean", "Chile", "Chinese", "People's Republic of China", "See Taiwan", "Republic of China", "Christmas Island", "Christmas Island", "Cocos Island", "Cocos (Keeling) Islands", "Colombian", "Colombia", "Comorian", "Comoros", "Congolese", "Democratic Republic of the Congo", "Cook Island", "Cook Islands", "Costa Rican", "Costa Rica", "Ivorian", "C\u00f4te d'Ivoire", "Croatian", "Croatia", "Cuban", "Cuba", "Cypriot", "Cyprus", "Czech", "Czech Republic", "Danish", "Denmark", "Djiboutian", "Djibouti", "Dominicand", "Dominica", "Dominicane", "Dominican Republic", "Timorese", "East Timor", "Ecuadorian", "Ecuador", "Egyptian", "Egypt", "Salvadoran", "El Salvador", "English", "England", "Equatorial Guinean", "Equatorial Guinea", "Eritrean", "Eritrea", "Estonian", "Estonia", "Ethiopian", "Ethiopia", "Falkland Island", "Falkland Islands", "Faroese", "Faroe Islands", "Fijian", "Fiji", "Finnish", "Finland", "French", "France", "French Guianese", "French Guiana", "French Polynesian", "French Polynesia", "Gabonese", "Gabon", "Gambian", "Gambia", "Georgian", "Georgia", "German", "Germany", "Ghanaian", "Ghana", "Gibraltar", "Gibraltar", "Greek", "Greece", "Greenlandic", "Greenland", "Grenadian", "Grenada", "Guadeloupe", "Guadeloupe", "Guamanian", "Guam", "Guatemalan", "Guatemala", "Guinean", "Guinea", "Guyanese", "Guyana", "Haitian", "Haiti", "Honduran", "Honduras", "Hong Kong", "Hong Kong", "Hungarian", "Hungary", "Icelandic", "Iceland", "Indian", "India", "Indonesian", "Indonesia", "Iranian", "Iran", "Iraqi", "Iraq", "Manx", "Isle of Man", "Israeli", "Israel", "Italian", "Italy", "Jamaican", "Jamaica", "Japanese", "Japan", "Jordanian", "Jordan", "Kazakhstaniz", "Kazakhstan", "Kenyan", "Kenya", "I-Kiribati", "Kiribati", "North Korean", "North Korea", "South Korean", "South Korea", "Kosovar", "Kosovo", "Kuwaiti", "Kuwait", "Kyrgyzstani", "Kyrgyzstan", "Laotian", "Laos", "Latvian", "Latvia", "Lebanese", "Lebanon", "Basotho", "Lesotho", "Liberian", "Liberia", "Libyan", "Libya", "Liechtenstein", "Liechtenstein", "Lithuanian", "Lithuania", "Luxembourg", "Luxembourg", "Macanese", "Macau", "Macedonian", "Republic of Macedonia", "Malagasy", "Madagascar", "Malawian", "Malawi", "Malaysian", "Malaysia", "Maldivian", "Maldives", "Malian", "Mali", "Maltese", "Malta", "Marshallese", "Marshall Islands", "Martiniquais", "Martinique", "Mauritanian", "Mauritania", "Mauritian", "Mauritius", "Mahoran", "Mayotte", "Mexican", "Mexico", "Micronesian", "Micronesia", "Moldovan", "Moldova", "Mon\u00e9gasque", "Monaco", "Mongolian", "Mongolia", "Montenegrin", "Montenegro", "Montserratian", "Montserrat", "Moroccan", "Morocco", "Mozambican", "Mozambique", "Namibian", "Namibia", "Nauruan", "Nauru", "Nepali", "Nepal", "Dutch", "Netherlands", "Dutch Antillean", "Netherlands Antilles", "New Caledonian", "New Caledonia", "New Zealand", "New Zealand", "Nicaraguan", "Nicaragua", "Niuean", "Niue", "Nigerien", "Niger", "Nigerian", "Nigeria", "Norwegian", "Norway", "Northern Irish", "Northern Ireland", "Northern Marianan", "Northern Marianas", "Omani", "Oman", "Pakistani", "Pakistan", "Palestinian", "Palestinian territories", "Palauan", "Palau", "Panamanian", "Panama", "Papua New Guinean", "Papua New Guinea", "Paraguayan", "Paraguay", "Peruvian", "Peru", "Philippine", "Philippines", "Filipino", "Philippines", "Pitcairn Island", "Pitcairn Island", "Polish", "Poland", "Portuguese", "Portugal", "Puerto Rican", "Puerto Rico", "Qatari", "Qatar", "Irish", "Republic of Ireland", "R\u00e9unionese", "R\u00e9union", "Romanian", "Romania", "Russian", "Russia", "Rwandan", "Rwanda", "St. Helenian", "St. Helena", "Kittitian", "St. Kitts and Nevis", "St. Lucian", "St. Lucia", "Saint-Pierrais", "Saint-Pierre and Miquelon", "St. Vincentian", "St. Vincent and the Grenadines", "Samoan", "Samoa", "Sammarinese", "San Marino", "S\u00e3o Tom\u00e9an", "S\u00e3o Tom\u00e9 and Pr\u00edncipe", "Saudi", "Saudi Arabia", "Scottish", "Scotland", "Senegalese", "Senegal", "Serbian", "Serbia", "Seychellois", "Seychelles", "Sierra Leonean", "Sierra Leone", "Singaporean", "Singapore", "Slovak", "Slovakia", "Slovene", "Slovenia", "Slovenian", "Slovenia", "Solomon Island", "Solomon Islands", "Somali", "Somalia", "Somaliland", "Somaliland", "South African", "South Africa", "Spanish", "Spain", "Sri Lankan", "Sri Lanka", "Sudanese", "Sudan", "Surinamese", "Surinam", "Swazi", "Swaziland", "Swedish", "Sweden", "Swiss", "Switzerland", "Syrian", "Syria", "Taiwanese", "Taiwan", "Tajikistani", "Tajikistan", "Tanzanian", "Tanzania", "Thai", "Thailand", "Togolese", "Togo", "Tongan", "Tonga", "Trinidadian", "Trinidad and Tobago", "Tunisian", "Tunisia", "Turkish", "Turkey", "Turkmen", "Turkmenistan", "Tuvaluan", "Tuvalu", "Ugandan", "Uganda", "Ukrainian", "Ukraine", "Emirati", "United Arab Emirates", "British", "United Kingdom", "American", "United States of America", "Uruguayan", "Uruguay", "Uzbekistani", "Uzbekistan", "Uzbek", "Uzbekistan", "Vanuatuan", "Vanuatu", "Venezuelan", "Venezuela", "Vietnamese", "Vietnam", "Virgin Island", "Virgin Islands", "Welsh", "Wales", "Wallisian", "Wallis and Futuna", "Sahrawi", "Western Sahara", "Yemeni", "Yemen", "Zambian", "Zambia", "Zimbabwean", "Zimbabwe");

    public static String mul(String s) {
        return "(?:" + s + B + ")*" + s;
    }

    public static String mulHyp(String s) {
        return "(?:" + s + H + ")*" + s;
    }

    public static String opt(String s) {
        return "(?:" + s + ")?";
    }

    public static String optMul(String s) {
        return "(?:" + s + ")*";
    }

    public static String or(String s1, String s2) {
        return "(?:" + s1 + or + s2 + ")";
    }

    public static String c(String s) {
        return "(" + s + ")";
    }

    public static boolean isFamilyNamePrefix(String s) {
        return familyNamePrefixPattern.matcher(s).matches();
    }

    public static boolean isAttributePrefix(String s) {
        return s.matches(attributePrefix);
    }

    public static boolean isPersonNameSuffix(String s) {
        return familyNameSuffixPattern.matcher(s).matches();
    }

    public static boolean isTitle(String s) {
        return titlePattern.matcher(s).matches();
    }

    public static boolean isCompanyNameSuffix(String s) {
        return companyNameSuffixPattern.matcher(s).matches();
    }

    public static boolean isName(String s) {
        return safeNamePattern.matcher(s).matches();
    }

    public static boolean isNames(String s) {
        return safeNamesPattern.matcher(s).matches();
    }

    public static boolean couldBeName(String s) {
        return laxNamePattern.matcher(s).matches();
    }

    public String toString() {
        return this.original;
    }

    public String normalize() {
        if (this.normalized == null) {
            this.normalized = this.original.replaceAll(B, "_").replaceAll("([\\P{L}&&[^\\d]&&[^_]])", "");
        }
        return this.normalized;
    }

    protected Name(String s) {
        this.original = s;
    }

    public String describe() {
        return "Name\n  Original: " + this.original + "\n  Normalized: " + this.normalize();
    }

    public String original() {
        return this.original;
    }

    public static boolean isAbbreviation(String word) {
        return safeAbbreviationPattern.matcher(word).matches();
    }

    public static boolean couldBeAbbreviation(String word) {
        return laxAbbreviationPattern.matcher(word).matches();
    }

    public static boolean isCompanyName(String s) {
        return safeCompanyPattern.matcher(s).matches();
    }

    public static boolean couldBeCompanyName(String s) {
        return laxCompanyPattern.matcher(s).matches();
    }

    public static boolean couldBePersonName(String s) {
        if (Name.isCompanyName(s)) {
            return false;
        }
        return laxPersonNamePattern.matcher(s).matches();
    }

    public static boolean isPersonName(String m) {
        return safePersonNamePattern.matcher(m).matches();
    }

    public static boolean isStopWord(String w) {
        return stopWords.contains(w);
    }

    public static boolean isUSState(String s) {
        return usStates.values().contains(s.replace('_', ' '));
    }

    public static boolean isUSStateAbbreviation(String s) {
        if (s.endsWith(".")) {
            s = Char17.cutLast(s);
        }
        return usStates.containsKey(s.toUpperCase());
    }

    public static String unabbreviateUSState(String s) {
        if (s.endsWith(".")) {
            s = Char17.cutLast(s);
        }
        return usStates.get(s.toUpperCase());
    }

    public static boolean isLanguage(String s) {
        return languageCodes.values().contains(Char17.upCaseFirst(s));
    }

    public static boolean isLanguageCode(String s) {
        return languageCodes.containsKey(s.toLowerCase());
    }

    public static String languageForCode(String s) {
        return languageCodes.get(s.toLowerCase());
    }

    public static boolean isNation(String s) {
        return nationality2country.values().contains(s);
    }

    public static boolean isNationality(String s) {
        return nationality2country.containsKey(s);
    }

    public static String nationForNationality(String s) {
        return nationality2country.get(s);
    }

    public static Name of(String s) {
        if (Name.isCompanyName(s)) {
            return new CompanyName(s);
        }
        if (Name.couldBePersonName(s)) {
            return new PersonName(s);
        }
        if (Name.isAbbreviation(s)) {
            return new Abbreviation(s);
        }
        return new Name(s);
    }

    public static void main(String[] argv) throws Exception {
        for (String s : new FileLines("./src/test/resources/testdata/NameParserTest.txt")) {
            D.p(Name.of(s).describe());
        }
    }

    public static class PersonName
    extends Name {
        protected String myTitles;
        protected String myGivenNames;
        protected String myFamilyNamePrefix;
        protected String myAttributePrefix;
        protected String myFamilyName;
        protected String myAttribute;
        protected String myFamilyNameSuffix;
        protected String myRoman;
        protected String myCity;
        protected String myNickname;

        protected static String getComponent(Matcher m, int n) {
            if (m.group(n) == null || m.group(n).length() == 0) {
                return null;
            }
            String result = m.group(n);
            if (result.matches(".+(?:[\\s_]++)")) {
                return result.substring(0, result.length() - 1);
            }
            if (result.matches("(?:[\\s_]++).+")) {
                return result.substring(1);
            }
            return result;
        }

        public PersonName(String s) {
            super(s);
            s = s.replace('_', ' ');
            Matcher m = laxPersonNamePattern.matcher(s);
            if (!m.matches()) {
                return;
            }
            this.myTitles = PersonName.getComponent(m, 1);
            this.myGivenNames = PersonName.getComponent(m, 2);
            this.myNickname = PersonName.getComponent(m, 3);
            this.myFamilyName = PersonName.getComponent(m, 6);
            this.myFamilyNamePrefix = PersonName.getComponent(m, 5);
            String attr = PersonName.getComponent(m, 4);
            if (attr != null) {
                this.myAttributePrefix = attr;
                this.myAttribute = this.myFamilyName;
                this.myFamilyName = null;
            }
            this.myFamilyNameSuffix = PersonName.getComponent(m, 7);
            this.myRoman = PersonName.getComponent(m, 8);
            this.myCity = PersonName.getComponent(m, 9);
            if (this.myNickname == null) {
                this.myNickname = PersonName.getComponent(m, 10);
            }
            if (this.myGivenNames == null && this.myTitles != null && titlesForGivenNames.contains(this.myTitles.toLowerCase())) {
                this.myGivenNames = this.myFamilyName;
                this.myFamilyName = null;
            }
            if (this.myRoman != null && this.myFamilyName != null) {
                this.myGivenNames = this.myGivenNames == null ? this.myFamilyName : this.myGivenNames + " " + this.myFamilyName;
                this.myFamilyName = null;
            }
            if (this.myFamilyName != null && this.myGivenNames != null && familyNameSuffixPattern.matcher(this.myFamilyName).matches()) {
                String[] g = this.myGivenNames.split(Name.B);
                this.myFamilyNameSuffix = this.myFamilyName;
                this.myFamilyName = g[g.length - 1];
                this.myGivenNames = g.length == 1 ? null : this.myGivenNames.substring(0, this.myGivenNames.length() - this.myFamilyName.length());
            }
        }

        public String givenName() {
            if (this.myGivenNames == null) {
                return null;
            }
            if (this.myGivenNames.indexOf(32) == -1) {
                return this.myGivenNames;
            }
            return this.myGivenNames.substring(0, this.myGivenNames.indexOf(32));
        }

        public String attribute() {
            return this.myAttribute;
        }

        public String attributePrefix() {
            return this.myAttributePrefix;
        }

        public String city() {
            return this.myCity;
        }

        public String nickname() {
            return this.myNickname;
        }

        public String familyName() {
            return this.myFamilyName;
        }

        public String familyNameWithAffixes() {
            if (this.myFamilyName == null) {
                return null;
            }
            return (this.myFamilyNamePrefix == null ? "" : this.myFamilyNamePrefix + " ") + this.myFamilyName + (this.myFamilyNameSuffix == null ? "" : " " + this.myFamilyNameSuffix);
        }

        public String familyNamePrefix() {
            return this.myFamilyNamePrefix;
        }

        public String familyNameSuffix() {
            return this.myFamilyNameSuffix;
        }

        public String givenNames() {
            return this.myGivenNames;
        }

        public String roman() {
            return this.myRoman;
        }

        public String titles() {
            return this.myTitles;
        }

        @Override
        public String normalize() {
            String given = this.givenNames();
            if (this.myFamilyName != null) {
                String family = this.myFamilyName;
                if (this.myFamilyNameSuffix != null && this.myFamilyNameSuffix.matches("[jJ].*")) {
                    family = family + ", Jr.";
                } else if (this.myFamilyNameSuffix != null && this.myFamilyNameSuffix.matches("[sS].*")) {
                    family = family + ", Sr.";
                }
                if (given != null) {
                    family = given + ' ' + family;
                }
                return family;
            }
            if (given != null) {
                if (this.myRoman != null && given != null) {
                    given = given + ' ' + this.myRoman;
                }
                if (this.myAttribute != null && given != null) {
                    given = given + ' ' + this.myAttribute;
                }
                return given;
            }
            return this.original();
        }

        @Override
        public String describe() {
            return "PersonName\n  Original: " + this.original + "\n  Titles: " + this.titles() + "\n  Given Name: " + this.givenName() + "\n  Given Names: " + this.givenNames() + "\n  Nickname: " + this.nickname() + "\n  Family Name Prefix: " + this.familyNamePrefix() + "\n  Attribute Prefix: " + this.attributePrefix() + "\n  Family Name: " + this.familyName() + "\n  Attribute: " + this.attribute() + "\n  Family Name Suffix: " + this.familyNameSuffix() + "\n  Roman: " + this.roman() + "\n  City: " + this.city() + "\n  Normalized: " + this.normalize();
        }
    }

    public static class CompanyName
    extends Name {
        protected String name;
        protected String suffix;

        public CompanyName(String s) {
            super(s);
            Matcher m = laxCompanyPattern.matcher(s);
            if (!m.matches()) {
                return;
            }
            this.name = m.group(1);
            this.suffix = m.group(2);
        }

        public String name() {
            return this.name;
        }

        public String suffix() {
            return this.suffix;
        }

        @Override
        public String normalize() {
            return this.name;
        }

        @Override
        public String describe() {
            return "CompanyName\n  Original: " + this.original + "\n  Name: " + this.name + "\n  Suffix: " + this.suffix + "\n  Normalized: " + this.normalize();
        }
    }

    public static class Abbreviation
    extends Name {
        public Abbreviation(String s) {
            super(s);
            if (!laxAbbreviationPattern.matcher(s).matches()) {
                return;
            }
        }

        @Override
        public String normalize() {
            if (this.normalized == null) {
                this.normalized = super.normalize().toUpperCase();
            }
            return this.normalized;
        }

        @Override
        public String describe() {
            return "Abbreviation\n  Original: " + this.original + "\n  Normalized: " + this.normalize();
        }
    }
}

