/*
 * Decompiled with CFR 0.152.
 */
package javatools.parsers;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javatools.administrative.D;
import javatools.datatypes.FinalSet;
import javatools.parsers.PlingStemmer;

public class NounGroup {
    public static String2Boolean isAdjective = new String2Boolean(){

        @Override
        public boolean apply(String s) {
            return s.length() > 0 && Character.isLowerCase(s.charAt(0)) && (s.endsWith("al") || s.endsWith("ed") || s.endsWith("ing"));
        }
    };
    public static final Set<String> determiners = new FinalSet((Comparable[])new String[]{"the", "a", "an", "this", "these", "those"});
    public static final FinalSet<String> prepositions = new FinalSet((Comparable[])new String[]{",", "at", "about", "and", "by", "for", "from", "in", "of", "on", "to", "with", "who", "-", "\u2248", "under", "among"});
    protected String original;
    protected String adjective;
    protected String preposition;
    protected NounGroup postModifier;
    protected String head;
    protected String preModifier;
    protected String determiner;

    public String adjective() {
        return this.adjective;
    }

    public String determiner() {
        return this.determiner;
    }

    public String head() {
        return this.head;
    }

    public String original() {
        return this.original;
    }

    public NounGroup postModifier() {
        return this.postModifier;
    }

    public String preModifier() {
        return this.preModifier;
    }

    public String preposition() {
        return this.preposition;
    }

    public String stemmed() {
        StringBuilder full = new StringBuilder();
        if (this.preModifier != null) {
            full.append(this.preModifier).append(' ');
        }
        full.append(PlingStemmer.stem(this.head.toLowerCase()));
        if (this.adjective != null) {
            full.append(' ').append(this.adjective);
        }
        if (this.preposition != null) {
            full.append(' ').append(this.preposition);
        }
        if (this.postModifier != null) {
            full.append(' ').append(this.postModifier.original());
        }
        return full.toString();
    }

    public boolean stemHead() {
        String stemmed = PlingStemmer.stem(this.head);
        boolean result = !stemmed.equals(this.head);
        this.head = stemmed;
        return result;
    }

    public NounGroup(String s) {
        this(Arrays.asList(s.split("[\\s_]+")));
    }

    public NounGroup(List<String> words) {
        int ingPos;
        int prepPos;
        this.original = words.toString().replace(", ", " ");
        this.original = this.original.substring(1, this.original.length() - 1);
        if (words.size() > 0 && determiners.contains(words.get(0).toLowerCase())) {
            this.determiner = words.get(0).toLowerCase();
            words = words.subList(1, words.size());
        }
        for (prepPos = 1; prepPos < words.size() - 1; ++prepPos) {
            if (!prepositions.contains((String)((Object)((Comparable)((Object)words.get(prepPos)))))) continue;
            this.preposition = words.get(prepPos);
            break;
        }
        for (ingPos = 1; ingPos < prepPos; ++ingPos) {
            if (!words.get(ingPos).endsWith("ing")) continue;
            this.adjective = words.get(ingPos);
            break;
        }
        if (this.preposition != null && this.adjective != null && ingPos == prepPos - 1) {
            this.postModifier = new NounGroup(words.subList(prepPos + 1, words.size()));
            words = words.subList(0, ingPos);
        } else if (this.adjective != null) {
            this.postModifier = new NounGroup(words.subList(ingPos + 1, words.size()));
            words = words.subList(0, ingPos);
        } else if (this.preposition != null) {
            this.postModifier = new NounGroup(words.subList(prepPos + 1, words.size()));
            if (prepPos > 1 && isAdjective.apply(words.get(prepPos - 1))) {
                this.adjective = words.get(prepPos - 1);
                words = words.subList(0, prepPos - 1);
            } else {
                words = words.subList(0, prepPos);
            }
        }
        if (words.size() == 0) {
            return;
        }
        this.head = words.get(words.size() - 1);
        if (words.size() > 1) {
            this.preModifier = words.subList(0, words.size() - 1).toString().replace(", ", "_");
            this.preModifier = this.preModifier.substring(1, this.preModifier.length() - 1);
        }
    }

    public boolean equals(Object o) {
        return o instanceof NounGroup && ((NounGroup)o).original.equals(this.original);
    }

    public String toString() {
        return this.original;
    }

    public String description() {
        return "NounGroup:\n  Original: " + this.original + "\n  Stemmed: " + this.stemmed() + "\n  Determiner: " + this.determiner + "\n  preModifiers: " + this.preModifier + "\n  Head: " + this.head + "\n  Adjective: " + this.adjective + "\n  Preposition: " + this.preposition + "\n  postModifier: \n" + (this.postModifier == null ? "" : this.postModifier.description());
    }

    public static void main(String[] args) throws Exception {
        D.p("Enter a noun group and press ENTER. Press CTRL+C to abort");
        while (true) {
            D.p(new NounGroup(D.r()).description());
        }
    }

    public static interface String2Boolean {
        public boolean apply(String var1);
    }
}

