/*
 * Decompiled with CFR 0.152.
 */
package javatools.parsers;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.Set;
import javatools.datatypes.FinalMap;
import javatools.datatypes.FinalSet;

public class PlingStemmer {
    public static Set<String> categorySE_SES = new FinalSet((Comparable[])new String[]{"nurses", "cruises", "premises", "houses", "courses", "cases"});
    public static Set<String> category00 = new FinalSet((Comparable[])new String[]{"alias", "asbestos", "atlas", "barracks", "bathos", "bias", "breeches", "britches", "canvas", "chaos", "clippers", "contretemps", "corps", "cosmos", "crossroads", "diabetes", "ethos", "gallows", "gas", "graffiti", "headquarters", "herpes", "high-jinks", "innings", "jackanapes", "lens", "means", "measles", "mews", "mumps", "news", "pathos", "pincers", "pliers", "proceedings", "rabies", "rhinoceros", "sassafras", "scissors", "series", "shears", "species", "tuna"});
    public static Set<String> categoryUM_A = new FinalSet((Comparable[])new String[]{"addenda", "agenda", "aquaria", "bacteria", "candelabra", "compendia", "consortia", "crania", "curricula", "data", "desiderata", "dicta", "emporia", "enconia", "errata", "extrema", "gymnasia", "honoraria", "interregna", "lustra", "maxima", "media", "memoranda", "millenia", "minima", "momenta", "optima", "ova", "phyla", "quanta", "rostra", "spectra", "specula", "stadia", "strata", "symposia", "trapezia", "ultimata", "vacua", "vela"});
    public static Set<String> categoryON_A = new FinalSet((Comparable[])new String[]{"aphelia", "asyndeta", "automata", "criteria", "hyperbata", "noumena", "organa", "perihelia", "phenomena", "prolegomena"});
    public static Set<String> categoryO_I = new FinalSet((Comparable[])new String[]{"alti", "bassi", "canti", "contralti", "crescendi", "libretti", "soli", "soprani", "tempi", "virtuosi"});
    public static Set<String> categoryUS_I = new FinalSet((Comparable[])new String[]{"alumni", "bacilli", "cacti", "foci", "fungi", "genii", "hippopotami", "incubi", "nimbi", "nuclei", "nucleoli", "octopi", "radii", "stimuli", "styli", "succubi", "syllabi", "termini", "tori", "umbilici", "uteri"});
    public static Set<String> categoryIX_ICES = new FinalSet((Comparable[])new String[]{"appendices", "cervices"});
    public static Set<String> categoryIS_ES = new FinalSet((Comparable[])new String[]{"analyses", "axes", "bases", "crises", "diagnoses", "ellipses", "emphases", "neuroses", "oases", "paralyses", "synopses"});
    public static Set<String> categoryOE_OES = new FinalSet((Comparable[])new String[]{"aloes", "backhoes", "beroes", "canoes", "chigoes", "cohoes", "does", "felloes", "floes", "foes", "gumshoes", "hammertoes", "hoes", "hoopoes", "horseshoes", "leucothoes", "mahoes", "mistletoes", "oboes", "overshoes", "pahoehoes", "pekoes", "roes", "shoes", "sloes", "snowshoes", "throes", "tic-tac-toes", "tick-tack-toes", "ticktacktoes", "tiptoes", "tit-tat-toes", "toes", "toetoes", "tuckahoes", "woes"});
    public static Set<String> categoryEX_ICES = new FinalSet((Comparable[])new String[]{"apices", "codices", "cortices", "indices", "latices", "murices", "pontifices", "silices", "simplices", "vertices", "vortices"});
    public static Set<String> categoryU_US = new FinalSet((Comparable[])new String[]{"apercus", "barbus", "cornus", "ecrus", "emus", "fondus", "gnus", "iglus", "mus", "nandus", "napus", "poilus", "quipus", "snafus", "tabus", "tamandus", "tatus", "timucus", "tiramisus", "tofus", "tutus"});
    public static Set<String> categorySSE_SSES = new FinalSet((Comparable[])new String[]{"bouillabaisses", "coulisses", "crevasses", "crosses", "cuisses", "demitasses", "ecrevisses", "fesses", "finesses", "fosses", "impasses", "lacrosses", "largesses", "masses", "noblesses", "palliasses", "pelisses", "politesses", "posses", "tasses", "wrasses"});
    public static Set<String> categoryCHE_CHES = new FinalSet((Comparable[])new String[]{"adrenarches", "attaches", "avalanches", "barouches", "brioches", "caches", "caleches", "caroches", "cartouches", "cliches", "cloches", "creches", "demarches", "douches", "gouaches", "guilloches", "headaches", "heartaches", "huaraches", "menarches", "microfiches", "moustaches", "mustaches", "niches", "panaches", "panoches", "pastiches", "penuches", "pinches", "postiches", "psyches", "quiches", "schottisches", "seiches", "soutaches", "synecdoches", "thelarches", "troches"});
    public static Set<String> categoryICS = new FinalSet((Comparable[])new String[]{"aerobatics", "aerobics", "aerodynamics", "aeromechanics", "aeronautics", "alphanumerics", "animatronics", "apologetics", "architectonics", "astrodynamics", "astronautics", "astrophysics", "athletics", "atmospherics", "autogenics", "avionics", "ballistics", "bibliotics", "bioethics", "biometrics", "bionics", "bionomics", "biophysics", "biosystematics", "cacogenics", "calisthenics", "callisthenics", "catoptrics", "civics", "cladistics", "cryogenics", "cryonics", "cryptanalytics", "cybernetics", "cytoarchitectonics", "cytogenetics", "diagnostics", "dietetics", "dramatics", "dysgenics", "econometrics", "economics", "electromagnetics", "electronics", "electrostatics", "endodontics", "enterics", "ergonomics", "eugenics", "eurhythmics", "eurythmics", "exodontics", "fibreoptics", "futuristics", "genetics", "genomics", "geographics", "geophysics", "geopolitics", "geriatrics", "glyptics", "graphics", "gymnastics", "hermeneutics", "histrionics", "homiletics", "hydraulics", "hydrodynamics", "hydrokinetics", "hydroponics", "hydrostatics", "hygienics", "informatics", "kinematics", "kinesthetics", "kinetics", "lexicostatistics", "linguistics", "lithoglyptics", "liturgics", "logistics", "macrobiotics", "macroeconomics", "magnetics", "magnetohydrodynamics", "mathematics", "metamathematics", "metaphysics", "microeconomics", "microelectronics", "mnemonics", "morphophonemics", "neuroethics", "neurolinguistics", "nucleonics", "numismatics", "obstetrics", "onomastics", "orthodontics", "orthopaedics", "orthopedics", "orthoptics", "paediatrics", "patristics", "patristics", "pedagogics", "pediatrics", "periodontics", "pharmaceutics", "pharmacogenetics", "pharmacokinetics", "phonemics", "phonetics", "phonics", "photomechanics", "physiatrics", "pneumatics", "poetics", "politics", "pragmatics", "prosthetics", "prosthodontics", "proteomics", "proxemics", "psycholinguistics", "psychometrics", "psychonomics", "psychophysics", "psychotherapeutics", "robotics", "semantics", "semiotics", "semitropics", "sociolinguistics", "stemmatics", "strategics", "subtropics", "systematics", "tectonics", "telerobotics", "therapeutics", "thermionics", "thermodynamics", "thermostatics"});
    public static Set<String> categoryIE_IES = new FinalSet((Comparable[])new String[]{"aeries", "anomies", "aunties", "baddies", "beanies", "birdies", "boccies", "bogies", "bolshies", "bombies", "bonhomies", "bonxies", "booboisies", "boogies", "boogie-woogies", "bookies", "booties", "bosies", "bourgeoisies", "brasseries", "brassies", "brownies", "budgies", "byrnies", "caddies", "calories", "camaraderies", "capercaillies", "capercailzies", "cassies", "catties", "causeries", "charcuteries", "chinoiseries", "collies", "commies", "cookies", "coolies", "coonties", "cooties", "corries", "coteries", "cowpies", "cowries", "cozies", "crappies", "crossties", "curies", "dachsies", "darkies", "dassies", "dearies", "dickies", "dies", "dixies", "doggies", "dogies", "dominies", "dovekies", "eyries", "faeries", "falsies", "floozies", "folies", "foodies", "freebies", "gaucheries", "gendarmeries", "genies", "ghillies", "gillies", "goalies", "goonies", "grannies", "grotesqueries", "groupies", "hankies", "hippies", "hoagies", "honkies", "hymies", "indies", "junkies", "kelpies", "kilocalories", "knobkerries", "koppies", "kylies", "laddies", "lassies", "lies", "lingeries", "magpies", "magpies", "marqueteries", "mashies", "mealies", "meanies", "menageries", "millicuries", "mollies", "facts1", "moxies", "neckties", "newbies", "nighties", "nookies", "oldies", "organdies", "panties", "parqueteries", "passementeries", "patisseries", "pies", "pinkies", "pixies", "porkpies", "potpies", "prairies", "preemies", "premies", "punkies", "pyxies", "quickies", "ramies", "reveries", "rookies", "rotisseries", "scrapies", "sharpies", "smoothies", "softies", "stoolies", "stymies", "swaggies", "sweeties", "talkies", "techies", "ties", "tooshies", "toughies", "townies", "veggies", "walkie-talkies", "wedgies", "weenies", "weirdies", "yardies", "yuppies", "zombies"});
    public static Map<String, String> irregular = new FinalMap<String, String>("beefs", "beef", "beeves", "beef", "brethren", "brother", "busses", "bus", "cattle", "cattlebeast", "children", "child", "corpora", "corpus", "ephemerides", "ephemeris", "firemen", "fireman", "genera", "genus", "genies", "genie", "genii", "genie", "kine", "cow", "lice", "louse", "men", "man", "mice", "mouse", "mongooses", "mongoose", "monies", "money", "mythoi", "mythos", "octopodes", "octopus", "octopuses", "octopus", "oxen", "ox", "people", "person", "soliloquies", "soliloquy", "throes", "throes", "trilbys", "trilby", "women", "woman");
    public static Set<String> singAndPlur = new FinalSet((Comparable[])new String[]{"acoustics", "aestetics", "aquatics", "basics", "ceramics", "classics", "cosmetics", "dermatoglyphics", "dialectics", "dynamics", "esthetics", "ethics", "harmonics", "heroics", "isometrics", "mechanics", "metrics", "statistics", "optic", "people", "physics", "polemics", "premises", "propaedeutics", "pyrotechnics", "quadratics", "quarters", "statistics", "tactics", "tropics"});

    public static boolean isPlural(String s) {
        return !s.equals(PlingStemmer.stem(s));
    }

    public static boolean isSingular(String s) {
        return singAndPlur.contains(s.toLowerCase()) || !PlingStemmer.isPlural(s);
    }

    public static boolean isSingularAndPlural(String s) {
        return singAndPlur.contains(s.toLowerCase());
    }

    public static String cut(String s, String suffix) {
        return s.substring(0, s.length() - suffix.length());
    }

    public static boolean noLatin(String s) {
        return s.indexOf(104) > 0 || s.indexOf(106) > 0 || s.indexOf(107) > 0 || s.indexOf(119) > 0 || s.indexOf(121) > 0 || s.indexOf(122) > 0 || s.indexOf("ou") > 0 || s.indexOf("sh") > 0 || s.indexOf("ch") > 0 || s.endsWith("aus");
    }

    private static boolean greek(String s) {
        return s.indexOf("ph") > 0 || s.indexOf(121) > 0 && s.endsWith("nges");
    }

    public static String stem(String s) {
        String stem = s;
        String irreg = irregular.get(s);
        if (irreg != null) {
            stem = irreg;
            return stem;
        }
        if (categoryON_A.contains(s)) {
            stem = PlingStemmer.cut(s, "a") + "on";
            return stem;
        }
        if (categoryUM_A.contains(s)) {
            stem = PlingStemmer.cut(s, "a") + "um";
            return stem;
        }
        if (categoryIX_ICES.contains(s)) {
            stem = PlingStemmer.cut(s, "ices") + "ix";
            return stem;
        }
        if (categoryO_I.contains(s)) {
            stem = PlingStemmer.cut(s, "i") + "o";
            return stem;
        }
        if (categorySE_SES.contains(s)) {
            stem = PlingStemmer.cut(s, "s");
            return stem;
        }
        if (categoryIS_ES.contains(s) || s.endsWith("theses")) {
            stem = PlingStemmer.cut(s, "es") + "is";
            return stem;
        }
        if (categoryUS_I.contains(s)) {
            stem = PlingStemmer.cut(s, "i") + "us";
            return stem;
        }
        if (s.endsWith("uses") && (categoryUS_I.contains(PlingStemmer.cut(s, "uses") + "i") || s.equals("genuses") || s.equals("corpuses"))) {
            stem = PlingStemmer.cut(s, "es");
            return stem;
        }
        if (categoryEX_ICES.contains(s)) {
            stem = PlingStemmer.cut(s, "ices") + "ex";
            return stem;
        }
        if (s.endsWith("ois") || s.endsWith("itis") || category00.contains(s) || categoryICS.contains(s)) {
            stem = s;
            return stem;
        }
        if (s.endsWith("ina")) {
            stem = PlingStemmer.cut(s, "en");
            return stem;
        }
        if (s.endsWith("ae")) {
            stem = PlingStemmer.cut(s, "e");
            return stem;
        }
        if (s.endsWith("ata")) {
            stem = PlingStemmer.cut(s, "ta");
            return stem;
        }
        if (s.endsWith("trices")) {
            stem = PlingStemmer.cut(s, "trices") + "trix";
            return stem;
        }
        if (!(!s.endsWith("us") || s.endsWith("eaus") || s.endsWith("ieus") || PlingStemmer.noLatin(s) || categoryU_US.contains(s))) {
            stem = s;
            return stem;
        }
        if (s.endsWith("teeth")) {
            stem = PlingStemmer.cut(s, "teeth") + "tooth";
            return stem;
        }
        if (s.endsWith("geese")) {
            stem = PlingStemmer.cut(s, "geese") + "goose";
            return stem;
        }
        if (s.endsWith("feet")) {
            stem = PlingStemmer.cut(s, "feet") + "foot";
            return stem;
        }
        if (s.endsWith("zoa")) {
            stem = PlingStemmer.cut(s, "zoa") + "zoon";
            return stem;
        }
        if (s.endsWith("eaux")) {
            stem = PlingStemmer.cut(s, "x");
            return stem;
        }
        if (s.endsWith("ieux")) {
            stem = PlingStemmer.cut(s, "x");
            return stem;
        }
        if (s.endsWith("nges") && PlingStemmer.greek(s)) {
            stem = PlingStemmer.cut(s, "nges") + "nx";
            return stem;
        }
        if (s.endsWith("shes") || s.endsWith("ches") && !categoryCHE_CHES.contains(s)) {
            stem = PlingStemmer.cut(s, "es");
            return stem;
        }
        if (s.endsWith("sses") && !categorySSE_SSES.contains(s) && !s.endsWith("mousses")) {
            stem = PlingStemmer.cut(s, "es");
            return stem;
        }
        if (s.endsWith("xes") && !s.equals("axes")) {
            stem = PlingStemmer.cut(s, "es");
            return stem;
        }
        if (s.endsWith("nives") || s.endsWith("lives") && !s.endsWith("olives") || s.endsWith("wives")) {
            stem = PlingStemmer.cut(s, "ves") + "fe";
            return stem;
        }
        if (s.endsWith("alves") && !s.endsWith("valves") || s.endsWith("olves") && !s.endsWith("solves") || s.endsWith("eaves") && !s.endsWith("heaves") && !s.endsWith("weaves") || s.endsWith("arves")) {
            stem = PlingStemmer.cut(s, "ves") + "f";
            return stem;
        }
        if (s.endsWith("ies") && !categoryIE_IES.contains(s)) {
            stem = PlingStemmer.cut(s, "ies") + "y";
            return stem;
        }
        if (s.endsWith("oes") && !categoryOE_OES.contains(s)) {
            stem = PlingStemmer.cut(s, "es");
            return stem;
        }
        if (s.endsWith("ses") || s.endsWith("zes")) {
            stem = PlingStemmer.cut(s, "es");
            return stem;
        }
        if (s.endsWith("s") && !s.endsWith("ss") && !s.endsWith("is")) {
            stem = PlingStemmer.cut(s, "s");
            return stem;
        }
        return stem;
    }

    public static void main(String[] argv) throws Exception {
        String w;
        System.out.println("Enter an English word in plural form and press ENTER");
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        while ((w = in.readLine()).length() != 0) {
            if (PlingStemmer.isPlural(w)) {
                System.out.println("This word is plural");
            }
            if (PlingStemmer.isSingular(w)) {
                System.out.println("This word is singular");
            }
            System.out.println("Stemmed to singular: " + PlingStemmer.stem(w));
        }
    }
}

