/*
 * Decompiled with CFR 0.152.
 */
package javatools.administrative;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Set;
import java.util.Vector;
import javatools.administrative.CallStack;
import javatools.administrative.D;
import javatools.datatypes.FinalSet;
import javatools.parsers.NumberFormatter;

public class Announce {
    protected static Level level = Level.MESSAGES;
    public static int MAXDOTS = 40;
    protected static Writer out = new BufferedWriter(new OutputStreamWriter(System.out));
    protected static int doingLevel = 0;
    protected static boolean cursorAtPos1 = true;
    protected static int progressLevel = -1;
    protected static double[] progressEnd = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
    protected static int[] progressDots = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    protected static String[] progressID = new String[10];
    protected static long[] progressStart = new long[]{0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L};
    protected static double[] progressCounter = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
    protected static boolean[] printedEstimatedTime = new boolean[10];
    protected static long[] lastEstimation = new long[10];
    protected static long timer;
    protected static Vector<Long> timerStarts;
    protected static Vector<Long> timerTimes;
    protected static boolean debug;
    public static final String blanks = "                                                                  ";
    protected static final Set<String> helpCommands;

    public static void startTimer() {
        timer = System.currentTimeMillis();
    }

    public static long getTime() {
        return System.currentTimeMillis() - timer;
    }

    public static int initTimer() {
        timerStarts.add(0L);
        timerTimes.add(0L);
        return timerStarts.size() - 1;
    }

    public static void startTimer(int number) {
        if (timerStarts.size() <= number) {
            return;
        }
        timerStarts.set(number, System.currentTimeMillis());
    }

    public static void stopTimer(int number) {
        if (timerTimes.size() <= number) {
            return;
        }
        timerTimes.set(number, timerTimes.get(number) + (System.currentTimeMillis() - timerStarts.get(number)));
    }

    public static Long getTime(int number) {
        return timerTimes.get(number);
    }

    public static Vector<Long> getTimers() {
        return timerTimes;
    }

    public static void resetTimer(int number) {
        if (timerTimes.size() <= number) {
            return;
        }
        timerTimes.set(number, 0L);
    }

    public static void printTime(int timerNumber) {
        Announce.printTime(null, timerNumber);
    }

    public static void printTime(String name, int timerNumber) {
        if (name != null) {
            Announce.message("Time", name, ":", NumberFormatter.formatMS(Announce.getTime(timerNumber)));
        } else {
            Announce.message("Timer", timerNumber, ":", NumberFormatter.formatMS(Announce.getTime(timerNumber)));
        }
    }

    public static void close() throws IOException {
        out.close();
        out = new PrintWriter(System.out);
    }

    public static Level setLevel(Level l) {
        Level oldLevel = level;
        level = l;
        return oldLevel;
    }

    public static Level getActiveLevel() {
        return level;
    }

    public static boolean isActiveLevel(Level l) {
        return !D.smaller(level, l);
    }

    public static void setDebugMode(boolean set) {
        debug = set;
    }

    public static String blanks(int n) {
        if (n <= 0) {
            return "";
        }
        if (n >= blanks.length()) {
            return blanks;
        }
        return blanks.substring(0, n);
    }

    protected static String blanks() {
        return Announce.blanks(doingLevel * 2);
    }

    protected static void print(Object ... o) {
        try {
            if (cursorAtPos1) {
                out.write(Announce.blanks());
            }
            out.write(D.toString(o).replace("\n", "\n" + Announce.blanks()));
            out.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        cursorAtPos1 = false;
    }

    protected static void newLine() {
        if (cursorAtPos1) {
            return;
        }
        try {
            out.write("\n");
            out.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        cursorAtPos1 = true;
    }

    public static void message(Object ... o) {
        if (D.smaller(level, Level.MESSAGES)) {
            return;
        }
        Announce.newLine();
        if (debug) {
            Announce.print("[" + CallStack.toString(new CallStack().ret().top()) + "] ");
        }
        Announce.print(o);
        Announce.newLine();
    }

    public static void messageDetailed(Object ... o) {
        if (D.smaller(level, Level.DETAILMESSAGES)) {
            return;
        }
        Announce.newLine();
        if (debug) {
            Announce.print("[" + CallStack.toString(new CallStack().ret().top()) + "] ");
        }
        Announce.print(o);
        Announce.newLine();
    }

    public static boolean debug(Object ... o) {
        if (D.smaller(level, Level.DEBUG)) {
            return true;
        }
        Announce.newLine();
        Announce.print("[" + CallStack.toString(new CallStack().ret().top()) + "] ");
        Announce.print(o);
        Announce.newLine();
        return true;
    }

    public static void debugMsg(Object ... o) {
        if (D.smaller(level, Level.DEBUG)) {
            return;
        }
        Announce.newLine();
        Announce.print(o);
        Announce.newLine();
    }

    public static void error(Object ... o) {
        if (D.smaller(level, Level.ERROR)) {
            System.exit(255);
        }
        if (doingLevel > 0) {
            Announce.failed();
        }
        doingLevel = 0;
        Announce.newLine();
        if (debug) {
            Announce.print("[!Error: " + CallStack.toString(new CallStack().ret().top()) + "] ");
        } else {
            Announce.print("Error: ");
        }
        Announce.print(o);
        Announce.newLine();
        System.exit(255);
    }

    public static void error(Exception e) {
        if (D.smaller(level, Level.ERROR)) {
            System.exit(255);
        }
        if (debug) {
            Announce.print("[!Error: " + CallStack.toString(new CallStack().ret().top()) + "] ");
        } else {
            Announce.print("Error: ");
        }
        PrintWriter writer = new PrintWriter(out);
        e.printStackTrace(writer);
        writer.flush();
        System.exit(255);
    }

    public static void errorException(Object ... o) {
        if (D.smaller(level, Level.ERROR)) {
            throw new RuntimeException("Fatal Error.");
        }
        while (doingLevel > 0) {
            Announce.failed();
        }
        Announce.newLine();
        if (debug) {
            Announce.print("[!Error: " + CallStack.toString(new CallStack().ret().top()) + "] ");
        } else {
            Announce.print("Error: ");
        }
        Announce.print(o);
        Announce.newLine();
        Exception cause = null;
        for (Object ob : o) {
            if (!(ob instanceof Exception)) continue;
            cause = (Exception)ob;
        }
        throw cause != null ? new RuntimeException("Fatal Error.", cause) : new RuntimeException("Fatal Error.");
    }

    public static void errorException(String message, Exception cause) {
        if (D.smaller(level, Level.ERROR)) {
            throw new RuntimeException(message, cause);
        }
        while (doingLevel > 0) {
            Announce.failed();
        }
        Announce.newLine();
        if (debug) {
            Announce.print("[!Error: " + CallStack.toString(new CallStack().ret().top()) + "] ");
        } else {
            Announce.print("Error: ");
        }
        Announce.print(message);
        Announce.newLine();
        throw new RuntimeException(message, cause);
    }

    public static void errorException(Exception e) {
        if (D.smaller(level, Level.ERROR)) {
            throw new RuntimeException("Fatal Error.");
        }
        if (debug) {
            Announce.print("[!Error: " + CallStack.toString(new CallStack().ret().top()) + "] ");
        } else {
            Announce.print("Error: ");
        }
        PrintWriter writer = new PrintWriter(out);
        e.printStackTrace(writer);
        writer.flush();
        throw new RuntimeException("Fatal Error.", e);
    }

    public static void warning(Object ... o) {
        if (D.smaller(level, Level.WARNING)) {
            return;
        }
        Announce.newLine();
        if (debug) {
            Announce.print("[!Warning:  " + CallStack.toString(new CallStack().ret().top()) + "] ");
        } else {
            Announce.print("Warning: ");
        }
        doingLevel += 5;
        Announce.print(o);
        doingLevel -= 5;
        Announce.newLine();
    }

    public static void setWriter(Writer w) {
        out = w;
    }

    public static Writer getWriter() {
        return out;
    }

    public static void setWriter(OutputStream s) {
        out = new OutputStreamWriter(s);
    }

    protected static void writeDoing(Object ... o) {
        if (D.smaller(level, Level.STATE)) {
            return;
        }
        Announce.newLine();
        if (debug) {
            Announce.print("[" + CallStack.toString(new CallStack().ret().ret().top()) + "] ");
        }
        Announce.print(o);
        Announce.print("... ");
        ++doingLevel;
    }

    public static void doing(Object ... o) {
        if (D.smaller(level, Level.STATE)) {
            return;
        }
        Announce.writeDoing(o);
    }

    public static void doingDetailed(Object ... o) {
        if (D.smaller(level, Level.DETAILSTATE)) {
            return;
        }
        Announce.writeDoing(o);
    }

    public static void failed() {
        if (doingLevel > 0) {
            --doingLevel;
            if (D.smaller(level, Level.STATE)) {
                return;
            }
            Announce.print("failed");
            Announce.newLine();
        }
    }

    public static void doneDetailed() {
        if (D.smaller(level, Level.DETAILSTATE)) {
            return;
        }
        if (doingLevel > 0) {
            --doingLevel;
            Announce.print("done");
            Announce.newLine();
        }
    }

    public static void done() {
        if (D.smaller(level, Level.STATE)) {
            return;
        }
        if (doingLevel > 0) {
            --doingLevel;
            Announce.print("done");
            Announce.newLine();
        }
    }

    public static void done(String text) {
        if (doingLevel > 0) {
            --doingLevel;
            if (D.smaller(level, Level.STATE)) {
                return;
            }
            Announce.print(text);
            Announce.newLine();
        }
    }

    public static void doneWithProbs() {
        if (doingLevel > 0) {
            --doingLevel;
            if (D.smaller(level, Level.STATE)) {
                return;
            }
            Announce.print("done with problems");
            Announce.newLine();
        }
    }

    public static void doneDoing(Object ... s) {
        Announce.done();
        Announce.doing(s);
    }

    public static void progressStart(String s, double max) {
        Announce.progressStart(s, null, max);
    }

    public static void progressStart(String s, double max, Level lvl) {
        Announce.progressStart(s, null, max, lvl);
    }

    public static void progressStart(String s, String id, double max) {
        Announce.progressStart(s, id, max, Level.MUTE);
    }

    public static synchronized void progressStart(String s, String id, double max, Level lvl) {
        if (D.smaller(level, lvl)) {
            return;
        }
        if (progressLevel < 9) {
            ++progressLevel;
        }
        Announce.progressID[Announce.progressLevel] = id != null ? "[" + id + "]: " : "";
        Announce.progressEnd[Announce.progressLevel] = max;
        Announce.progressDots[Announce.progressLevel] = 0;
        Announce.progressStart[Announce.progressLevel] = System.currentTimeMillis();
        Announce.printedEstimatedTime[Announce.progressLevel] = false;
        Announce.progressCounter[Announce.progressLevel] = 0.0;
        if (!D.smaller(level, Level.STATE)) {
            Announce.newLine();
            if (debug) {
                Announce.print("[" + CallStack.toString(new CallStack().ret().top()) + "] ");
            }
            Announce.print(s, progressID[progressLevel], "...");
        }
        ++doingLevel;
    }

    public static void progressShowTime() {
        if (progressLevel < 0) {
            return;
        }
        Announce.print("(" + NumberFormatter.formatMS((long)((double)(System.currentTimeMillis() - progressStart[progressLevel]) * (progressEnd[progressLevel] - progressCounter[progressLevel]) / progressCounter[progressLevel])) + " to go)");
        Announce.printedEstimatedTime[Announce.progressLevel] = true;
    }

    public static void progressAt(double d, Level lvl) {
        if (D.smaller(level, lvl)) {
            return;
        }
        Announce.progressAt(d);
    }

    public static void progressAt(double d) {
        if (progressLevel < 0) {
            return;
        }
        if (d > progressEnd[progressLevel]) {
            return;
        }
        if (!D.smaller(level, Level.STATE) && !printedEstimatedTime[progressLevel] && System.currentTimeMillis() - progressStart[progressLevel] > 60000L) {
            Announce.print("(" + progressID[progressLevel] + NumberFormatter.formatMS((long)((double)(System.currentTimeMillis() - progressStart[progressLevel]) * (progressEnd[progressLevel] - d) / d)) + " to go)");
            Announce.printedEstimatedTime[Announce.progressLevel] = true;
            Announce.lastEstimation[Announce.progressLevel] = System.currentTimeMillis();
        }
        if (!D.smaller(level, Level.STATE) && printedEstimatedTime[progressLevel] && System.currentTimeMillis() - lastEstimation[progressLevel] > 1800000L) {
            Announce.print("(" + progressID[progressLevel] + NumberFormatter.formatMS((long)((double)(System.currentTimeMillis() - progressStart[progressLevel]) * (progressEnd[progressLevel] - d) / d)) + " to go)");
            Announce.lastEstimation[Announce.progressLevel] = System.currentTimeMillis();
        }
        if (d * (double)MAXDOTS / progressEnd[progressLevel] <= (double)progressDots[progressLevel]) {
            return;
        }
        StringBuilder b = new StringBuilder();
        while (d * (double)MAXDOTS / progressEnd[progressLevel] > (double)progressDots[progressLevel]) {
            int n = progressLevel;
            progressDots[n] = progressDots[n] + 1;
            b.append(".");
        }
        if (!D.smaller(level, Level.STATE)) {
            Announce.print(b);
        }
    }

    public static void progressStep(Level lvl) {
        if (D.smaller(level, lvl)) {
            return;
        }
        Announce.progressStep();
    }

    public static void progressStep() {
        int n = progressLevel;
        double d = progressCounter[n] + 1.0;
        progressCounter[n] = d;
        Announce.progressAt(d);
    }

    public static void progressDone(Level lvl) {
        if (D.smaller(level, lvl)) {
            return;
        }
        Announce.progressDone();
    }

    public static void progressDone() {
        if (progressLevel < 0) {
            return;
        }
        Announce.progressAt(progressEnd[progressLevel]);
        --doingLevel;
        if (!D.smaller(level, Level.STATE)) {
            Announce.print(" done (" + progressID[progressLevel] + NumberFormatter.formatMS(System.currentTimeMillis() - progressStart[progressLevel]) + ")");
            Announce.newLine();
        }
        if (--progressLevel < -1) {
            progressLevel = -1;
        }
    }

    public static long progressTimePassed() {
        return System.currentTimeMillis() - progressStart[progressLevel];
    }

    public static void progressFailed() {
        --progressLevel;
        Announce.failed();
    }

    public static void help(Object ... o) {
        if (D.smaller(level, Level.ERROR)) {
            System.exit(63);
        }
        Announce.newLine();
        for (Object s : o) {
            Announce.print(s);
            Announce.newLine();
        }
        System.exit(63);
    }

    public static void printTime() {
        Announce.message("Time:", NumberFormatter.formatMS(Announce.getTime()));
    }

    public static boolean isHelp(String arg) {
        return arg == null ? false : helpCommands.contains(arg.toLowerCase());
    }

    public static void main(String[] args) {
        int doingStuff = Announce.initTimer();
        int doingOtherStuff = Announce.initTimer();
        Announce.startTimer();
        Announce.doing("Testing 1");
        Announce.doing("Testing 2");
        Announce.message("Now testing", 3);
        Announce.warning(1, 2, 3);
        Announce.debug(1, 2, 3);
        Announce.doing("Testing 3a");
        Announce.doneDoing("Testing 3b");
        Announce.done();
        Announce.progressStart("Testing 3c", 5.0);
        D.waitMS(1000L);
        Announce.progressAt(1.0);
        Announce.startTimer(doingStuff);
        D.waitMS(3000L);
        Announce.progressAt(4.0);
        D.waitMS(1000L);
        Announce.stopTimer(doingStuff);
        Announce.progressDone();
        Announce.progressStart("Testing 3d", 5.0);
        D.waitMS(1000L);
        Announce.progressAt(1.0);
        Announce.progressStart("Testing 4a inside 3d", 4.0);
        Announce.startTimer(doingOtherStuff);
        D.waitMS(1000L);
        Announce.stopTimer(doingOtherStuff);
        Announce.progressAt(1.0);
        D.waitMS(2000L);
        Announce.progressAt(3.0);
        Announce.startTimer(doingStuff);
        D.waitMS(1000L);
        Announce.stopTimer(doingStuff);
        Announce.progressDone();
        Announce.progressAt(2.0);
        Announce.progressStart("Testing 4b inside 3d", "4b", 6.0);
        D.waitMS(1000L);
        Announce.progressAt(1.0);
        D.waitMS(3000L);
        Announce.progressAt(4.0);
        D.waitMS(1000L);
        Announce.progressDone();
        D.waitMS(1000L);
        Announce.progressAt(4.0);
        D.waitMS(1000L);
        Announce.progressDone();
        Announce.progressDone();
        Announce.done();
        Announce.done();
        Announce.done();
        Announce.printTime();
        Announce.printTime("doing stuff", doingStuff);
        Announce.printTime("doing other stuff", doingOtherStuff);
    }

    static {
        timerStarts = new Vector();
        timerTimes = new Vector();
        helpCommands = new FinalSet((Comparable[])new String[]{"-help", "--help", "-h", "--h", "-?", "/?", "/help"});
    }

    public static enum Level {
        MUTE,
        ERROR,
        WARNING,
        STATE,
        MESSAGES,
        DETAILSTATE,
        DETAILMESSAGES,
        DEBUG;

    }
}

