/*
 * Decompiled with CFR 0.152.
 */
package javatools.administrative;

import javatools.administrative.Announce;

public class Tracer {
    protected static TracerThread tracer;

    public static boolean start(long millisDelay) {
        tracer = new TracerThread(millisDelay);
        tracer.start();
        return true;
    }

    public static void stop() {
        if (tracer != null) {
            Tracer.tracer.stop = true;
            tracer = null;
        }
    }

    public static boolean signal(Object ... s) {
        if (tracer != null) {
            tracer.signal(s);
        }
        return true;
    }

    public static void test1() {
        try {
            Thread.sleep(2000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void test2() {
        try {
            Thread.sleep(5000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        Tracer.start(3000L);
        while (true) {
            Tracer.signal("Test1");
            Tracer.test1();
            Tracer.signal("Test2");
            Tracer.test2();
        }
    }

    protected static class TracerThread
    extends Thread {
        protected boolean stop = false;
        protected long lastSignalTime;
        protected Object[] lastSignal;
        protected final long delay;
        boolean announced = true;

        public void signal(Object ... s) {
            if (this.announced && this.lastSignalTime != 0L) {
                StringBuilder b = new StringBuilder();
                for (Object o : s) {
                    b.append(o).append(' ');
                }
                b.append("resolved hang after ").append(System.currentTimeMillis() - this.lastSignalTime).append(" ms");
                Announce.message(b);
            }
            this.lastSignal = s;
            this.lastSignalTime = System.currentTimeMillis();
            this.announced = false;
        }

        public TracerThread(long delay) {
            this.delay = delay;
            this.setDaemon(true);
            this.setName("Tracer");
        }

        @Override
        public void run() {
            while (!this.stop) {
                if (this.announced || System.currentTimeMillis() - this.lastSignalTime <= this.delay) continue;
                StringBuilder b = new StringBuilder();
                for (Object o : this.lastSignal) {
                    b.append(o).append(' ');
                }
                Announce.message(b.append("hangs"));
                this.announced = true;
            }
        }
    }
}

