/*
 * Decompiled with CFR 0.152.
 */
package javatools.database;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javatools.administrative.Announce;
import javatools.administrative.D;
import javatools.database.PostgresDatabase;
import javatools.database.ResultIterator;
import javatools.database.SQLType;
import javatools.datatypes.StringModifier;
import javatools.filehandlers.CSVFile;
import javatools.filehandlers.CSVLines;
import javatools.filehandlers.UTF8Writer;

public abstract class Database {
    boolean autoReconnectOnSelect = true;
    boolean autoReconnectOnUpdate = false;
    int validityCheckTimeout = 150;
    protected Connection connection;
    protected String description = "Unconnected default database";
    protected int resultSetType = 1003;
    protected int resultSetConcurrency = 1007;
    protected int fetchsize = 0;
    protected Driver driver = null;
    private static int defaultTransactionMode = 4;
    private int originalTransactionMode;
    protected List<Inserter> inserters = new ArrayList<Inserter>();
    private boolean closed = false;
    public Map<Class<?>, SQLType> java2SQL = new HashMap();
    public Map<Integer, SQLType> type2SQL;
    boolean autoCommitWasOn;
    boolean inTransactionMode;
    public static final int MINCOLUMNWIDTH = 3;
    public static final int SCREENWIDTH = 120;

    public Database() {
        this.java2SQL.put(Boolean.class, SQLType.ansiboolean);
        this.java2SQL.put(Boolean.TYPE, SQLType.ansiboolean);
        this.java2SQL.put(String.class, SQLType.ansivarchar);
        this.java2SQL.put(Date.class, SQLType.ansitimestamp);
        this.java2SQL.put(Calendar.class, SQLType.ansitimestamp);
        this.java2SQL.put(Integer.TYPE, SQLType.ansiinteger);
        this.java2SQL.put(Integer.class, SQLType.ansiinteger);
        this.java2SQL.put(Long.TYPE, SQLType.ansibigint);
        this.java2SQL.put(Long.class, SQLType.ansibigint);
        this.java2SQL.put(Float.TYPE, SQLType.ansifloat);
        this.java2SQL.put(Float.class, SQLType.ansifloat);
        this.java2SQL.put(Double.TYPE, SQLType.ansifloat);
        this.java2SQL.put(Double.class, SQLType.ansifloat);
        this.java2SQL.put(Character.class, SQLType.ansichar);
        this.java2SQL.put(Character.TYPE, SQLType.ansichar);
        this.type2SQL = new HashMap<Integer, SQLType>();
        this.type2SQL.put(2004, SQLType.ansiblob);
        this.type2SQL.put(12, SQLType.ansivarchar);
        this.type2SQL.put(93, SQLType.ansitimestamp);
        this.type2SQL.put(91, SQLType.ansitimestamp);
        this.type2SQL.put(4, SQLType.ansiinteger);
        this.type2SQL.put(5, SQLType.ansismallint);
        this.type2SQL.put(8, SQLType.ansifloat);
        this.type2SQL.put(7, SQLType.ansifloat);
        this.type2SQL.put(6, SQLType.ansifloat);
        this.type2SQL.put(16, SQLType.ansiboolean);
        this.type2SQL.put(-7, SQLType.ansiboolean);
        this.type2SQL.put(1, SQLType.ansichar);
        this.type2SQL.put(-5, SQLType.ansibigint);
        this.type2SQL.put(2, SQLType.ansifloat);
        this.autoCommitWasOn = true;
        this.inTransactionMode = false;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void reconnect() throws SQLException {
        Database.close(this.connection);
        this.connect();
    }

    public abstract void connect() throws SQLException;

    public static void close(Connection connection) {
        try {
            if (connection != null && !connection.isClosed()) {
                connection.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static void close(Statement statement) {
        try {
            if (statement != null) {
                statement.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static void close(ResultSet rs) {
        try {
            if (rs.isClosed()) {
                return;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            Database.close(rs.getStatement());
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void close() {
        if (this.closed) {
            return;
        }
        if (this.inTransactionMode) {
            try {
                this.commitTransaction();
            }
            catch (TransactionSQLException ex) {
                Announce.error(ex);
            }
        }
        while (this.inserters.size() != 0) {
            this.inserters.get(0).close();
        }
        Database.close(this.connection);
        try {
            DriverManager.deregisterDriver(this.driver);
        }
        catch (SQLException ex) {
            Announce.error(ex);
        }
        this.closed = true;
    }

    public void flush() throws SQLException {
        if (this.inTransactionMode) {
            try {
                this.commitTransaction();
            }
            catch (TransactionSQLException ex) {
                Announce.error(ex);
            }
        }
        for (Inserter inserter : this.inserters) {
            inserter.flush();
        }
    }

    public void finalize() {
        try {
            this.close();
        }
        catch (Exception e) {
            Announce.error(e);
        }
    }

    public boolean jarAvailable() {
        return true;
    }

    public boolean isAutoReconnectingOnSelect() {
        return this.autoReconnectOnSelect;
    }

    public void setAutoReconnectOnSelect(boolean autoReconnectOnSelect) {
        this.autoReconnectOnSelect = autoReconnectOnSelect;
    }

    public boolean isAutoReconnectingOnUpdate() {
        return this.autoReconnectOnUpdate;
    }

    public void setAutoReconnectOnUpdate(boolean autoReconnectOnUpdate) {
        this.autoReconnectOnUpdate = autoReconnectOnUpdate;
    }

    public int getFetchsize() {
        return this.fetchsize;
    }

    public void setFetchsize(int fetchsize) {
        this.fetchsize = fetchsize;
    }

    public int getValidityCheckTimeout() {
        return this.validityCheckTimeout;
    }

    public void setValidityCheckTimeout(int validityCheckTimeout) {
        if (validityCheckTimeout < 0) {
            validityCheckTimeout = 0;
        }
        this.validityCheckTimeout = validityCheckTimeout;
    }

    protected String prepareQuery(String sql) {
        return sql;
    }

    public int getResultSetConcurrency() {
        return this.resultSetConcurrency;
    }

    public void setResultSetConcurrency(int resultSetConcurrency) {
        this.resultSetConcurrency = resultSetConcurrency;
    }

    public int getResultSetType() {
        return this.resultSetType;
    }

    public void setResultSetType(int resultSetType) {
        this.resultSetType = resultSetType;
    }

    public boolean connected() {
        try {
            return !this.connection.isClosed() && this.connection.isValid(this.validityCheckTimeout);
        }
        catch (SQLFeatureNotSupportedException nosupport) {
            try {
                ResultSet rs = this.executeQuery("SELECT 1", this.resultSetType, this.resultSetConcurrency, null);
                Database.close(rs);
                return true;
            }
            catch (SQLException ex) {
                return false;
            }
        }
        catch (SQLException ex) {
            Announce.warning("Connection check failed, this should not happen.", ex);
            return false;
        }
    }

    protected void attemptReconnect(SQLException cause, boolean autoReconnect) throws SQLException {
        boolean connected = this.connected();
        if (connected) {
            throw cause;
        }
        if (autoReconnect) {
            try {
                this.reconnect();
            }
            catch (SQLException ex2) {
                throw new ConnectionBrokenSQLException("Connection is broken. Reconnection attempt failed.\nOriginal exception at first try was:\n " + cause, ex2);
            }
        } else {
            throw new ConnectionBrokenSQLException("Connection is broken, did not try to reconnect and re-execute query.", cause);
        }
    }

    protected ResultSet executeQuery(String sql, int resultSetType, int resultSetConcurrency, Integer fetchsize) throws SQLException {
        Statement stmnt = this.connection.createStatement(resultSetType, resultSetConcurrency);
        if (fetchsize != null) {
            stmnt.setFetchSize(fetchsize);
        } else {
            stmnt.setFetchSize(this.fetchsize);
        }
        return stmnt.executeQuery(sql);
    }

    public ResultSet query(CharSequence sqlcs, int resultSetType, int resultSetConcurrency, Integer fetchsize) throws SQLException {
        String sql = this.prepareQuery(sqlcs.toString());
        if (sql.toUpperCase().startsWith("INSERT") || sql.toUpperCase().startsWith("UPDATE") || sql.toUpperCase().startsWith("DELETE") || sql.toUpperCase().startsWith("CREATE") || sql.toUpperCase().startsWith("DROP") || sql.toUpperCase().startsWith("ALTER")) {
            this.executeUpdate(sql);
            return null;
        }
        try {
            return this.executeQuery(sql, resultSetType, resultSetConcurrency, fetchsize);
        }
        catch (SQLException e) {
            this.attemptReconnect(e, this.autoReconnectOnSelect);
            return this.executeQuery(sql, resultSetType, resultSetConcurrency, fetchsize);
        }
    }

    public ResultSet query(CharSequence sqlcs, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.query(sqlcs, resultSetType, resultSetConcurrency, null);
    }

    public ResultSet query(CharSequence sql) throws SQLException {
        return this.query(sql, this.resultSetType, this.resultSetConcurrency);
    }

    public int executeUpdate(CharSequence sqlcs) throws SQLException {
        String sql = this.prepareQuery(sqlcs.toString());
        try {
            return this.executeUpdateQuery(sql);
        }
        catch (SQLException e) {
            this.attemptReconnect(e, this.autoReconnectOnUpdate);
            return this.executeUpdateQuery(sql);
        }
    }

    protected int executeUpdateQuery(String sqlcs) throws SQLException {
        String sql = this.prepareQuery(sqlcs.toString());
        try {
            Statement s = this.connection.createStatement();
            int result = s.executeUpdate(sql);
            Database.close(s);
            return result;
        }
        catch (SQLException e) {
            throw new SQLException(sql + "\n" + e.getMessage());
        }
    }

    public <T> ResultIterator<T> query(CharSequence sql, ResultIterator.ResultWrapper<T> rc) throws SQLException {
        return new ResultIterator<T>(this.query(sql, this.resultSetType, this.resultSetConcurrency), rc);
    }

    public <T> T queryValue(CharSequence sql, ResultIterator.ResultWrapper<T> rc) throws SQLException {
        ResultIterator<T> results = new ResultIterator<T>(this.query(sql), rc);
        Object result = results.nextOrNull();
        results.close();
        return result;
    }

    public boolean exists(CharSequence sql) throws SQLException {
        ResultSet rs = this.query(sql);
        boolean result = rs.next();
        Database.close(rs);
        return result;
    }

    public void startTransaction() throws InitTransactionSQLException {
        if (!this.inTransactionMode) {
            try {
                this.autoCommitWasOn = this.connection.getAutoCommit();
                if (this.autoCommitWasOn) {
                    this.connection.setAutoCommit(false);
                }
            }
            catch (SQLException ex) {
                throw new InitTransactionSQLException("Could not check and disable autocommit \nError was" + ex, ex);
            }
            try {
                this.originalTransactionMode = this.connection.getTransactionIsolation();
            }
            catch (SQLException ex) {
                throw new InitTransactionSQLException("Could not get hold of transaction isolation\nError was" + ex, ex);
            }
            try {
                this.connection.setTransactionIsolation(defaultTransactionMode);
            }
            catch (SQLException ex) {
                throw new InitTransactionSQLException("Could not set transaction isolation mode\nError was" + ex, ex);
            }
            this.inTransactionMode = true;
        }
    }

    protected void commitTransaction() throws TransactionSQLException {
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            CommitTransactionSQLException commitfail = new CommitTransactionSQLException("Could not commit transaction.", ex);
            try {
                this.resetTransaction();
            }
            catch (RollbackTransactionSQLException rex) {
                throw new RollbackTransactionSQLException(rex.getMessage(), commitfail);
            }
            throw commitfail;
        }
    }

    public void resetTransaction() throws TransactionSQLException {
        try {
            this.connection.rollback();
        }
        catch (SQLException ex2) {
            throw new RollbackTransactionSQLException("Could not rollback transaction.");
        }
        this.endTransaction();
    }

    public void endTransaction() throws TransactionSQLException {
        if (this.inTransactionMode) {
            this.commitTransaction();
            try {
                this.connection.setTransactionIsolation(this.originalTransactionMode);
            }
            catch (SQLException ex) {
                throw new TransactionSQLException("Could not shutdown transaction mode\n Error was:" + ex, ex);
            }
            try {
                if (this.autoCommitWasOn) {
                    this.connection.setAutoCommit(true);
                }
            }
            catch (SQLException ex) {
                throw new StartAutoCommitSQLException("Could not start autocommit\n Error was:" + ex, ex);
            }
            this.inTransactionMode = false;
        }
    }

    @Deprecated
    public void endTransaction(@Deprecated boolean flush) throws TransactionSQLException {
        this.endTransaction();
    }

    public void lockTableWriteAccess(Map<String, String> tableAndAliases) throws SQLException {
        throw new SQLException("Sorry this functionality is not implemented for your database system");
    }

    public void lockTableReadAccess(Map<String, String> tableAndAliases) throws SQLException {
        throw new SQLException("Sorry this functionality is not implemented for your database system");
    }

    public void releaseLocksAndEndTransaction() throws SQLException {
        throw new SQLException("Sorry this functionality is not implemented for your database system");
    }

    protected static void appendFixedLen(StringBuilder b, Object o, int len) {
        String s;
        String string = s = o == null ? "null" : o.toString();
        if (s.length() > len) {
            s = s.substring(0, len);
        }
        b.append(s);
        for (int i = s.length(); i < len; ++i) {
            b.append(' ');
        }
    }

    public static String describe(ResultSet r, int maxrows) throws SQLException {
        int i;
        int column;
        StringBuilder b = new StringBuilder();
        int columns = r.getMetaData().getColumnCount();
        int width = 120 / columns - 1;
        if (width < 3) {
            columns = 30;
            width = 3;
        }
        int screenwidth = (width + 1) * columns;
        for (column = 1; column <= columns; ++column) {
            Database.appendFixedLen(b, r.getMetaData().getColumnLabel(column), width);
            b.append('|');
        }
        b.append('\n');
        for (i = 0; i < screenwidth; ++i) {
            b.append('-');
        }
        b.append('\n');
        while (maxrows != 0) {
            if (!r.next()) {
                for (i = 0; i < screenwidth; ++i) {
                    b.append('-');
                }
                b.append('\n');
                break;
            }
            for (column = 1; column <= columns; ++column) {
                Database.appendFixedLen(b, r.getObject(column), width);
                b.append('|');
            }
            b.append('\n');
            --maxrows;
        }
        if (maxrows == 0 && r.next()) {
            b.append("...\n");
        }
        Database.close(r);
        return b.toString();
    }

    public static String describe(ResultSet r) throws SQLException {
        return Database.describe(r, -1);
    }

    public SQLType getSQLType(int t) {
        return this.type2SQL.get(t);
    }

    public SQLType getSQLType(int t, int scale) {
        SQLType s = this.getSQLType(t);
        s.scale = scale;
        return s;
    }

    public SQLType getSQLType(Class<?> c) {
        return this.java2SQL.get(c);
    }

    public String getSQLStmntIFNULL(String a, String b) {
        Announce.error("Your database system class needs to implement this functionality.");
        return "";
    }

    public String format(Object o) {
        SQLType t = this.getSQLType(o.getClass());
        if (t == null) {
            t = this.getSQLType(String.class);
            return t.format(o.toString());
        }
        return t.format(o);
    }

    public String formatNullToNull(Object o) {
        if (o == null) {
            return "NULL";
        }
        return this.format(o);
    }

    public String cast(String value, String type) {
        StringBuilder sql = new StringBuilder("CAST(");
        sql.append(value).append(" AS ").append(type).append(")");
        return sql.toString();
    }

    public String limit(String sql, int n) {
        return sql + " LIMIT " + n;
    }

    public String offset(String sql, int n) {
        return sql + " OFFSET " + n;
    }

    public String autoincrementColumn() {
        Announce.error("This functionality is not provided for this database type. It may simply lack implementation at the Database class.");
        return null;
    }

    public void createTable(String name, Object ... attributes) throws SQLException {
        Announce.doingDetailed("Creating table " + name);
        try {
            this.executeUpdate("DROP TABLE " + name);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        StringBuilder b = new StringBuilder("CREATE TABLE ").append(name).append(" (");
        for (int i = 0; i < attributes.length; i += 2) {
            b.append(attributes[i]).append(' ');
            if (attributes[i + 1] instanceof Integer) {
                b.append(this.getSQLType((Integer)attributes[i + 1])).append(", ");
                continue;
            }
            b.append(this.getSQLType((Class)attributes[i + 1])).append(", ");
        }
        b.setLength(b.length() - 2);
        b.append(')');
        this.executeUpdate(b.toString());
        Announce.doneDetailed();
    }

    public boolean existsTable(String table) {
        ResultSet rs = null;
        try {
            rs = this.query("SELECT * FROM " + table + " LIMIT 1");
        }
        catch (SQLException ex) {
            Announce.debug(ex);
            return false;
        }
        if (rs != null) {
            Database.close(rs);
        }
        return true;
    }

    public String indexName(String table, String ... attributes) {
        StringBuffer sb = new StringBuffer();
        sb.append("I_");
        sb.append(table.hashCode());
        sb.append("_");
        StringBuffer att = new StringBuffer();
        for (int i = 0; i < attributes.length; ++i) {
            att.append(attributes[i]);
            att.append("_");
        }
        if (att.length() > 0) {
            att.setLength(att.length() - 1);
        }
        sb.append(att.hashCode());
        return sb.toString().replace("-", "m");
    }

    public String createIndexCommand(String table, boolean unique, String ... attributes) {
        StringBuilder sql = new StringBuilder("CREATE ");
        if (unique) {
            sql.append("UNIQUE ");
        }
        sql.append("INDEX ");
        sql.append(this.indexName(table, attributes));
        sql.append(" ON ").append(table).append(" (");
        for (String a : attributes) {
            sql.append(a).append(", ");
        }
        sql.setLength(sql.length() - 2);
        sql.append(")");
        return sql.toString();
    }

    public void createIndex(String table, boolean unique, String ... attributes) throws SQLException {
        Announce.doingDetailed("Creating index " + this.indexName(table, attributes) + " on table " + table);
        String comand = this.createIndexCommand(table, unique, attributes);
        Announce.debug(comand);
        try {
            this.executeUpdate("DROP INDEX " + this.indexName(table, attributes));
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.executeUpdate(comand);
        Announce.doneDetailed();
    }

    public void createIndices(String table, String ... attributes) throws SQLException {
        for (String a : attributes) {
            this.createIndex(table, false, a);
        }
    }

    public void createPrimaryKey(String table, String ... attributes) throws SQLException {
        Announce.doingDetailed("Creating primary Key on table " + table);
        StringBuilder sql = new StringBuilder("ALTER TABLE ");
        sql.append(table);
        sql.append(" ADD PRIMARY KEY (");
        for (String a : attributes) {
            sql.append(a).append(", ");
        }
        sql.setLength(sql.length() - 2);
        sql.append(")");
        Announce.debug(sql);
        try {
            this.executeUpdate("ALTER TABLE " + table + " DROP PRIMARY KEY");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.executeUpdate(sql.toString());
        Announce.doneDetailed();
    }

    public void createView(String name, String query) throws SQLException {
        Announce.doingDetailed("Creating view " + name);
        Announce.messageDetailed(" with query: " + query);
        StringBuilder sql = new StringBuilder("CREATE VIEW ");
        sql.append(name);
        sql.append(" AS (");
        sql.append(query);
        sql.append(")");
        Announce.debug(sql);
        try {
            this.executeUpdate("DROP VIEW " + name);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.executeUpdate(sql.toString());
        Announce.doneDetailed();
    }

    public void makeCSV(String table, File output, char separator) throws IOException, SQLException {
        this.makeCSVForQuery("SELECT * FROM " + table, output, separator);
    }

    public void dumpCSV(String table, File output, char separator) throws IOException, SQLException {
        this.dumpQueryAsCSV("SELECT * FROM " + table, output, separator);
    }

    public void makeCSVForQuery(String selectCommand, File output, char separator) throws IOException, SQLException {
        int column;
        ResultSet r = this.query(selectCommand);
        UTF8Writer out = new UTF8Writer(output);
        int columns = r.getMetaData().getColumnCount();
        for (column = 1; column <= columns; ++column) {
            ((Writer)out).write(r.getMetaData().getColumnLabel(column));
            if (column == columns) {
                ((Writer)out).write("\n");
                continue;
            }
            ((Writer)out).write(separator + " ");
        }
        while (r.next()) {
            for (column = 1; column <= columns; ++column) {
                Object o = r.getObject(column);
                ((Writer)out).write(o == null ? "null" : o.toString());
                if (column == columns) {
                    ((Writer)out).write("\n");
                    continue;
                }
                ((Writer)out).write(separator + " ");
            }
        }
        Database.close(r);
        ((Writer)out).close();
    }

    public void dumpQueryAsCSV(String selectCommand, File output, char separator) throws IOException, SQLException {
        ResultSet r = this.query(selectCommand);
        ResultSetMetaData meta = r.getMetaData();
        int numCols = meta.getColumnCount();
        ArrayList<String> labels = new ArrayList<String>();
        for (int i = 1; i <= numCols; ++i) {
            labels.add(meta.getColumnLabel(i));
        }
        CSVFile csv = new CSVFile(output, false, separator + "", labels);
        while (r.next()) {
            Object[] cols = new String[numCols];
            for (int column = 0; column < numCols; ++column) {
                cols[column] = r.getObject(column + 1);
            }
            csv.write(cols);
        }
        Database.close(r);
        csv.close();
    }

    public void loadCSV(String table, File input, boolean clearTable, char separator) throws IOException, SQLException {
        if (clearTable) {
            this.executeUpdate("DELETE FROM " + table);
        }
        Inserter bulki = this.newInserter(table);
        CSVLines csv = new CSVLines(input);
        if (csv.numColumns() != null && csv.numColumns().intValue() != bulki.numColumns()) {
            throw new SQLException("File " + input.getName() + " has " + csv.numColumns() + " columns, but table " + table + " has " + bulki.numColumns());
        }
        for (List values : csv) {
            if (values.size() != bulki.numColumns()) {
                Announce.warning("Line cannot be read from file", input.getName(), "into table", table, ":\n", values);
                continue;
            }
            bulki.insert(new Object[]{values});
        }
        bulki.close();
    }

    public String toString() {
        return this.description;
    }

    public void runInterface() {
        Announce.message("Connected to", this);
        while (true) {
            String s;
            D.p("Enter an SQL query (possibly of multiple lines), followed by a blank line (or just a blank line to quit):");
            StringBuilder sql = new StringBuilder();
            while ((s = D.r()).length() != 0) {
                sql.append(s).append("\n");
            }
            if (sql.length() == 0) break;
            sql.setLength(sql.length() - 1);
            Announce.doing("Querying database");
            if (sql.length() == 0) break;
            try {
                ResultSet result = this.query(sql.toString());
                Announce.done();
                if (result == null) continue;
                D.p(Database.describe(result, 50));
            }
            catch (SQLException e) {
                Announce.failed();
                e.printStackTrace(System.err);
                Announce.message("\n\n... but don't give up, try again!");
            }
        }
        Announce.doing("Closing database");
        this.close();
        Announce.done();
    }

    public static void main(String[] args) throws Exception {
        new PostgresDatabase("postgres", "postgres", null, null, null).runInterface();
    }

    public Inserter newInserter(String table) throws SQLException {
        return new Inserter(table);
    }

    public Inserter newInserter(String table, Class<?> ... argumentTypes) throws SQLException {
        return new Inserter(table, argumentTypes);
    }

    public Inserter newInserter(String table, int ... argumentTypes) throws SQLException {
        return new Inserter(table, argumentTypes);
    }

    public static class StartAutoCommitSQLException
    extends TransactionSQLException {
        private static final long serialVersionUID = 1L;

        public StartAutoCommitSQLException() {
        }

        public StartAutoCommitSQLException(String message) {
            super(message);
        }

        public StartAutoCommitSQLException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static class RollbackTransactionSQLException
    extends TransactionSQLException {
        private static final long serialVersionUID = 1L;

        public RollbackTransactionSQLException() {
        }

        public RollbackTransactionSQLException(String message) {
            super(message);
        }

        public RollbackTransactionSQLException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static class CommitTransactionSQLException
    extends TransactionSQLException {
        private static final long serialVersionUID = 1L;

        public CommitTransactionSQLException() {
        }

        public CommitTransactionSQLException(String message) {
            super(message);
        }

        public CommitTransactionSQLException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static class InitTransactionSQLException
    extends TransactionSQLException {
        private static final long serialVersionUID = 1L;

        public InitTransactionSQLException() {
        }

        public InitTransactionSQLException(String message) {
            super(message);
        }

        public InitTransactionSQLException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static class TransactionSQLException
    extends SQLException {
        private static final long serialVersionUID = 1L;

        public TransactionSQLException() {
        }

        public TransactionSQLException(String message) {
            super(message);
        }

        public TransactionSQLException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static class ConnectionBrokenSQLException
    extends SQLException {
        private static final long serialVersionUID = 1L;

        public ConnectionBrokenSQLException() {
        }

        public ConnectionBrokenSQLException(String message) {
            super(message);
        }

        public ConnectionBrokenSQLException(Throwable cause) {
            super(cause);
        }

        public ConnectionBrokenSQLException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public class Inserter
    implements Closeable {
        protected List<List<Object>> values = new ArrayList<List<Object>>();
        protected String tableName;
        String query = null;
        protected SQLType[] columnTypes;
        private int batchThreshold = 1000;
        private boolean closed = false;

        public Inserter(String table) throws SQLException {
            Database.this.inserters.add(this);
            this.setTargetTable(table);
        }

        public Inserter(String table, Class<?> ... columnTypes) throws SQLException {
            Database.this.inserters.add(this);
            this.setTargetTable(table, columnTypes);
        }

        public Inserter(String table, int ... columnTypes) throws SQLException {
            Database.this.inserters.add(this);
            this.setTargetTable(table, columnTypes);
        }

        public Inserter(String table, String[] colnames, Class<?>[] coltypes) throws SQLException {
            Database.this.inserters.add(this);
            this.setTargetTable(table, colnames, coltypes);
        }

        @Override
        public synchronized void close() {
            if (this.closed) {
                return;
            }
            try {
                this.flush();
            }
            catch (SQLException e) {
                Announce.error(e);
            }
            Database.this.inserters.remove(this);
            this.closed = true;
        }

        protected void finalize() {
            this.close();
        }

        public void setBatchThreshold(int size) {
            this.batchThreshold = size;
        }

        public int getBatchThreshold() {
            return this.batchThreshold;
        }

        public String getTableName() {
            return this.tableName;
        }

        public int getBatchSize() {
            return this.values.size();
        }

        public int numColumns() {
            return this.columnTypes.length;
        }

        protected void setTargetTable(String table) throws SQLException {
            int i;
            ResultSet r = Database.this.query(Database.this.limit("SELECT * FROM " + table, 1));
            ResultSetMetaData meta = r.getMetaData();
            this.columnTypes = new SQLType[meta.getColumnCount()];
            for (i = 0; i < this.columnTypes.length; ++i) {
                this.columnTypes[i] = Database.this.getSQLType(meta.getColumnType(i + 1));
            }
            Database.close(r);
            this.tableName = table;
            table = "INSERT INTO " + table + " VALUES(";
            for (i = 0; i < this.columnTypes.length - 1; ++i) {
                table = table + "?, ";
            }
            this.query = table = table + "?)";
        }

        protected void setTargetTable(String table, Class<?> ... columnTypes) throws SQLException {
            int i;
            this.columnTypes = new SQLType[columnTypes.length];
            for (i = 0; i < columnTypes.length; ++i) {
                this.columnTypes[i] = Database.this.getSQLType(columnTypes[i]);
            }
            this.tableName = table;
            table = "INSERT INTO " + table + " VALUES(";
            for (i = 0; i < columnTypes.length - 1; ++i) {
                table = table + "?, ";
            }
            this.query = table = table + "?)";
        }

        protected void setTargetTable(String table, int ... columnTypes) throws SQLException {
            int i;
            this.columnTypes = new SQLType[columnTypes.length];
            for (i = 0; i < columnTypes.length; ++i) {
                this.columnTypes[i] = Database.this.getSQLType(columnTypes[i]);
            }
            this.tableName = table;
            table = "INSERT INTO " + table + " VALUES(";
            for (i = 0; i < columnTypes.length - 1; ++i) {
                table = table + "?, ";
            }
            this.query = table = table + "?)";
        }

        protected void setTargetTable(String table, String[] colnames, Class<?>[] coltypes) throws SQLException {
            if (colnames.length != coltypes.length) {
                throw new SQLException("Column types and names do not match.");
            }
            this.columnTypes = new SQLType[colnames.length];
            int i = 0;
            for (Class<?> col : coltypes) {
                this.columnTypes[i] = Database.this.getSQLType(col);
                ++i;
            }
            this.tableName = table;
            table = "INSERT INTO " + table + "(";
            table = table + StringModifier.implode(colnames, ",");
            table = table + ") VALUES(";
            for (i = 0; i < this.columnTypes.length - 1; ++i) {
                table = table + "?, ";
            }
            this.query = table = table + "?)";
        }

        public void insert(List<Object> row) throws SQLException {
            this.values.add(row);
            if (this.values.size() % this.batchThreshold == 0) {
                this.flush();
            }
        }

        public void insert(Object ... values) throws SQLException {
            this.insert(Arrays.asList(values));
        }

        public synchronized void flush() throws SQLException {
            if (this.values.isEmpty()) {
                return;
            }
            List<List<Object>> oldBatch = this.values;
            this.values = new ArrayList<List<Object>>();
            try {
                this.flush(oldBatch);
            }
            catch (SQLException e) {
                String details = e.getNextException() == null ? "" : e.getNextException().getMessage();
                SQLException ex = new SQLException(e.getMessage() + "\n\n" + details);
                try {
                    Database.this.attemptReconnect(ex, Database.this.autoReconnectOnUpdate);
                    this.flush(oldBatch);
                }
                catch (SQLException ex2) {
                    this.values.addAll(oldBatch);
                    throw ex2;
                }
            }
        }

        protected void flush(List<List<Object>> batch) throws SQLException {
            PreparedStatement preparedStatement = Database.this.getConnection().prepareStatement(this.query);
            for (List<Object> row : batch) {
                try {
                    for (int i = 0; i < row.size(); ++i) {
                        preparedStatement.setObject(i + 1, row.get(i), this.columnTypes[i].getTypeCode());
                    }
                    preparedStatement.addBatch();
                }
                catch (SQLException e) {
                    throw new SQLException("Bulk-insert into " + this.tableName + " " + row + "\n" + e.getMessage());
                }
            }
            preparedStatement.executeBatch();
            preparedStatement.clearBatch();
            Database.close(preparedStatement);
        }
    }
}

