/*
 * Decompiled with CFR 0.152.
 */
package javatools.database;

import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import javatools.administrative.D;
import javatools.database.Database;
import javatools.database.SQLType;

public class PostgresDatabase
extends Database {
    private String user = null;
    private String password = null;
    private String database = null;
    private String host = null;
    private String port = null;
    protected String schema = null;
    private boolean useSSL = false;
    public static PostgreVarchar postgrevarchar = new PostgreVarchar();
    public static Postgretext postgretext = new Postgretext();

    public PostgresDatabase() {
        this.java2SQL.put(String.class, postgretext);
        this.type2SQL.put(12, postgrevarchar);
        this.type2SQL.put(2004, postgretext);
    }

    public PostgresDatabase(String user, String password, String database, String host, String port, boolean useSSL) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException {
        this(user, password, database, host, port, null, useSSL);
    }

    public PostgresDatabase(String user, String password, String database, String host, String port) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException {
        this(user, password, database, host, port, false);
    }

    public PostgresDatabase(String user, String password, String database, String host, String port, String schema, boolean useSSL) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException {
        this();
        if (password == null) {
            password = "";
        }
        if (host == null || host.length() == 0) {
            host = "localhost";
        }
        if (port == null || port.length() == 0) {
            port = "5432";
        }
        this.driver = (Driver)Class.forName("org.postgresql.Driver").newInstance();
        DriverManager.registerDriver(this.driver);
        this.user = user;
        this.password = password;
        this.database = database;
        this.host = host;
        this.port = port;
        this.useSSL = useSSL;
        this.schema = schema;
        this.connect();
    }

    public PostgresDatabase(String user, String password, String database, String host, String port, String schema) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException {
        this(user, password, database, host, port, schema, false);
    }

    @Override
    public void connect() throws SQLException {
        String url = "jdbc:postgresql://" + this.host + ":" + this.port + (this.database == null ? "" : "/" + this.database) + (this.useSSL ? "?ssl=true&sslfactory=org.postgresql.ssl.NonValidatingFactory" : "");
        this.connection = DriverManager.getConnection(url, this.user, this.password);
        this.connection.setAutoCommit(true);
        this.setSchema(this.schema);
        this.description = "Postgres database '" + this.database + "' as '" + this.user + "' at " + this.host + ":" + this.port + " using schema '" + this.schema + "'";
    }

    public void setSchema(String s) throws SQLException {
        if (s == null) {
            return;
        }
        this.executeUpdate("SET search_path TO " + s + ", public");
        this.schema = s;
        this.description = this.description.substring(0, this.description.lastIndexOf(32)) + " " + this.schema;
    }

    public void setExclusiveSchema(String s) throws SQLException {
        this.executeUpdate("SET search_path TO " + s + "");
        this.schema = s;
        this.description = this.description.substring(0, this.description.lastIndexOf(32)) + " " + this.schema;
    }

    @Override
    public void createTable(String name, Object ... attributes) throws SQLException {
        try {
            this.executeUpdate("DROP TABLE " + this.schema + "." + name);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        StringBuilder b = new StringBuilder("CREATE TABLE ").append(this.schema).append(".").append(name).append(" (");
        for (int i = 0; i < attributes.length; i += 2) {
            b.append(attributes[i]).append(' ');
            if (attributes[i + 1] instanceof Integer) {
                b.append(this.getSQLType((Integer)attributes[i + 1])).append(", ");
                continue;
            }
            b.append(this.getSQLType((Class)attributes[i + 1])).append(", ");
        }
        b.setLength(b.length() - 2);
        b.append(')');
        this.executeUpdate(b.toString());
    }

    @Override
    public boolean jarAvailable() {
        try {
            Class.forName("org.postgresql.Driver").newInstance();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public String cast(String value, String type) {
        StringBuilder sql = new StringBuilder("CAST(");
        sql.append(value).append(" AS ").append(type).append(")");
        return sql.toString();
    }

    @Override
    public String getSQLStmntIFNULL(String a, String b) {
        return "COALESCE(" + a + "," + b + ")";
    }

    @Override
    public String autoincrementColumn() {
        return "SERIAL";
    }

    @Override
    public void startTransaction() throws Database.InitTransactionSQLException {
        super.startTransaction();
        try {
            Statement stmnt = this.connection.createStatement();
            stmnt.executeUpdate("BEGIN");
            PostgresDatabase.close(stmnt);
        }
        catch (SQLException ex) {
            throw new Database.InitTransactionSQLException("Could not start transaction.", ex);
        }
    }

    @Override
    protected void commitTransaction() throws Database.TransactionSQLException {
        try {
            Statement stmnt = this.connection.createStatement();
            stmnt.executeUpdate("COMMIT");
            PostgresDatabase.close(stmnt);
            this.connection.commit();
        }
        catch (SQLException ex) {
            Database.CommitTransactionSQLException commitfail = new Database.CommitTransactionSQLException("Could not commit transaction.", ex);
            try {
                this.resetTransaction();
            }
            catch (Database.RollbackTransactionSQLException rex) {
                throw new Database.RollbackTransactionSQLException(rex.getMessage(), commitfail);
            }
            throw commitfail;
        }
    }

    @Override
    public void lockTableWriteAccess(Map<String, String> tablesAndAliases) throws SQLException {
        for (String table : tablesAndAliases.keySet()) {
            String sql = "LOCK TABLE " + table + " IN EXCLUSIVE MODE";
            this.connection.createStatement().executeUpdate(sql);
        }
    }

    @Override
    public void lockTableReadAccess(Map<String, String> tablesAndAliases) throws SQLException {
        for (String table : tablesAndAliases.keySet()) {
            String sql = "LOCK TABLE " + table + " IN ACCESS EXCLUSIVE MODE";
            this.connection.createStatement().executeUpdate(sql);
        }
    }

    @Override
    public void releaseLocksAndEndTransaction() throws SQLException {
        this.endTransaction(true);
    }

    public static void main(String[] args) {
        try {
            PostgresDatabase d = new PostgresDatabase("postgres", "postgres", "postgres", null, null);
            d.executeUpdate("INSERT into test values (1,2)");
            ResultSet s = d.query("select * from test");
            s.next();
            D.p(s.getString(1));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static class Postgretext
    extends SQLType {
        public Postgretext(int size) {
            this.typeCode = 2004;
            this.scale = 0;
        }

        public Postgretext() {
            this(0);
        }

        @Override
        public String format(Object o) {
            String s = o.toString().replace("'", "''").replace("\\", "\\\\");
            return "E'" + s + "'";
        }

        public String toString() {
            return "TEXT";
        }
    }

    public static class PostgreVarchar
    extends SQLType.ANSIvarchar {
        public PostgreVarchar(int size) {
            super(size);
        }

        public PostgreVarchar() {
        }

        @Override
        public String toString() {
            return "VARCHAR(" + this.scale + ")";
        }

        @Override
        public String format(Object o) {
            String s = o.toString();
            if (s.length() > this.scale) {
                s = s.substring(0, this.scale);
            }
            s = s.replace("'", "''").replace("\\", "\\\\");
            return "E'" + s + "'";
        }
    }
}

