/*
 * Decompiled with CFR 0.152.
 */
package javatools.database;

import java.sql.ResultSet;
import java.sql.SQLException;
import javatools.database.Database;
import javatools.datatypes.PeekIterator;

public class ResultIterator<T>
extends PeekIterator<T> {
    protected ResultSet resultSet;
    protected ResultWrapper<T> constructor;
    public static final ResultWrapper<Boolean> BooleanWrapper = new ResultWrapper<Boolean>(){

        @Override
        public Boolean wrap(ResultSet r) throws SQLException {
            return r.getBoolean(1);
        }
    };
    public static final ResultWrapper<String> StringWrapper = new ResultWrapper<String>(){

        @Override
        public String wrap(ResultSet r) throws SQLException {
            return r.getString(1);
        }
    };
    public static final ResultWrapper<String[]> StringsWrapper = new ResultWrapper<String[]>(){

        @Override
        public String[] wrap(ResultSet r) throws SQLException {
            String[] result = new String[r.getMetaData().getColumnCount()];
            for (int i = 0; i < result.length; ++i) {
                result[i] = r.getString(i + 1);
            }
            return result;
        }
    };
    public static final ResultWrapper<Long> LongWrapper = new ResultWrapper<Long>(){

        @Override
        public Long wrap(ResultSet r) throws SQLException {
            long l = r.getLong(1);
            return r.wasNull() ? null : Long.valueOf(l);
        }
    };
    public static final ResultWrapper<Double> DoubleWrapper = new ResultWrapper<Double>(){

        @Override
        public Double wrap(ResultSet r) throws SQLException {
            double l = r.getDouble(1);
            return r.wasNull() ? null : Double.valueOf(l);
        }
    };
    public static final ResultWrapper<Double[]> DoublesWrapper = new ResultWrapper<Double[]>(){

        @Override
        public Double[] wrap(ResultSet r) throws SQLException {
            Double[] result = new Double[r.getMetaData().getColumnCount()];
            for (int i = 0; i < result.length; ++i) {
                result[i] = r.getDouble(i + 1);
                if (!r.wasNull()) continue;
                result[i] = null;
            }
            return result;
        }
    };
    public static final ResultWrapper<Integer> IntegerWrapper = new ResultWrapper<Integer>(){

        @Override
        public Integer wrap(ResultSet r) throws SQLException {
            int l = r.getInt(1);
            return r.wasNull() ? null : Integer.valueOf(l);
        }
    };
    public static final ResultWrapper<Integer[]> IntegersWrapper = new ResultWrapper<Integer[]>(){

        @Override
        public Integer[] wrap(ResultSet r) throws SQLException {
            Integer[] result = new Integer[r.getMetaData().getColumnCount()];
            for (int i = 0; i < result.length; ++i) {
                result[i] = r.getInt(i + 1);
                if (!r.wasNull()) continue;
                result[i] = null;
            }
            return result;
        }
    };

    public ResultIterator(ResultSet s, ResultWrapper<T> cons) {
        this.resultSet = s;
        this.constructor = cons;
    }

    protected ResultIterator() {
    }

    @Override
    public T internalNext() throws Exception {
        if (!this.resultSet.next()) {
            return null;
        }
        return this.constructor.wrap(this.resultSet);
    }

    @Override
    public void close() {
        Database.close(this.resultSet);
    }

    public void finalize() {
        this.close();
    }

    public static interface ResultWrapper<T> {
        public T wrap(ResultSet var1) throws Exception;
    }
}

