/*
 * Decompiled with CFR 0.152.
 */
package javatools.database;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javatools.administrative.D;
import javatools.parsers.DateParser;
import javatools.parsers.NumberFormatter;
import javatools.parsers.NumberParser;

public abstract class SQLType {
    protected int typeCode;
    protected int scale = 0;
    public static ANSIvarchar ansivarchar = new ANSIvarchar();
    public static ANSIblob ansiblob = new ANSIblob();
    public static ANSItext ansitext = new ANSItext();
    public static ANSIchar ansichar = new ANSIchar();
    public static ANSItimestamp ansitimestamp = new ANSItimestamp();
    public static ANSIinteger ansiinteger = new ANSIinteger();
    public static ANSIsmallint ansismallint = new ANSIsmallint();
    public static ANSIfloat ansifloat = new ANSIfloat();
    public static ANSIboolean ansiboolean = new ANSIboolean();
    public static ANSIBigint ansibigint = new ANSIBigint();

    public abstract String format(Object var1);

    public int getTypeCode() {
        return this.typeCode;
    }

    public int getScale() {
        return this.scale;
    }

    public static void main(String[] args) {
        D.p(ansifloat.format(0.0067));
    }

    public static class ANSIBigint
    extends SQLType {
        public ANSIBigint() {
            this.typeCode = -5;
        }

        @Override
        public String format(Object o) {
            if (o instanceof Double) {
                return "" + Math.rint((Double)o);
            }
            if (o instanceof Float) {
                return "" + Math.rint(((Float)o).floatValue());
            }
            if (o instanceof Integer) {
                return "" + ((Integer)o).longValue();
            }
            if (o instanceof Long) {
                return "" + (Long)o;
            }
            if (o instanceof BigInteger) {
                return o.toString();
            }
            if (o instanceof BigDecimal) {
                return ((BigDecimal)o).toBigInteger().toString();
            }
            if (o instanceof String) {
                return o.toString();
            }
            return null;
        }

        public String toString() {
            return "BIGINT";
        }
    }

    public static class ANSIboolean
    extends SQLType {
        public ANSIboolean() {
            this.typeCode = 16;
        }

        @Override
        public String format(Object o) {
            if (o instanceof Boolean) {
                return o.toString();
            }
            if (o instanceof Float) {
                return Boolean.toString((double)((Float)o).floatValue() != 0.0).toString();
            }
            if (o instanceof Double) {
                return Boolean.toString((Double)o != 0.0);
            }
            if (o instanceof Integer) {
                return Boolean.toString((Integer)o != 0);
            }
            if (o instanceof Long) {
                return Boolean.toString((Long)o != 0L);
            }
            if (o instanceof String) {
                return Boolean.toString(Boolean.parseBoolean(o.toString()));
            }
            return null;
        }

        public String toString() {
            return "BOOLEAN";
        }
    }

    public static class ANSIfloat
    extends SQLType {
        public ANSIfloat(int size) {
            this.typeCode = 6;
            this.scale = size;
        }

        public ANSIfloat() {
            this(0);
        }

        @Override
        public String format(Object o) {
            if (o instanceof Double || o instanceof Float || o instanceof Integer || o instanceof Long) {
                return o.toString();
            }
            if (o instanceof String) {
                return NumberParser.getNumber(NumberParser.normalize(o.toString()));
            }
            return null;
        }

        public String toString() {
            if (this.scale == 0) {
                return "FLOAT";
            }
            return "FLOAT(" + this.scale + ")";
        }
    }

    public static class ANSIsmallint
    extends SQLType {
        public ANSIsmallint(int size) {
            this.typeCode = 5;
            this.scale = size;
        }

        public ANSIsmallint() {
            this(0);
        }

        @Override
        public String format(Object o) {
            if (o instanceof Double) {
                return "" + Math.rint((Double)o);
            }
            if (o instanceof Float) {
                return "" + Math.rint(((Float)o).floatValue());
            }
            if (o instanceof Integer) {
                return "" + ((Integer)o).longValue();
            }
            if (o instanceof Long) {
                return "" + (Long)o;
            }
            if (o instanceof String) {
                return "" + NumberParser.getLong(o.toString());
            }
            return null;
        }

        public String toString() {
            if (this.scale == 0) {
                return "SMALLINT";
            }
            return "SMALLINT(" + this.scale + ")";
        }
    }

    public static class ANSIinteger
    extends SQLType {
        public ANSIinteger(int size) {
            this.typeCode = 4;
            this.scale = size;
        }

        public ANSIinteger() {
            this(0);
        }

        @Override
        public String format(Object o) {
            if (o instanceof Double) {
                return "" + Math.rint((Double)o);
            }
            if (o instanceof Float) {
                return "" + Math.rint(((Float)o).floatValue());
            }
            if (o instanceof Integer) {
                return "" + ((Integer)o).longValue();
            }
            if (o instanceof Long) {
                return "" + (Long)o;
            }
            if (o instanceof String) {
                return "" + NumberParser.getLong(o.toString());
            }
            return null;
        }

        public String toString() {
            if (this.scale == 0) {
                return "INTEGER";
            }
            return "INTEGER(" + this.scale + ")";
        }
    }

    public static class ANSItimestamp
    extends SQLType {
        public ANSItimestamp() {
            this.typeCode = 93;
        }

        @Override
        public String format(Object o) {
            if (o instanceof String) {
                o = DateParser.asCalendar(DateParser.normalize(o.toString()));
            }
            if (o instanceof Calendar) {
                Calendar c = (Calendar)o;
                String s = NumberFormatter.ISOtime(c).replace("T ", "");
                s = s.substring(0, s.indexOf(46));
                return "TIMESTAMP '" + s + "'";
            }
            if (o instanceof Date) {
                Date d = (Date)o;
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
                return "'" + format.format(d) + "'";
            }
            return null;
        }

        public String toString() {
            return "TIMESTAMP";
        }
    }

    public static class ANSIchar
    extends SQLType {
        public ANSIchar(int size) {
            this.typeCode = 1;
            this.scale = 0;
        }

        public ANSIchar() {
            this(0);
        }

        @Override
        public String format(Object o) {
            if (o == null) {
                return "null";
            }
            String s = o.toString();
            if (s.length() == 0) {
                return "null";
            }
            char c = s.charAt(0);
            if (c == '\'') {
                return "'\\''";
            }
            return "'" + c + "'";
        }

        public String toString() {
            return "CHAR";
        }
    }

    public static class ANSItext
    extends SQLType {
        public ANSItext(int size) {
            this.typeCode = 2004;
            this.scale = 0;
        }

        public ANSItext() {
            this(0);
        }

        @Override
        public String format(Object o) {
            String s = o.toString().replace("'", "\\'");
            return "'" + s + "'";
        }

        public String toString() {
            return "TEXT";
        }
    }

    public static class ANSIblob
    extends SQLType {
        public ANSIblob(int size) {
            this.typeCode = 2004;
            this.scale = 0;
        }

        public ANSIblob() {
            this(0);
        }

        @Override
        public String format(Object o) {
            String s = o.toString().replace("'", "\\'");
            return "'" + s + "'";
        }

        public String toString() {
            return "BLOB";
        }
    }

    public static class ANSIvarchar
    extends SQLType {
        public ANSIvarchar(int size) {
            this.typeCode = 12;
            this.scale = size;
        }

        public ANSIvarchar() {
            this(255);
        }

        @Override
        public String format(Object o) {
            String s = o.toString().replace("'", "\\'");
            if (s.length() > this.scale) {
                s = s.substring(0, this.scale);
            }
            return "'" + s + "'";
        }

        public String toString() {
            return "VARCHAR(" + this.scale + ")";
        }
    }
}

