/*
 * Decompiled with CFR 0.152.
 */
package javatools.datatypes;

import java.util.Arrays;
import java.util.TreeSet;
import javatools.administrative.D;
import javatools.parsers.Char17;

public class CompressedString
implements CharSequence,
Comparable<CompressedString> {
    protected byte BITSPERCHAR;
    protected byte[] data;
    protected int startBit;
    protected int length;

    public int hashCode() {
        return Arrays.hashCode(this.data);
    }

    @Override
    public int length() {
        return this.length;
    }

    public int size() {
        return this.data.length;
    }

    public int bits() {
        return this.BITSPERCHAR;
    }

    @Override
    public char charAt(int index) {
        if (index >= this.length) {
            throw new IndexOutOfBoundsException(this.toString() + "@" + index);
        }
        int bytepos = index * this.BITSPERCHAR + this.startBit >> 3;
        int bitpos = index * this.BITSPERCHAR + this.startBit & 7;
        int l = (this.data[bytepos] & 0xFF) >> bitpos;
        if (this.BITSPERCHAR > 8 - bitpos) {
            l |= this.data[bytepos + 1] << 8 - bitpos;
        }
        if (this.BITSPERCHAR < 7 && ((l &= (1 << this.BITSPERCHAR) - 1) | 0x40) <= 90 && (l | 0x40) >= 65) {
            l |= 0x40;
        }
        if (this.BITSPERCHAR <= 5 && l < 32) {
            l |= 0x20;
        }
        return (char)l;
    }

    public boolean equals(Object o) {
        return o != null && o instanceof CharSequence && this.compareTo((CharSequence)o) == 0;
    }

    public CharSequence normalize(CharSequence s) {
        if (s instanceof CompressedString) {
            return s;
        }
        if (this.BITSPERCHAR == 8) {
            return s;
        }
        if (this.BITSPERCHAR == 7) {
            return Char17.normalize(s.toString());
        }
        return Char17.normalize(s.toString()).toUpperCase();
    }

    @Override
    public int compareTo(CharSequence s0) {
        int c2;
        int c1;
        if (this.length() == 0) {
            return s0.length() == 0 ? 0 : -1;
        }
        if (s0.length() == 0) {
            return 1;
        }
        CompressedString s1 = s0 instanceof CompressedString ? (CompressedString)s0 : new CompressedString(s0, this.BITSPERCHAR);
        CompressedString s2 = this;
        if (s1.BITSPERCHAR != s2.BITSPERCHAR) {
            return this.toString().compareTo(s0.toString());
        }
        int shift1 = s1.startBit & 7;
        int shift2 = s2.startBit & 7;
        int i1 = s1.startBit >> 3;
        int i2 = s2.startBit >> 3;
        int num = Math.min(s1.length, s2.length) * s1.BITSPERCHAR >> 3;
        while (--num > 0) {
            c1 = (s1.data[i1] >> shift1 | s1.data[i1 + 1] << 8 - shift1) & 0xFF;
            c2 = (s2.data[i2] >> shift2 | s1.data[i2 + 1] << 8 - shift2) & 0xFF;
            if (c1 > c2) {
                return -1;
            }
            if (c1 < c2) {
                return 1;
            }
            ++i1;
            ++i2;
        }
        c1 = s1.data[i1] >> shift1 & 0xFF;
        c2 = s2.data[i2] >> shift2 & 0xFF;
        if (s1.length > s2.length) {
            c1 |= s1.data[i1 + 1] << 8 - shift1 & 0xFF;
        }
        if (s2.length > s1.length) {
            c2 |= s2.data[i2 + 1] << 8 - shift2 & 0xFF;
        }
        if (c1 > c2) {
            return -1;
        }
        if (c1 < c2) {
            return 1;
        }
        if (s1.length() > s2.length()) {
            return -1;
        }
        if (s1.length() < s2.length()) {
            return 1;
        }
        return 0;
    }

    @Override
    public int compareTo(CompressedString s) {
        return this.compareTo((CharSequence)s);
    }

    protected CompressedString(byte[] data, int startBit, int length) {
        this.data = data;
        this.startBit = startBit;
        this.length = length;
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        if (start < 0 || end < 0 || end > this.length || start > end) {
            throw new IndexOutOfBoundsException(this.toString() + "@" + start + "-" + end);
        }
        return new CompressedString(this.data, this.startBit + start * 7, end - start);
    }

    public CompressedString(CharSequence s1, int bits) {
        if (bits > 8 || bits < 1) {
            throw new IllegalArgumentException("CompressedString must have 0<bits<8");
        }
        this.BITSPERCHAR = (byte)bits;
        CharSequence s = bits >= 8 ? s1 : this.normalize(s1);
        this.data = new byte[s.length() * this.BITSPERCHAR + 7 >> 3];
        int bytepos = 0;
        int bitpos = 0;
        for (int i = 0; i < s.length(); ++i) {
            int c = s.charAt(i) & (1 << this.BITSPERCHAR) - 1;
            int n = bytepos;
            this.data[n] = (byte)(this.data[n] | c << bitpos);
            if ((bitpos += this.BITSPERCHAR) <= 7 || bytepos >= this.data.length - 1) continue;
            this.data[++bytepos] = (byte)(c >> 8 - bitpos + this.BITSPERCHAR);
            bitpos -= 8;
        }
        this.length = s.length();
    }

    public CompressedString(CharSequence s1) {
        this(s1, 6);
    }

    @Override
    public String toString() {
        char[] result = new char[this.length];
        for (int i = 0; i < this.length; ++i) {
            result[i] = this.charAt(i);
        }
        return new String(result);
    }

    public static void main(String[] args) {
        System.out.println(new CompressedString("How_are you? 8", 8));
        System.out.println(new CompressedString("How_are you? 7", 7));
        System.out.println(new CompressedString("How_are you? 6", 6));
        System.out.println(new CompressedString("How_are you? 5", 5));
        System.out.println(new CompressedString("How_are you? 4", 4));
        System.out.println(new CompressedString("How_are you? 3", 3));
        TreeSet<CompressedString> set = new TreeSet<CompressedString>();
        set.add(new CompressedString("hello"));
        D.p(set.contains(new CompressedString("hello")));
        D.p(set.contains(new CompressedString("HELLO")));
        D.p(set.contains(new CompressedString("blub")));
        D.p(new CompressedString("aaaabbas").compareTo("aaaabbasa"));
    }
}

