/*
 * Decompiled with CFR 0.152.
 */
package javatools.datatypes;

import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javatools.administrative.D;
import javatools.datatypes.IntHashMap;
import javatools.datatypes.PeekIterator;

public class DoubleHashMap<K>
extends AbstractSet<K> {
    protected Object[] keys;
    protected double[] values;
    protected int size;

    public DoubleHashMap() {
        this.clear();
    }

    public DoubleHashMap(K ... keys) {
        this();
        for (K k : keys) {
            this.add(k);
        }
    }

    protected int index(Object key, int len) {
        return Math.abs(key.hashCode()) % len;
    }

    protected int index(Object key) {
        return this.index(key, this.keys.length);
    }

    public double get(K key) {
        return this.get(key, -1);
    }

    protected int find(Object key) {
        int i = this.index(key);
        while (this.keys[i] != null) {
            if (this.keys[i].equals(key)) {
                return i;
            }
            if (++i != this.keys.length) continue;
            i = 0;
        }
        return i;
    }

    public double get(K key, int defaultValue) {
        int pos = this.find(key);
        if (this.keys[pos] == null) {
            return defaultValue;
        }
        return this.values[pos];
    }

    public boolean containsKey(Object key) {
        return this.keys[this.find(key)] != null;
    }

    public boolean add(K key, double delta) {
        int pos = this.find(key);
        if (this.keys[pos] == null) {
            this.keys[pos] = key;
            this.values[pos] = delta;
            ++this.size;
            if (this.size > this.keys.length * 3 / 4) {
                this.rehash();
            }
            return true;
        }
        int n = pos;
        this.values[n] = this.values[n] + delta;
        return false;
    }

    public boolean increase(K key) {
        return this.add(key, 1.0);
    }

    public PeekIterator<K> keys() {
        final Object[] e = this.keys;
        return new PeekIterator<K>(){
            int pos = -1;

            @Override
            protected K internalNext() throws Exception {
                ++this.pos;
                while (this.pos < DoubleHashMap.this.keys.length) {
                    if (e[this.pos] != null) {
                        return e[this.pos];
                    }
                    ++this.pos;
                }
                return null;
            }
        };
    }

    public boolean put(K key, double value) {
        if (this.put(this.keys, this.values, key, value)) {
            ++this.size;
            if (this.size > this.keys.length * 3 / 4) {
                this.rehash();
            }
            return true;
        }
        return false;
    }

    protected boolean put(Object[] keys, double[] values, Object key, double value) {
        int i = this.index(key, keys.length);
        while (true) {
            if (keys[i] == null) {
                keys[i] = key;
                values[i] = value;
                return true;
            }
            if (keys[i].equals(key)) {
                values[i] = value;
                return false;
            }
            if (++i != keys.length) continue;
            i = 0;
        }
    }

    protected void rehash() {
        Object[] newKeys = new Object[this.keys.length * 2];
        double[] newValues = new double[this.keys.length * 2];
        for (int i = 0; i < this.keys.length; ++i) {
            if (this.keys[i] == null) continue;
            this.put(newKeys, newValues, this.keys[i], this.values[i]);
        }
        this.keys = newKeys;
        this.values = newValues;
    }

    public static void main(String[] args) throws Exception {
        DoubleHashMap<String> m = new DoubleHashMap<String>();
        for (double i = 1.0; i < 3000.0; i *= 2.0) {
            m.put("#" + i, i);
        }
        m.put("#0", 17.0);
        for (String key : m.keys()) {
            D.p(key, m.get(key));
        }
    }

    @Override
    public Iterator<K> iterator() {
        return this.keys().iterator();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean add(K e) {
        return this.increase(e);
    }

    @Override
    public void clear() {
        this.size = 0;
        this.keys = new Object[10];
        this.values = new double[10];
    }

    @Override
    public boolean contains(Object o) {
        return this.containsKey(o);
    }

    public void add(DoubleHashMap<K> countBindings) {
        for (K key : countBindings.keys()) {
            this.add(key, countBindings.get(key));
        }
    }

    public void add(Collection<K> set) {
        for (K k : set) {
            this.add(k);
        }
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder b = new StringBuilder("{");
        int counter = 20;
        for (K key : this.keys()) {
            if (counter-- == 0) {
                b.append("..., ");
                break;
            }
            b.append(key).append('=').append(this.get(key)).append(", ");
        }
        b.setLength(b.length() - 2);
        return b.append("}").toString();
    }

    public List<K> increasingKeys() {
        List<K> result = this.keys().asList();
        Collections.sort(result, new Comparator<K>(){

            @Override
            public int compare(K o1, K o2) {
                double i2;
                double i1 = DoubleHashMap.this.get(o1);
                return i1 < (i2 = DoubleHashMap.this.get(o2)) ? -1 : (i1 > i2 ? 1 : 0);
            }
        });
        return result;
    }

    public List<K> decreasingKeys() {
        List<K> result = this.keys().asList();
        Collections.sort(result, new Comparator<K>(){

            @Override
            public int compare(K o1, K o2) {
                double i2;
                double i1 = DoubleHashMap.this.get(o1);
                return i1 < (i2 = DoubleHashMap.this.get(o2)) ? 1 : (i1 > i2 ? -1 : 0);
            }
        });
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof IntHashMap)) {
            return false;
        }
        IntHashMap other = (IntHashMap)o;
        if (other.size() != this.size()) {
            return false;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (this.keys[i] == null || this.values[i] == (double)other.get(this.keys[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.values);
    }

    public double findMax() {
        double max = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < this.keys.length; ++i) {
            if (this.keys[i] == null || !(this.values[i] > max)) continue;
            max = this.values[i];
        }
        return max;
    }

    public double computeSum() {
        double sum = 0.0;
        for (int i = 0; i < this.keys.length; ++i) {
            if (this.keys[i] == null) continue;
            sum += this.values[i];
        }
        return sum;
    }
}

