/*
 * Decompiled with CFR 0.152.
 */
package javatools.datatypes;

import java.util.Iterator;
import javatools.datatypes.PeekIterator;

public class FilteredIterator<T>
extends PeekIterator<T> {
    protected Iterator<T> iterator;
    protected If<T> condition;

    public FilteredIterator(Iterator<T> i, If<T> condition) {
        this(i);
        this.condition = condition;
    }

    protected FilteredIterator(Iterator<T> i) {
        this.iterator = i;
    }

    @Override
    public T internalNext() {
        while (this.iterator.hasNext()) {
            T obj = this.iterator.next();
            if (!this.condition.condition(obj)) continue;
            return obj;
        }
        return null;
    }

    @Override
    public void remove() {
        this.iterator.remove();
    }

    public static class IgnoreErrors<T>
    extends FilteredIterator<T> {
        int numFail;

        public IgnoreErrors(Iterator<T> i, int numFailuresBeforeStop) {
            super(i);
            this.numFail = numFailuresBeforeStop;
        }

        @Override
        public T internalNext() {
            if (!this.iterator.hasNext()) {
                return null;
            }
            int counter = this.numFail;
            while (counter-- > 0) {
                try {
                    return (T)this.iterator.next();
                }
                catch (Exception exception) {
                }
            }
            return null;
        }
    }

    public static interface If<T> {
        public boolean condition(T var1);
    }
}

