/*
 * Decompiled with CFR 0.152.
 */
package javatools.datatypes;

import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javatools.administrative.D;
import javatools.datatypes.PeekIterator;

public class IntHashMap<K>
extends AbstractSet<K> {
    protected Object[] keys;
    protected int[] values;
    protected int size;
    protected Object DEL = new Object();

    public IntHashMap() {
        this.clear();
    }

    public IntHashMap(K ... keys) {
        this();
        for (K k : keys) {
            this.add(k);
        }
    }

    public IntHashMap<K> putAll(Object ... keyValuePairs) {
        for (int i = 0; i < keyValuePairs.length; i += 2) {
            Object value = keyValuePairs[i + 1];
            if (value instanceof Integer) {
                this.put(keyValuePairs[i], (Integer)value);
                continue;
            }
            if (value instanceof Character) {
                this.put(keyValuePairs[i], ((Character)value).charValue());
                continue;
            }
            if (value instanceof Byte) {
                this.put(keyValuePairs[i], ((Byte)value).intValue());
                continue;
            }
            if (value instanceof Short) {
                this.put(keyValuePairs[i], ((Short)value).intValue());
                continue;
            }
            throw new RuntimeException("Values have to be integers");
        }
        return this;
    }

    public IntHashMap(Collection<K> keys) {
        this();
        for (K k : keys) {
            this.add(k);
        }
    }

    public IntHashMap(Map<K, IntHashMap<K>> map) {
        this();
        for (Map.Entry<K, IntHashMap<K>> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue().size());
        }
    }

    protected int index(Object key, int len) {
        return Math.abs(key.hashCode()) % len;
    }

    protected int index(Object key) {
        return this.index(key, this.keys.length);
    }

    public int get(Object key) {
        return this.get(key, -1);
    }

    protected int find(Object key) {
        int i = this.index(key);
        while (this.keys[i] != null) {
            if (this.keys[i].equals(key)) {
                return i;
            }
            if (++i != this.keys.length) continue;
            i = 0;
        }
        return i;
    }

    public int get(Object key, int defaultValue) {
        int pos = this.find(key);
        if (this.keys[pos] == null) {
            return defaultValue;
        }
        return this.values[pos];
    }

    public boolean containsKey(Object key) {
        return this.keys[this.find(key)] != null;
    }

    public boolean add(K key, int delta) {
        int pos = this.find(key);
        if (this.keys[pos] == null) {
            this.keys[pos] = key;
            this.values[pos] = delta;
            ++this.size;
            if (this.size > this.keys.length * 3 / 4) {
                this.rehash();
            }
            return true;
        }
        int n = pos;
        this.values[n] = this.values[n] + delta;
        return false;
    }

    public boolean increase(K key) {
        return this.add(key, 1);
    }

    public PeekIterator<K> keys() {
        final Object[] e = this.keys;
        return new PeekIterator<K>(){
            int pos = -1;

            @Override
            protected K internalNext() throws Exception {
                ++this.pos;
                while (this.pos < IntHashMap.this.keys.length) {
                    if (e[this.pos] != null && e[this.pos] != IntHashMap.this.DEL) {
                        return e[this.pos];
                    }
                    ++this.pos;
                }
                return null;
            }
        };
    }

    public boolean put(K key, int value) {
        if (this.put(this.keys, this.values, key, value)) {
            ++this.size;
            if (this.size > this.keys.length * 3 / 4) {
                this.rehash();
            }
            return true;
        }
        return false;
    }

    protected boolean put(Object[] keys, int[] values, Object key, int value) {
        int i = this.index(key, keys.length);
        while (true) {
            if (keys[i] == null || keys[i] == this.DEL) {
                keys[i] = key;
                values[i] = value;
                return true;
            }
            if (keys[i].equals(key)) {
                values[i] = value;
                return false;
            }
            if (++i != keys.length) continue;
            i = 0;
        }
    }

    @Override
    public boolean remove(Object arg0) {
        int pos = this.find(arg0);
        if (this.keys[pos] == null) {
            return false;
        }
        this.keys[pos] = this.DEL;
        this.values[pos] = 0;
        --this.size;
        this.rehash();
        return true;
    }

    protected void rehash() {
        Object[] newKeys = new Object[this.keys.length * 2];
        int[] newValues = new int[this.keys.length * 2];
        for (int i = 0; i < this.keys.length; ++i) {
            if (this.keys[i] == null || this.keys[i] == this.DEL) continue;
            this.put(newKeys, newValues, this.keys[i], this.values[i]);
        }
        this.keys = newKeys;
        this.values = newValues;
    }

    @Override
    public Iterator<K> iterator() {
        return this.keys().iterator();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean add(K e) {
        return this.increase(e);
    }

    @Override
    public void clear() {
        this.size = 0;
        this.keys = new Object[10];
        this.values = new int[10];
    }

    @Override
    public boolean contains(Object o) {
        return this.containsKey(o);
    }

    public void add(IntHashMap<K> countBindings) {
        for (K key : countBindings.keys()) {
            this.add(key, countBindings.get(key));
        }
    }

    public void addAll(IntHashMap<K> countBindings) {
        this.add(countBindings);
    }

    public void add(Collection<K> set) {
        for (K k : set) {
            this.add(k);
        }
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder b = new StringBuilder("{");
        int counter = 30;
        for (K key : this.keys()) {
            if (counter-- == 0) {
                b.append("..., ");
                break;
            }
            b.append(key).append('=').append(this.get(key)).append(", ");
        }
        b.setLength(b.length() - 2);
        return b.append("}").toString();
    }

    public List<K> increasingKeys() {
        List<K> result = this.keys().asList();
        Collections.sort(result, new Comparator<K>(){

            @Override
            public int compare(K o1, K o2) {
                int i2;
                int i1 = IntHashMap.this.get(o1);
                return i1 < (i2 = IntHashMap.this.get(o2)) ? -1 : (i1 > i2 ? 1 : 0);
            }
        });
        return result;
    }

    public List<K> decreasingKeys() {
        List<K> result = this.keys().asList();
        Collections.sort(result, new Comparator<K>(){

            @Override
            public int compare(K o1, K o2) {
                int i2;
                int i1 = IntHashMap.this.get(o1);
                return i1 < (i2 = IntHashMap.this.get(o2)) ? 1 : (i1 > i2 ? -1 : 0);
            }
        });
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof IntHashMap)) {
            return false;
        }
        IntHashMap other = (IntHashMap)o;
        if (other.size() != this.size()) {
            return false;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (this.keys[i] == null || this.values[i] == other.get(this.keys[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.values);
    }

    public int findMax() {
        int max = Integer.MIN_VALUE;
        for (int i = 0; i < this.keys.length; ++i) {
            if (this.keys[i] == null || this.values[i] <= max) continue;
            max = this.values[i];
        }
        return max;
    }

    public long computeSum() {
        long sum = 0L;
        for (int i = 0; i < this.keys.length; ++i) {
            if (this.keys[i] == null) continue;
            sum += (long)this.values[i];
        }
        return sum;
    }

    public static void main(String[] args) throws Exception {
        IntHashMap<String> m = new IntHashMap<String>();
        for (int i = 1; i < 3000; i *= 2) {
            m.put("#" + i, i);
        }
        m.put("#0", 17);
        m.remove("#300000");
        m.remove("#32");
        for (String key : m.keys()) {
            D.p(key, m.get(key));
        }
    }
}

