/*
 * Decompiled with CFR 0.152.
 */
package javatools.datatypes;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javatools.administrative.D;
import javatools.datatypes.PeekIterator;

public class IntKeyMap<K> {
    protected int[] keys;
    protected K[] values;
    protected int size;

    public IntKeyMap() {
        this.clear();
    }

    public IntKeyMap(Object ... keyValuePairs) {
        this(Arrays.asList(keyValuePairs));
    }

    public IntKeyMap(List<Object> keyValuePairs) {
        this();
        for (int i = 0; i < keyValuePairs.size(); i += 2) {
            Object key = keyValuePairs.get(i);
            if (key instanceof Integer) {
                this.put((Integer)key, keyValuePairs.get(i + 1));
                continue;
            }
            if (key instanceof Character) {
                this.put(((Character)key).charValue(), keyValuePairs.get(i + 1));
                continue;
            }
            if (key instanceof Byte) {
                this.put(((Byte)key).intValue(), keyValuePairs.get(i + 1));
                continue;
            }
            if (key instanceof Short) {
                this.put(((Short)key).intValue(), keyValuePairs.get(i + 1));
                continue;
            }
            throw new RuntimeException("Keys have to be integers");
        }
    }

    protected int index(int key, int len) {
        return Math.abs(key) % len;
    }

    protected int index(int key) {
        return this.index(key, this.keys.length);
    }

    public K get(int key) {
        return this.get(key, null);
    }

    protected int find(int key) {
        int i = this.index(key);
        while (this.keys[i] != Integer.MAX_VALUE) {
            if (this.keys[i] == key) {
                return i;
            }
            if (++i != this.keys.length) continue;
            i = 0;
        }
        return i;
    }

    public K get(int key, K defaultValue) {
        int pos = this.find(key);
        if (this.keys[pos] == Integer.MAX_VALUE) {
            return defaultValue;
        }
        return this.values[pos];
    }

    public boolean containsKey(int key) {
        return this.keys[this.find(key)] != Integer.MAX_VALUE;
    }

    public PeekIterator<Integer> keys() {
        final int[] e = this.keys;
        return new PeekIterator<Integer>(){
            int pos = -1;

            @Override
            protected Integer internalNext() throws Exception {
                ++this.pos;
                while (this.pos < IntKeyMap.this.keys.length) {
                    if (e[this.pos] != Integer.MAX_VALUE) {
                        return e[this.pos];
                    }
                    ++this.pos;
                }
                return null;
            }
        };
    }

    public boolean put(int key, K value) {
        if (key == Integer.MAX_VALUE) {
            throw new RuntimeException("Integer.MAX_VALUE cannot be stored as key. Sorry...");
        }
        if (this.put(this.keys, this.values, key, value)) {
            ++this.size;
            if (this.size > this.keys.length * 3 / 4) {
                this.rehash();
            }
            return true;
        }
        return false;
    }

    protected boolean put(int[] keys, K[] values, int key, K value) {
        int i = this.index(key, keys.length);
        while (true) {
            if (keys[i] == Integer.MAX_VALUE) {
                keys[i] = key;
                values[i] = value;
                return true;
            }
            if (keys[i] == key) {
                values[i] = value;
                return false;
            }
            if (++i != keys.length) continue;
            i = 0;
        }
    }

    protected void rehash() {
        int[] newKeys = new int[this.keys.length * 2];
        Arrays.fill(newKeys, Integer.MAX_VALUE);
        Object[] newValues = new Object[this.keys.length * 2];
        for (int i = 0; i < this.keys.length; ++i) {
            if (this.keys[i] == Integer.MAX_VALUE) continue;
            this.put(newKeys, newValues, this.keys[i], this.values[i]);
        }
        this.keys = newKeys;
        this.values = newValues;
    }

    public Iterator<Integer> iterator() {
        return this.keys().iterator();
    }

    public int size() {
        return this.size;
    }

    public void clear() {
        this.size = 0;
        this.keys = new int[10];
        Arrays.fill(this.keys, Integer.MAX_VALUE);
        this.values = new Object[10];
    }

    public boolean contains(int o) {
        return this.containsKey(o);
    }

    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder b = new StringBuilder("{");
        int counter = 30;
        for (int key : this.keys()) {
            if (counter-- == 0) {
                b.append("..., ");
                break;
            }
            b.append(key).append('=').append(this.get(key)).append(", ");
        }
        b.setLength(b.length() - 2);
        return b.append("}").toString();
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean equals(Object o) {
        if (!(o instanceof IntKeyMap)) {
            return false;
        }
        IntKeyMap other = (IntKeyMap)o;
        if (other.size() != this.size()) {
            return false;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (this.keys[i] != Integer.MAX_VALUE || this.values[i] == other.get(this.keys[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return Arrays.hashCode(this.values);
    }

    public static void main(String[] args) throws Exception {
        IntKeyMap<String> m = new IntKeyMap<String>();
        for (int i = 1; i < 3000; i *= 2) {
            m.put(i, "#" + i);
            D.p("Added", i, m.size());
        }
        D.p(m.keys);
        m.put(8, "#0");
        for (int key : m.keys()) {
            D.p(key, m.get(key));
        }
    }
}

