/*
 * Decompiled with CFR 0.152.
 */
package javatools.datatypes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javatools.datatypes.PeekIterator;
import javatools.datatypes.SmallStack;

public class PQRTree<E>
implements Iterable<E> {
    protected Map<E, Leaf> leafMap = new HashMap<E, Leaf>();
    protected boolean hasRNode = false;
    protected Node root = new Node(NodeType.P);
    protected int currentConstraintSetId = 0;

    public boolean isSolveable() {
        return !this.hasRNode;
    }

    public PQRTree(Collection<E> elements) {
        this.root.allocChildren(elements.size());
        for (E e : elements) {
            this.root.addChild(new Leaf(e));
        }
    }

    public PQRTree(E ... elements) {
        this(Arrays.asList(elements));
    }

    public boolean addConstraint(E ... elements) {
        return this.addConstraint(Arrays.asList(elements));
    }

    public boolean addConstraint(Collection<E> elements) {
        int[] greyChildPosp;
        if (elements.size() == 0) {
            return true;
        }
        ++this.currentConstraintSetId;
        Node lca = null;
        for (E element : elements) {
            lca = this.leafMap.get(element).colorAndGetLCA(elements.size());
        }
        lca.debug(elements);
        while ((greyChildPosp = new int[]{lca.grayChild()})[0] != -1) {
            Node greyChild = lca.child(greyChildPosp[0]);
            if (greyChild.isP()) {
                greyChild.transformPintoQ();
            }
            if (lca.isP()) {
                lca.prepareLCA(greyChildPosp);
                greyChild = lca.child(greyChildPosp[0]);
                if (greyChild.isQ()) {
                    greyChild.reverseQNode();
                }
                lca = lca.moveChildrenAway(greyChildPosp[0]);
                continue;
            }
            if (lca.isQ()) {
                lca.reverseLCA(greyChildPosp);
                greyChild = lca.child(greyChildPosp[0]);
                if (greyChild.isQ()) {
                    greyChild.reverseQNode();
                }
                lca.mergeIntoLCA(greyChildPosp[0]);
                continue;
            }
            lca.mergeIntoLCA(greyChildPosp[0]);
        }
        if (lca.isP()) {
            boolean hasWhiteChild = false;
            int numBlackChildren = 0;
            for (Node child : lca.children) {
                if (child.isWhite()) {
                    hasWhiteChild = true;
                }
                if (child.isBlack()) {
                    ++numBlackChildren;
                }
                if (!hasWhiteChild || numBlackChildren <= 1) continue;
                break;
            }
            if (hasWhiteChild && numBlackChildren > 1) {
                Node father = new Node(NodeType.P);
                lca.addChild(father);
                for (int i = 0; i < lca.numChildren() - 1; ++i) {
                    if (!lca.child(i).isBlack()) continue;
                    lca.makeChildGrandchild(i--, father);
                }
            }
        }
        if (lca.isQ()) {
            int black = 0;
            for (Node child : lca.children) {
                if (child.isBlack()) {
                    if (black == 2) {
                        lca.type = NodeType.R;
                        break;
                    }
                    if (black != 0) continue;
                    black = 1;
                    continue;
                }
                if (black != 1) continue;
                black = 2;
            }
        }
        return !lca.isR();
    }

    @Override
    public PeekIterator<E> iterator() {
        return new PeekIterator<E>(){
            Node currentNode;
            SmallStack currentChildren;
            {
                this.currentNode = PQRTree.this.root;
                this.currentChildren = new SmallStack(-1L);
            }

            @Override
            public E internalNext() {
                while (this.currentChildren.size() != 0) {
                    int currentChild = this.currentChildren.popInt();
                    if (this.currentNode.children.size() <= ++currentChild) {
                        this.currentNode = this.currentNode.parent;
                        continue;
                    }
                    this.currentChildren.push(currentChild);
                    if (this.currentNode.child((int)currentChild).children.size() == 0) {
                        return ((Leaf)this.currentNode.child((int)currentChild)).value;
                    }
                    this.currentNode = this.currentNode.child(currentChild);
                    this.currentChildren.push(-1L);
                }
                return null;
            }
        };
    }

    public String toString() {
        return this.root.toString();
    }

    public static void main(String[] args) throws Exception {
    }

    public class Leaf
    extends Node {
        protected E value;

        public Leaf(E e) {
            super(NodeType.Leaf);
            this.value = e;
            PQRTree.this.leafMap.put(this.value, this);
            this.numLeaves = 1;
        }

        @Override
        public void toString(StringBuilder s, int depth) {
            for (int i = 0; i < depth * 2; ++i) {
                s.append(' ');
            }
            s.append(this.value).append(": ").append((Object)this.color()).append('\n');
        }

        public E getValue() {
            return this.value;
        }
    }

    public class Node {
        protected List<Node> children = new ArrayList<Node>();
        protected Node parent;
        protected NodeType type;
        protected int numLeaves = 0;
        protected int numBlackLeaves = 0;
        protected int constraintSetId;

        public Node(NodeType t) {
            this.type = t;
        }

        public void dropChild(int pos) {
            Node child = this.child(pos);
            child.parent = null;
            this.addLeaves(-child.numLeaves);
            this.addBlackLeaves(-child.numBlackLeaves);
            this.children.remove(pos);
        }

        public void makeChildGrandchild(int pos, Node father, int newPos) {
            Node child = this.child(pos);
            father.children.add(newPos, child);
            child.parent = father;
            father.numLeaves += child.numLeaves;
            if (child.constraintSetId == PQRTree.this.currentConstraintSetId) {
                if (father.constraintSetId == PQRTree.this.currentConstraintSetId) {
                    father.numBlackLeaves += child.numBlackLeaves;
                } else {
                    father.numBlackLeaves = child.numBlackLeaves;
                    father.constraintSetId = PQRTree.this.currentConstraintSetId;
                }
            }
            this.children.remove(pos);
        }

        public void makeChildGrandchild(int pos, Node father) {
            this.makeChildGrandchild(pos, father, father.numChildren());
        }

        public void makeGrandchildChild(Node father, int oldPos, int newPos) {
            Node child = father.child(oldPos);
            father.numLeaves -= child.numLeaves;
            if (father.constraintSetId == PQRTree.this.currentConstraintSetId && child.constraintSetId == PQRTree.this.currentConstraintSetId) {
                father.numBlackLeaves -= child.numBlackLeaves;
            }
            father.children.remove(oldPos);
            child.parent = this;
            this.children.add(newPos, child);
        }

        public void addChild(Node n) {
            this.addChild(n, this.numChildren());
        }

        public void addChild(Node n, int pos) {
            this.children.add(pos, n);
            n.parent = this;
            this.addLeaves(n.numLeaves);
        }

        protected void addLeaves(int num) {
            if (num == 0) {
                return;
            }
            this.numLeaves += num;
            if (this.parent != null) {
                this.parent.addLeaves(num);
            }
        }

        public void addBlackLeaves(int num) {
            if (num == 0 || this.constraintSetId != PQRTree.this.currentConstraintSetId) {
                return;
            }
            this.numBlackLeaves += num;
            if (this.parent != null) {
                this.parent.addBlackLeaves(num);
            }
        }

        public void allocChildren(int n) {
            this.children = new ArrayList<Node>(n);
        }

        public Node colorAndGetLCA(int numS) {
            if (this.constraintSetId != PQRTree.this.currentConstraintSetId) {
                this.constraintSetId = PQRTree.this.currentConstraintSetId;
                this.numBlackLeaves = 1;
            } else {
                ++this.numBlackLeaves;
            }
            if (this.parent == null || numS == this.numBlackLeaves) {
                return this;
            }
            return this.parent.colorAndGetLCA(numS);
        }

        public Color color() {
            if (this.constraintSetId != PQRTree.this.currentConstraintSetId) {
                return Color.WHITE;
            }
            if (this.numLeaves == this.numBlackLeaves) {
                return Color.BLACK;
            }
            return Color.GRAY;
        }

        public boolean is(NodeType t) {
            return this.type == t;
        }

        public boolean isP() {
            return this.type == NodeType.P;
        }

        public boolean isQ() {
            return this.type == NodeType.Q;
        }

        public boolean isR() {
            return this.type == NodeType.R;
        }

        public boolean isLeaf() {
            return this.type == NodeType.Leaf;
        }

        public boolean is(Color t) {
            return this.color() == t;
        }

        public boolean isWhite() {
            return this.constraintSetId != PQRTree.this.currentConstraintSetId;
        }

        public boolean isBlack() {
            return this.numLeaves == this.numBlackLeaves;
        }

        public boolean isGray() {
            return this.constraintSetId == PQRTree.this.currentConstraintSetId && this.numLeaves != this.numBlackLeaves;
        }

        public int numChildren() {
            return this.children.size();
        }

        public Node lastChild() {
            return this.child(this.numChildren() - 1);
        }

        public Node firstChild() {
            return this.child(0);
        }

        public Node child(int pos) {
            return this.children.get(pos);
        }

        public int grayChild() {
            for (int i = 0; i < this.numChildren(); ++i) {
                if (!this.child(i).isGray()) continue;
                return i;
            }
            return -1;
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            this.toString(result, 0);
            return result.toString();
        }

        protected void toString(StringBuilder s, int depth) {
            for (int i = 0; i < depth * 2; ++i) {
                s.append(' ');
            }
            s.append((Object)this.type).append(": ").append((Object)this.color()).append('\n');
            for (Node child : this.children) {
                child.toString(s, depth + 1);
            }
        }

        public void debug(Object ... args) {
        }

        public void transformPintoQ() {
            this.debug(new Object[0]);
            this.type = NodeType.Q;
            Node blackFather = new Node(NodeType.P);
            this.addChild(blackFather, 0);
            Node whiteFather = new Node(NodeType.P);
            this.addChild(whiteFather, this.numChildren());
            block4: for (int i = 1; i < this.numChildren() - 1; ++i) {
                Node child = this.child(i);
                switch (child.color()) {
                    case BLACK: {
                        this.makeChildGrandchild(i--, blackFather);
                        continue block4;
                    }
                    case WHITE: {
                        this.makeChildGrandchild(i--, whiteFather);
                    }
                }
            }
            if (blackFather.numChildren() == 0) {
                this.dropChild(0);
            } else if (blackFather.numChildren() == 1) {
                this.makeGrandchildChild(blackFather, 0, 1);
                this.dropChild(0);
            }
            if (whiteFather.numChildren() == 0) {
                this.dropChild(this.numChildren() - 1);
            } else if (whiteFather.numChildren() == 1) {
                this.makeGrandchildChild(whiteFather, 0, this.numChildren() - 1);
                this.dropChild(this.numChildren() - 1);
            }
        }

        public void prepareLCA(int[] childPos) {
            int numBlack = 0;
            for (Node child : this.children) {
                if (child.isBlack()) {
                    ++numBlack;
                }
                if (numBlack <= 1) continue;
                break;
            }
            if (numBlack < 2) {
                return;
            }
            this.debug(new Object[0]);
            Node blackFather = new Node(NodeType.P);
            this.addChild(blackFather);
            for (int i = 0; i < this.numChildren() - 1; ++i) {
                if (!this.child(i).isBlack()) continue;
                if (i < childPos[0]) {
                    childPos[0] = childPos[0] - 1;
                }
                this.makeChildGrandchild(i--, blackFather);
            }
        }

        public void mergeIntoLCA(int childPos) {
            Node father = this.child(childPos);
            this.debug(new Object[0]);
            for (int j = father.numChildren() - 1; j >= 0; --j) {
                this.makeGrandchildChild(father, j, childPos + 1);
            }
            this.dropChild(childPos);
        }

        public void reverseQNode() {
            if (this.firstChild().color().ordinal() < this.lastChild().color().ordinal()) {
                this.debug(new Object[0]);
                Collections.reverse(this.children);
            }
        }

        public void reverseLCA(int[] childPos) {
            if (this.numChildren() == 1) {
                return;
            }
            this.debug(new Object[0]);
            if (childPos[0] == 0) {
                if (!this.child(1).isWhite()) {
                    Collections.reverse(this.children);
                    childPos[0] = this.numChildren() - 1;
                }
                return;
            }
            if (childPos[0] == this.numChildren() - 1) {
                if (this.child(this.numChildren() - 2).isWhite()) {
                    Collections.reverse(this.children);
                    childPos[0] = 0;
                }
                return;
            }
            if (this.child(childPos[0] - 1).color().ordinal() < this.child(childPos[0] + 1).color().ordinal()) {
                Collections.reverse(this.children);
                childPos[0] = this.numChildren() - 1 - childPos[0];
            }
        }

        public Node moveChildrenAway(int childPos) {
            this.debug(new Object[0]);
            Node grayChild = this.child(childPos);
            int blackPos = 0;
            block4: for (int i = 0; i < this.numChildren(); ++i) {
                Node child = this.child(i);
                if (child == grayChild) continue;
                switch (child.color()) {
                    case BLACK: {
                        this.makeChildGrandchild(i--, grayChild, blackPos);
                        continue block4;
                    }
                    case GRAY: {
                        this.makeChildGrandchild(i--, grayChild, blackPos++);
                    }
                }
            }
            if (this.numChildren() == 1) {
                this.children = grayChild.children;
                this.numLeaves = grayChild.numLeaves;
                this.numBlackLeaves = grayChild.numBlackLeaves;
                this.type = grayChild.type;
                grayChild.parent = null;
                return this;
            }
            return grayChild;
        }
    }

    public static enum NodeType {
        P,
        Q,
        R,
        Leaf;

    }

    public static enum Color {
        WHITE,
        GRAY,
        BLACK;

    }
}

