/*
 * Decompiled with CFR 0.152.
 */
package javatools.datatypes;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javatools.database.Database;

public abstract class StringModifier {
    public static String implode(String[] array, String delim) {
        if (array.length == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        sb.append(array[0]);
        for (int i = 1; i < array.length; ++i) {
            sb.append(delim);
            sb.append(array[i]);
        }
        return sb.toString();
    }

    public static String implode(Collection<?> col, String delim) {
        if (col == null) {
            return "";
        }
        Iterator<?> it = col.iterator();
        if (!it.hasNext()) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        sb.append(it.next());
        while (it.hasNext()) {
            sb.append(delim);
            sb.append(it.next().toString());
        }
        return sb.toString();
    }

    public static String implodeForDB(Collection<?> col, String delim, Database database) {
        return StringModifier.implodeForDB(col.iterator(), delim, database);
    }

    public static String implodeForDB(Iterator<?> it, String delim, Database database) {
        if (it == null) {
            return "";
        }
        if (!it.hasNext()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(database.format(it.next()));
        while (it.hasNext()) {
            sb.append(delim);
            sb.append(database.format(it.next()));
        }
        return sb.toString();
    }

    public static <T> String implodeForDB(T[] col, String delim, Database database) {
        if (col.length <= 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(database.format(col[0]));
        for (int i = 1; i < col.length; ++i) {
            sb.append(delim);
            sb.append(database.format(col[i]));
        }
        return sb.toString();
    }

    public static String implodeForDBAsConditions(Map<?, ?> map, Database database) {
        if (map == null) {
            return "";
        }
        if (map.isEmpty()) {
            return "";
        }
        return StringModifier.implodeForDB(map.entrySet().iterator(), " = ", " AND ", database, false, true);
    }

    public static String implodeForDB(Map<?, ?> map, String keyValueDelim, String pairDelim, Database database, boolean formatKey, boolean formatValue) {
        if (map == null) {
            return "";
        }
        if (map.isEmpty()) {
            return "";
        }
        return StringModifier.implodeForDB(map.entrySet().iterator(), keyValueDelim, pairDelim, database, formatKey, formatValue);
    }

    public static <T, K> String implodeForDB(Iterator<Map.Entry<T, K>> it, String keyValueDelim, String pairDelim, Database database, boolean formatKey, boolean formatValue) {
        if (it == null) {
            return "";
        }
        if (!it.hasNext()) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        Map.Entry<T, K> entry = it.next();
        sb.append((Object)(formatKey ? database.format(entry.getKey()) : entry.getKey()));
        sb.append(keyValueDelim);
        sb.append((Object)(formatValue ? database.format(entry.getValue()) : entry.getValue()));
        while (it.hasNext()) {
            sb.append(pairDelim);
            entry = it.next();
            sb.append((Object)(formatKey ? database.format(entry.getKey()) : entry.getKey()));
            sb.append(keyValueDelim);
            sb.append((Object)(formatValue ? database.format(entry.getValue()) : entry.getValue()));
        }
        return sb.toString();
    }

    public static String limitLength(String s, int length) {
        if (s.length() > length) {
            return s.substring(0, length);
        }
        return s;
    }

    public static Set<String> toNGram(String original, int n) {
        HashSet<String> ngrams = new HashSet<String>();
        for (int i = 0; i < original.length(); ++i) {
            ngrams.add(original.substring(i, i + n));
        }
        return ngrams;
    }

    public static Map<String, Double> toWeighedNGram(String original, int n) {
        HashMap<String, Double> ngrams = new HashMap<String, Double>();
        for (int i = 0; i < original.length(); ++i) {
            String ngram;
            Double oldVal = (Double)ngrams.get(ngram = original.substring(i, Math.min(i + n, original.length() - 1)));
            ngrams.put(ngram, oldVal != null ? oldVal + 1.0 / (double)original.length() : 1.0 / (double)original.length());
        }
        return ngrams;
    }

    public static final Set<String> lowercase(String ... ar) {
        HashSet<String> s = new HashSet<String>(ar.length);
        for (String a : ar) {
            s.add(a.toLowerCase());
        }
        return s;
    }

    public static final boolean areEqual(String s1, String s2) {
        if (s1 == null) {
            return s2 == null;
        }
        return s1.equals(s2);
    }

    public static void main(String[] argv) throws Exception {
        String[] array = new String[]{"cat", "mouse", "cheese"};
        String imploded = StringModifier.implode(array, " eats ");
        System.out.println(imploded);
        imploded = StringModifier.implode(array, ",");
        System.out.println(imploded);
    }
}

