/*
 * Decompiled with CFR 0.152.
 */
package javatools.datatypes;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;
import javatools.administrative.D;
import javatools.datatypes.IterableForIterator;
import javatools.datatypes.MappedIterator;
import javatools.datatypes.PeekIterator;

public class Trie
extends AbstractSet<CharSequence> {
    protected TreeMap<Character, Trie> children = new TreeMap();
    protected boolean isWord = false;
    protected int size = 0;
    protected Trie parent;

    public Trie() {
    }

    protected Trie(Trie p) {
        this.parent = p;
    }

    public Trie(Collection<String> keySet) {
        for (String s : keySet) {
            this.add(s);
        }
    }

    @Override
    public boolean add(CharSequence s) {
        boolean a = this.add(s, 0);
        if (a) {
            ++this.size;
        }
        return a;
    }

    @Override
    public void clear() {
        this.children.clear();
        this.isWord = false;
        this.size = 0;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    protected boolean add(CharSequence s, int start) {
        if (s.length() == start) {
            if (this.isWord) {
                return false;
            }
            this.isWord = true;
            return true;
        }
        Character c = Character.valueOf(s.charAt(start));
        if (this.children.get(c) == null) {
            this.children.put(c, new Trie(this));
        }
        return this.children.get(c).add(s, start + 1);
    }

    @Override
    public boolean contains(Object s) {
        return s instanceof CharSequence && this.containsCS((CharSequence)s, 0);
    }

    protected boolean containsCS(CharSequence cs, int start) {
        if (cs.length() == start) {
            return this.isWord;
        }
        Character c = Character.valueOf(cs.charAt(start));
        if (this.children.get(c) == null) {
            return false;
        }
        return this.children.get(c).containsCS(cs, start + 1);
    }

    @Override
    public PeekIterator<CharSequence> iterator() {
        if (this.isEmpty()) {
            return PeekIterator.emptyIterator();
        }
        return new PeekIterator<CharSequence>(){
            StringBuilder currentString = new StringBuilder();
            Trie currentTrie = Trie.this;

            @Override
            protected CharSequence internalNext() throws Exception {
                do {
                    SortedMap<Character, Trie> chars = this.currentTrie.children;
                    while (chars.isEmpty()) {
                        if (this.currentTrie.parent == null) {
                            return null;
                        }
                        this.currentTrie = this.currentTrie.parent;
                        chars = this.currentTrie.children.headMap(Character.valueOf(this.currentString.charAt(this.currentString.length() - 1)));
                        this.currentString.setLength(this.currentString.length() - 1);
                    }
                    Character c = (Character)chars.lastKey();
                    this.currentString.append(c.charValue());
                    this.currentTrie = this.currentTrie.children.get(c);
                } while (!this.currentTrie.isWord);
                return this.currentString.toString();
            }
        };
    }

    @Override
    public String toString() {
        return "Trie with " + this.size() + " elements and " + this.children.size() + " children";
    }

    @Override
    public int size() {
        return this.size;
    }

    public int containedLength(CharSequence s, int startPos) {
        int terminationValue;
        int n = terminationValue = this.isWord ? 0 : -1;
        if (s.length() <= startPos) {
            return terminationValue;
        }
        Character c = Character.valueOf(s.charAt(startPos));
        if (this.children.get(c) == null) {
            return terminationValue;
        }
        int subtreelength = this.children.get(c).containedLength(s, startPos + 1);
        if (subtreelength == -1) {
            return terminationValue;
        }
        return subtreelength + 1;
    }

    public PeekIterator<CharSequence> wordsIn(final CharSequence text) {
        return new PeekIterator<CharSequence>(){
            int pos = -1;

            @Override
            public CharSequence internalNext() {
                while (++this.pos < text.length()) {
                    int subtreeLength = Trie.this.containedLength(text, this.pos);
                    if (subtreeLength == -1) continue;
                    return text.subSequence(this.pos, subtreeLength + this.pos);
                }
                return null;
            }
        };
    }

    public static void main(String[] args) {
        Trie t = new Trie();
        t.add("hallo");
        t.add("du");
        t.add("duplizieren");
        for (String s : new IterableForIterator<String>(t.stringIterator())) {
            D.p(s);
        }
        D.p(t.wordsIn("Blah hallo blub hallo fasel du duplizieren").asList());
    }

    public Iterator<String> stringIterator() {
        return new MappedIterator<Object, String>(this.iterator(), MappedIterator.stringMapper);
    }

    public Iterable<String> strings() {
        return new MappedIterator<Object, String>(this.iterator(), MappedIterator.stringMapper);
    }
}

