/*
 * Decompiled with CFR 0.152.
 */
package javatools.filehandlers;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javatools.administrative.Announce;
import javatools.administrative.D;
import javatools.filehandlers.FileLines;

public class ByteFileLines
extends FileLines {
    public InputStream in;

    public ByteFileLines(String f) throws IOException {
        this(f, null);
    }

    public ByteFileLines(File f) throws IOException {
        this(f, null);
    }

    public ByteFileLines(String f, String announceMsg) throws IOException {
        this(new File(f), announceMsg);
    }

    public ByteFileLines(File f, String announceMsg) throws IOException {
        if (announceMsg != null) {
            Announce.progressStart(announceMsg, f.length());
            this.announceChars = 0L;
        }
        this.in = new BufferedInputStream(new FileInputStream(f));
    }

    public ByteFileLines(InputStream i) {
        this(new BufferedInputStream(i));
    }

    public ByteFileLines(BufferedInputStream i) {
        this.in = i;
    }

    @Override
    public String internalNext() {
        StringBuffer next = new StringBuffer(100);
        try {
            int c;
            do {
                if ((c = this.in.read()) != -1) continue;
                this.close();
                if (this.announceChars != -1L) {
                    Announce.progressDone();
                }
                return null;
            } while (c == 10 || c == 13);
            do {
                next.append((char)c);
            } while ((c = this.in.read()) != 10 && c != 13 && c != -1);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (this.announceChars != -1L) {
            Announce.progressAt(this.announceChars += (long)next.length());
        }
        return next.toString();
    }

    @Override
    public void close() {
        try {
            this.in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void main(String[] args) throws Exception {
        for (String l : new ByteFileLines("c:\\fabian\\service\\autoexec.bat")) {
            D.p(l);
        }
    }
}

