/*
 * Decompiled with CFR 0.152.
 */
package javatools.filehandlers;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Pattern;
import javatools.administrative.Announce;
import javatools.filehandlers.MatchReader;

public class ByteMatchReader
extends MatchReader {
    protected InputStream input;

    public ByteMatchReader(InputStream i, Pattern p) {
        this.input = i;
        this.pattern = p;
        this.next();
    }

    public ByteMatchReader(InputStream i, String p) {
        this(i, Pattern.compile(p));
    }

    public ByteMatchReader(File f, Pattern p, String announceMsg) throws FileNotFoundException {
        if (announceMsg != null) {
            Announce.progressStart(announceMsg, f.length());
            this.chars = 0L;
        }
        this.input = new BufferedInputStream(new FileInputStream(f));
        this.pattern = p;
        this.matcher = p.matcher(this.buffer);
    }

    public ByteMatchReader(String f, Pattern p, String announceMsg) throws FileNotFoundException {
        this(new File(f), p, announceMsg);
    }

    public ByteMatchReader(String f, String p, String announceMsg) throws FileNotFoundException {
        this(new File(f), Pattern.compile(p), announceMsg);
    }

    public ByteMatchReader(File f, String p, String announceMsg) throws FileNotFoundException {
        this(f, Pattern.compile(p), announceMsg);
    }

    public ByteMatchReader(File f, String p) throws FileNotFoundException {
        this(f, Pattern.compile(p), null);
    }

    public ByteMatchReader(String f, String p) throws FileNotFoundException {
        this(new File(f), Pattern.compile(p), null);
    }

    public ByteMatchReader(String f, Pattern p) throws FileNotFoundException {
        this(new File(f), p, null);
    }

    public ByteMatchReader(File f, Pattern p) throws FileNotFoundException {
        this(f, p, null);
    }

    @Override
    protected int read() throws IOException {
        return this.input.read();
    }

    @Override
    public void close() {
        try {
            this.input.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

