/*
 * Decompiled with CFR 0.152.
 */
package javatools.filehandlers;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import javatools.datatypes.PeekIterator;
import javatools.parsers.Char17;

public class CSVLines
extends PeekIterator<List<String>> {
    protected long announceChars = -1L;
    protected Reader in;
    protected List<String> columns = null;
    protected int nextChar;
    protected char separator = (char)44;

    public CSVLines(File f) throws IOException {
        this(new FileReader(f));
    }

    public CSVLines(Reader reader) throws IOException {
        this.in = reader;
        this.nextChar = this.in.read();
        if (this.nextChar == 47) {
            this.nextChar = this.in.read();
        }
        if (this.nextChar == 35 || this.nextChar == 37 || this.nextChar == 47) {
            this.nextChar = this.in.read();
            this.columns = (List)this.next();
        }
    }

    public CSVLines(String file) throws IOException {
        this(new File(file));
    }

    public void setSeparator(char s) {
        this.separator = s;
    }

    protected String component() throws IOException {
        StringBuilder component = new StringBuilder();
        while (Character.isWhitespace(this.nextChar)) {
            this.nextChar = this.in.read();
        }
        if (this.nextChar == 34) {
            this.nextChar = this.in.read();
            while (this.nextChar != -1) {
                if (this.nextChar == 34) {
                    this.nextChar = this.in.read();
                    if (this.nextChar != 34) break;
                }
                component.append((char)this.nextChar);
                this.nextChar = this.in.read();
            }
            while (this.nextChar != 10 && this.nextChar != 13 && this.nextChar != -1 && Character.isWhitespace(this.nextChar)) {
                this.nextChar = this.in.read();
            }
        } else {
            while (this.nextChar != -1 && this.nextChar != this.separator && this.nextChar != 10 && this.nextChar != 13) {
                component.append((char)this.nextChar);
                this.nextChar = this.in.read();
            }
            while (Character.isWhitespace(Char17.last(component))) {
                component.setLength(component.length() - 1);
            }
        }
        if (this.nextChar == this.separator) {
            this.nextChar = this.in.read();
        }
        return Char17.decode(component.toString());
    }

    @Override
    protected List<String> internalNext() throws Exception {
        if (this.nextChar == -1) {
            return null;
        }
        ArrayList<String> line = new ArrayList<String>(this.columns == null ? 10 : this.columns.size());
        while (this.nextChar != -1 && this.nextChar != 10 && this.nextChar != 13) {
            String c = this.component();
            line.add(c);
        }
        this.nextChar = this.in.read();
        if (this.nextChar == 13 || this.nextChar == 10) {
            this.nextChar = this.in.read();
        }
        return line;
    }

    public List<String> columnNames() {
        return this.columns;
    }

    public Integer numColumns() {
        return this.columns == null ? null : Integer.valueOf(this.columns.size());
    }

    @Override
    public void close() {
        try {
            this.in.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void main(String[] args) throws Exception {
        for (List cols : new CSVLines("./javatools/testdata/CSVTest.csv")) {
            System.out.println(cols);
        }
    }
}

