/*
 * Decompiled with CFR 0.152.
 */
package javatools.filehandlers;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import java.util.List;
import javatools.administrative.Announce;
import javatools.datatypes.PeekIterator;

public class FileLines
extends PeekIterator<String>
implements Iterable<String>,
Iterator<String>,
Closeable {
    protected long announceChars = -1L;
    protected BufferedReader br;
    public static long maxChars = -1L;

    public FileLines(String f) throws IOException {
        this(f, null);
    }

    public FileLines(File f) throws IOException {
        this(f, null);
    }

    public FileLines(String f, String announceMsg) throws IOException {
        this(new File(f), announceMsg);
    }

    public FileLines(String f, String encoding, String announceMsg) throws IOException {
        this(new File(f), encoding, announceMsg);
    }

    public FileLines(File f, String encoding, String announceMsg) throws IOException {
        if (announceMsg != null) {
            Announce.progressStart(announceMsg, f.length());
            this.announceChars = 0L;
        }
        this.br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), encoding));
    }

    public FileLines(File f, String announceMsg) throws IOException {
        if (announceMsg != null) {
            Announce.progressStart(announceMsg, f.length());
            this.announceChars = 0L;
        }
        this.br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), "UTF-8"));
    }

    public FileLines(Reader f) {
        this(new BufferedReader(f));
    }

    public FileLines(BufferedReader r) {
        this.br = r;
    }

    protected FileLines() {
    }

    @Override
    public void remove() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("FileLines does not support \"remove\"");
    }

    @Override
    public String internalNext() {
        String next;
        try {
            next = this.br.readLine();
            if (this.announceChars != -1L && next != null) {
                Announce.progressAt(this.announceChars += (long)next.length());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return next;
    }

    @Override
    public String toString() {
        return "FileLines of " + this.br;
    }

    @Override
    public Iterator<String> iterator() {
        return this;
    }

    @Override
    public void close() {
        try {
            this.br.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.announceChars != -1L) {
            Announce.progressDone();
        }
        this.announceChars = -1L;
    }

    public void finalize() {
        this.close();
    }

    public static String readTo(Reader in, CharSequence ... findMe) throws IOException {
        StringBuilder result = new StringBuilder();
        int[] pos = new int[findMe.length];
        while (maxChars < 0L || (long)result.length() < maxChars) {
            int c = in.read();
            if (c == -1) {
                return result.toString();
            }
            if (c == -2) continue;
            for (int i = 0; i < findMe.length; ++i) {
                if (c == findMe[i].charAt(pos[i])) {
                    int n = i;
                    pos[n] = pos[n] + 1;
                } else {
                    pos[i] = 0;
                }
                if (pos[i] != findMe[i].length()) continue;
                result.setLength(result.length() - findMe[i].length() + 1);
                return result.toString();
            }
            result.append((char)c);
        }
        return result.toString();
    }

    /*
     * Unable to fully structure code
     */
    public static int find(Reader in, String ... findMe) throws IOException {
        pos = new int[findMe.length];
        block0: while (true) {
            if ((c = in.read()) == -1) {
                return -1;
            }
            if (c == -2) continue;
            i = 0;
            while (true) {
                if (i < findMe.length) ** break;
                continue block0;
                if (c == findMe[i].charAt(pos[i])) {
                    v0 = i;
                    pos[v0] = pos[v0] + 1;
                } else {
                    pos[i] = 0;
                }
                if (pos[i] == findMe[i].length()) {
                    return i;
                }
                ++i;
            }
            break;
        }
    }

    /*
     * Unable to fully structure code
     */
    public static int find(Reader in, StringBuilder b, String ... findMe) throws IOException {
        pos = new int[findMe.length];
        block0: while (true) {
            c = in.read();
            b.append((char)c);
            if (c == -1) {
                return -1;
            }
            if (c == -2) continue;
            i = 0;
            while (true) {
                if (i < findMe.length) ** break;
                continue block0;
                if (c == findMe[i].charAt(pos[i])) {
                    v0 = i;
                    pos[v0] = pos[v0] + 1;
                } else {
                    pos[i] = 0;
                }
                if (pos[i] == findMe[i].length()) {
                    b.setLength(b.length() - findMe[i].length());
                    return i;
                }
                ++i;
            }
            break;
        }
    }

    /*
     * Unable to fully structure code
     */
    public static int findIgnoreCase(Reader in, String ... findMe) throws IOException {
        pos = new int[findMe.length];
        for (i = 0; i < findMe.length; ++i) {
            findMe[i] = findMe[i].toUpperCase();
        }
        block1: while (true) {
            if ((c = in.read()) == -1) {
                return -1;
            }
            if (c == -2) continue;
            c = Character.toUpperCase(c);
            i = 0;
            while (true) {
                if (i < findMe.length) ** break;
                continue block1;
                if (c == findMe[i].charAt(pos[i])) {
                    v0 = i;
                    pos[v0] = pos[v0] + 1;
                } else {
                    pos[i] = 0;
                }
                if (pos[i] == findMe[i].length()) {
                    return i;
                }
                ++i;
            }
            break;
        }
    }

    public static CharSequence readTo(Reader in, char ... limit) throws IOException {
        int c;
        StringBuilder result = new StringBuilder();
        block0: while ((c = in.read()) != -1) {
            for (int i = 0; i < limit.length; ++i) {
                if (c == limit[i]) break block0;
            }
            result.append((char)c);
            if (maxChars == -1L || (long)result.length() <= maxChars) continue;
            break;
        }
        return result;
    }

    public static CharSequence readToSpace(Reader in) throws IOException {
        int c;
        StringBuilder result = new StringBuilder();
        while ((c = in.read()) != -1 && !Character.isWhitespace(c)) {
            result.append((char)c);
            if (maxChars == -1L || (long)result.length() <= maxChars) continue;
            break;
        }
        return result;
    }

    public static int firstCharAfterSpace(Reader in) throws IOException {
        int c;
        while ((c = in.read()) != -1 && Character.isWhitespace(c)) {
        }
        return c;
    }

    public static CharSequence readTo(Reader in, char limit) throws IOException {
        int c;
        StringBuilder result = new StringBuilder();
        while ((c = in.read()) != -1 && c != limit) {
            result.append((char)c);
            if (maxChars == -1L || (long)result.length() <= maxChars) continue;
            break;
        }
        return result;
    }

    public static CharSequence readTo(Reader in, String limit) throws IOException {
        int c;
        StringBuilder result = new StringBuilder(2000);
        int position = 0;
        while ((c = in.read()) != -1) {
            result.append((char)c);
            if (c == limit.charAt(position)) {
                if (++position == limit.length()) {
                    break;
                }
            } else {
                position = 0;
            }
            if (maxChars == -1L || (long)result.length() <= maxChars) continue;
            break;
        }
        return result;
    }

    public static String readToBoundary(Reader in, String limit) throws IOException {
        int c;
        StringBuilder result = new StringBuilder(2000);
        int position = 0;
        while ((c = in.read()) != -1) {
            result.append((char)c);
            if (c == limit.charAt(position)) {
                if (++position == limit.length()) {
                    return result.toString().substring(0, result.length() - limit.length());
                }
            } else {
                position = 0;
            }
            if (maxChars == -1L || (long)result.length() <= maxChars) continue;
            return null;
        }
        return null;
    }

    public static boolean scrollTo(Reader in, char ... delimiters) throws IOException {
        int c;
        while ((c = in.read()) != -1) {
            for (int i = 0; i < delimiters.length; ++i) {
                if (c != delimiters[i]) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean scrollTo(Reader in, char delimiter) throws IOException {
        int c;
        while ((c = in.read()) != -1) {
            if (c != delimiter) continue;
            return true;
        }
        return false;
    }

    public static boolean scrollTo(Reader in, String limit) throws IOException {
        int c;
        int position = 0;
        while ((c = in.read()) != -1) {
            if (c == limit.charAt(position)) {
                if (++position != limit.length()) continue;
                return true;
            }
            position = 0;
        }
        return false;
    }

    public static String readBetween(Reader in, String start, String end) throws IOException {
        if (!FileLines.scrollTo(in, start)) {
            return null;
        }
        CharSequence r = FileLines.readTo(in, end);
        if (r == null) {
            return null;
        }
        String s = r.toString();
        if (!s.endsWith(end)) {
            return null;
        }
        return r.toString().substring(0, r.length() - end.length());
    }

    public static String readBetween(String in, String start, String end) {
        try {
            return FileLines.readBetween(new StringReader(in), start, end);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static CharSequence readTo(Reader in, String limit, List<Integer> results) throws IOException {
        int c;
        StringBuilder result = new StringBuilder();
        int position = 0;
        while ((c = in.read()) != -1) {
            result.append((char)c);
            results.add(c);
            if (c == limit.charAt(position)) {
                if (++position == limit.length()) {
                    break;
                }
            } else {
                position = 0;
            }
            if (maxChars == -1L || (long)result.length() <= maxChars) continue;
            break;
        }
        return result;
    }

    public static int numFileLines(File f) throws IOException {
        int counter = 0;
        for (String l : new FileLines(f, "Counting lines in" + f)) {
            ++counter;
        }
        return counter;
    }

    public static int numAllFileLines(File f, String ext) throws IOException {
        if (f.isFile()) {
            return f.getName().endsWith(ext) ? FileLines.numFileLines(f) : 0;
        }
        int counter = 0;
        Announce.doing("Counting in", f);
        for (File f2 : f.listFiles()) {
            counter += FileLines.numAllFileLines(f2, ext);
        }
        Announce.done();
        return counter;
    }
}

