/*
 * Decompiled with CFR 0.152.
 */
package javatools.filehandlers;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Pattern;
import javatools.administrative.D;

public class FileSet
extends ArrayList<File> {
    private static final long serialVersionUID = 1L;

    public static File file(File f, String ... s) {
        for (String n : s) {
            f = new File(f, n);
        }
        return f;
    }

    public FileSet(String folderPlusWildcard) {
        this(new File(folderPlusWildcard));
    }

    public FileSet(File folderPlusWildcard) {
        this(folderPlusWildcard.getParentFile() == null ? new File(".") : folderPlusWildcard.getParentFile(), folderPlusWildcard.getName());
    }

    public FileSet(File path, String fname) {
        String regex = "";
        block5: for (int i = 0; i < fname.length(); ++i) {
            switch (fname.charAt(i)) {
                case '.': {
                    regex = regex + "\\.";
                    continue block5;
                }
                case '?': {
                    regex = regex + '.';
                    continue block5;
                }
                case '*': {
                    regex = regex + ".*";
                    continue block5;
                }
                default: {
                    regex = regex + "[" + Character.toLowerCase(fname.charAt(i)) + Character.toUpperCase(fname.charAt(i)) + ']';
                }
            }
        }
        final Pattern wildcard = Pattern.compile(regex);
        File[] files = path.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return wildcard.matcher(pathname.getName()).matches();
            }
        });
        if (files == null) {
            throw new RuntimeException("Can't find files in " + path);
        }
        this.ensureCapacity(files.length);
        for (File f1 : files) {
            this.add(f1);
        }
    }

    public static String extension(File f) {
        return FileSet.extension(f.getName());
    }

    public static String extension(String f) {
        int dot = f.lastIndexOf(46);
        if (dot == -1) {
            return "";
        }
        return f.substring(dot);
    }

    public static File newExtension(File f, String newex) {
        if (newex == null) {
            newex = "";
        }
        if (newex.startsWith(".")) {
            newex = newex.substring(1);
        }
        int i = f.getName().lastIndexOf(46);
        if (newex.length() == 0) {
            if (i == -1) {
                return f;
            }
            return new File(f.getParentFile(), f.getName().substring(0, i));
        }
        if (i == -1) {
            return new File(f.getParentFile(), f.getName() + '.' + newex);
        }
        return new File(f.getParentFile(), f.getName().substring(0, i) + '.' + newex);
    }

    public static String newExtension(String f, String newex) {
        if (newex == null) {
            newex = "";
        }
        if (newex.startsWith(".")) {
            newex = newex.substring(1);
        }
        int i = f.lastIndexOf(46);
        if (newex.length() == 0) {
            if (i == -1) {
                return f;
            }
            return f.substring(0, i);
        }
        if (i == -1) {
            return f + '.' + newex;
        }
        return f.substring(0, i) + '.' + newex;
    }

    public static String noExtension(String f) {
        int i = f.lastIndexOf(46);
        if (i == -1) {
            return f;
        }
        return f.substring(0, i);
    }

    public static File noExtension(File f) {
        return new File(FileSet.noExtension(f.getPath()));
    }

    public static void main(String[] argv) {
        D.p("Enter a filename with wildcards and hit ENTER. Press CTRL+C to abort");
        block0: while (true) {
            Iterator iterator = new FileSet(D.r()).iterator();
            while (true) {
                if (!iterator.hasNext()) continue block0;
                File f = (File)iterator.next();
                D.p(f);
            }
            break;
        }
    }
}

