/*
 * Decompiled with CFR 0.152.
 */
package javatools.filehandlers;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.LinkedList;
import java.util.zip.GZIPInputStream;
import javatools.filehandlers.FileLines;

public class FileUtils {
    private static final int bufferSize = 0x1000000;

    public static BufferedReader getBufferedUTF8Reader(File file) throws IOException {
        InputStream is = new FileInputStream(file);
        if (file.getName().endsWith(".gz")) {
            is = new GZIPInputStream(is, 0x1000000);
        }
        return FileUtils.getBufferedUTF8Reader(is);
    }

    public static BufferedReader getBufferedUTF8Reader(String fileName) throws IOException {
        return FileUtils.getBufferedUTF8Reader(new File(fileName));
    }

    public static BufferedReader getBufferedUTF8Reader(InputStream inputStream) {
        return new BufferedReader(new InputStreamReader(inputStream, Charset.forName("UTF-8")), 0x1000000);
    }

    public static BufferedWriter getBufferedUTF8Writer(File file) throws FileNotFoundException {
        return new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), Charset.forName("UTF-8")), 0x1000000);
    }

    public static BufferedWriter getBufferedUTF8Writer(String fileName) throws FileNotFoundException {
        return FileUtils.getBufferedUTF8Writer(new File(fileName));
    }

    public static String getFileContent(File file) throws IOException {
        StringBuilder sb = new StringBuilder();
        BufferedReader reader = FileUtils.getBufferedUTF8Reader(file);
        String line = reader.readLine();
        while (line != null) {
            sb.append(line);
            sb.append('\n');
            line = reader.readLine();
        }
        reader.close();
        return sb.toString();
    }

    public static void writeFileContent(File file, String content) throws IOException {
        BufferedWriter writer = FileUtils.getBufferedUTF8Writer(file);
        writer.write(content);
        writer.close();
    }

    public static boolean verifyOrderedFile(File check, boolean descending) throws IOException {
        if (check == null || check.isDirectory() || !check.canRead()) {
            System.out.println("Unable to verify sort order of file, make sure it is readable and not a directory");
        }
        boolean first = true;
        String one = "";
        String two = "";
        long lineCount = 0L;
        FileLines lines = new FileLines(check, "UTF-8", "Verifying that '" + check + "' is sorted");
        for (String line : lines) {
            ++lineCount;
            if (first) {
                one = line;
                two = line;
                first = false;
                continue;
            }
            lines.close();
            one = two;
            two = line;
            int comp = two.compareTo(one);
            if (!descending && comp < 0) {
                System.out.println("Ascending order violated in line " + lineCount + ": '" + one + "' vs. '" + two + "'");
                return false;
            }
            if (!descending || comp <= 0) continue;
            System.out.println("Descending order violated in line " + lineCount + ": '" + one + "' vs. '" + two + "'");
            return false;
        }
        return true;
    }

    public static Collection<File> getAllFiles(File directory) {
        LinkedList<File> files = new LinkedList<File>();
        FileUtils.getAllFilesRecursively(directory, files);
        return files;
    }

    private static void getAllFilesRecursively(File directory, Collection<File> files) {
        for (File file : directory.listFiles()) {
            if (file.isDirectory()) {
                FileUtils.getAllFilesRecursively(file, files);
                continue;
            }
            files.add(file);
        }
    }

    public static void main(String[] args) throws IOException {
        FileUtils.verifyOrderedFile(new File(args[0]), false);
    }
}

