/*
 * Decompiled with CFR 0.152.
 */
package javatools.filehandlers;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javatools.administrative.Announce;
import javatools.datatypes.FinalSet;
import javatools.filehandlers.FileLines;
import javatools.filehandlers.FileSet;

public class LatexChecker {
    public static final Set<String> includeStatements = new FinalSet((Comparable[])new String[]{"\\include", "\\input", "\\includegraphics", "\\documentclass", "\\bibliography", "\\bibliographystyle"});
    public static final String[] extensions = new String[]{"tex", "cls", "bib", "pdf", "eps", "jpg", "bst", "png"};

    public static Set<String> references(File latexFile) throws IOException {
        HashSet<String> result = new HashSet<String>();
        for (String line : new FileLines(latexFile)) {
            if (line.trim().startsWith("%")) continue;
            for (String stat : includeStatements) {
                int i = line.indexOf(stat);
                while (i != -1) {
                    int k;
                    int j = line.indexOf(123, i);
                    if (j != -1 && !Character.isLetter(line.charAt(i + stat.length())) && (k = line.indexOf(125, i)) != -1 && j + 1 != k) {
                        result.add(line.substring(j + 1, k));
                    }
                    i = line.indexOf(stat, i + 1);
                }
            }
        }
        return result;
    }

    public static Set<File> referencedBy(File latexFile) throws IOException {
        Announce.doing("Analyzing", latexFile);
        HashSet<File> result = new HashSet<File>();
        result.add(latexFile);
        for (String filename : LatexChecker.references(latexFile)) {
            String extension;
            File f = new File(latexFile.getParent() + '/' + filename);
            String[] stringArray = extensions;
            int n = stringArray.length;
            for (int i = 0; i < n && !(f = FileSet.newExtension(f, extension = stringArray[i])).exists(); ++i) {
            }
            if (!f.exists()) {
                Announce.warning("**** File not found:", filename);
                continue;
            }
            result.add(f);
            if (!FileSet.extension(f).equals(".tex")) continue;
            result.addAll(LatexChecker.referencedBy(f));
        }
        Announce.done();
        return result;
    }

    public static Set<File> nonReferenced(Set<File> otherFiles) {
        HashSet<File> folders = new HashSet<File>();
        for (File f : otherFiles) {
            folders.add(f.getParentFile());
        }
        HashSet<File> result = new HashSet<File>();
        for (File folder : folders) {
            for (File f : folder.listFiles()) {
                if (otherFiles.contains(f)) continue;
                result.add(f);
            }
        }
        return result;
    }

    public static void main(String[] args) throws Exception {
        args = new String[]{"c:/fabian/conferences/vlds2012_urdf/main.tex"};
        File latexFile = new File(args[0]);
        Set<File> referenced = LatexChecker.referencedBy(latexFile);
        Announce.doing("Referenced files");
        for (File f : referenced) {
            Announce.message(f);
        }
        Announce.doneDoing("Non-referenced");
        Announce.warning("There is no warranty that these files are really non-referenced!");
        for (File f : LatexChecker.nonReferenced(referenced)) {
            Announce.message("del", f);
        }
        Announce.done();
    }
}

