/*
 * Decompiled with CFR 0.152.
 */
package javatools.filehandlers;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import javatools.parsers.Char17;

public class UTF8Writer
extends Writer {
    protected OutputStream out;

    public UTF8Writer(File f, boolean append) throws IOException {
        this(new FileOutputStream(f, append));
    }

    public UTF8Writer(File f) throws IOException {
        this(f, false);
    }

    public UTF8Writer() {
    }

    public UTF8Writer(String f) throws IOException {
        this(new File(f));
    }

    public UTF8Writer(OutputStream f) {
        this.out = f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.out != null) {
                this.out.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.out != null) {
                this.out.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            for (int i = off; i < off + len; ++i) {
                this.write(cbuf[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int c) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.out == null) {
                return;
            }
            String s = Char17.encodeUTF8((char)c);
            for (int i = 0; i < s.length(); ++i) {
                this.out.write((byte)s.charAt(i));
            }
        }
    }

    public void writeln(String s) throws IOException {
        this.write(s);
        this.write(10);
    }

    @Override
    public void write(String s) throws IOException {
        for (int i = 0; i < s.length(); ++i) {
            this.write(s.charAt(i));
        }
    }
}

