/*
 * Decompiled with CFR 0.152.
 */
package javatools.parsers;

import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javatools.administrative.D;

public class NumberFormatter {
    protected int integers = 0;
    protected int fractions = 2;
    protected boolean showPosSign = false;
    protected char separator = '\u0000';
    protected Pattern FORMAT = Pattern.compile("(\\[?(?:\\+/\\-|\\+|\\-)\\]?)?([^\\.]+)(\\.[0-9#]+)?( .*)?");
    protected String append = "";
    public static NumberFormatter sixDigits = new NumberFormatter("######");
    public static NumberFormatter fiveDigits = new NumberFormatter("#####");
    public static NumberFormatter fourDigits = new NumberFormatter("####");
    public static NumberFormatter threeDigits = new NumberFormatter("###");
    public static NumberFormatter twoDigits = new NumberFormatter("##");
    public static NumberFormatter oneDigit = new NumberFormatter("#");
    public static NumberFormatter fourFractions = new NumberFormatter("#.####");
    public static NumberFormatter twoFractions = new NumberFormatter("#.##");

    public NumberFormatter(String f) {
        Matcher m = this.FORMAT.matcher(f);
        if (!m.matches()) {
            return;
        }
        this.showPosSign = m.group(1) != null && m.group(1).indexOf(43) != -1;
        this.integers = m.group(2).length();
        for (int i = 0; i < m.group(2).length(); ++i) {
            if ("0123456789#".indexOf(m.group(2).charAt(i)) != -1) continue;
            this.separator = m.group(2).charAt(i);
            --this.integers;
        }
        int n = this.fractions = m.group(3) == null ? -1 : m.group(3).length() - 1;
        if (m.group(4) != null) {
            this.append = m.group(4);
        }
    }

    public String format(double d) {
        String sign;
        String string = d >= 0.0 ? (this.showPosSign ? "+" : "") : (sign = "-");
        if (Double.isNaN(d)) {
            return "NaN";
        }
        if (Double.isInfinite(d)) {
            return sign + "INF";
        }
        String result = "";
        d = Math.rint(Math.pow(10.0, this.fractions > 0 ? (double)this.fractions : 0.0) * Math.abs(d));
        for (int digits = 0; digits < this.integers + (this.fractions < 0 ? 0 : this.fractions) || d > 0.0; ++digits) {
            if (this.separator != '\u0000' && digits > this.fractions && (digits - this.fractions) % 3 == 0) {
                result = this.separator + result;
            }
            result = (int)(d % 10.0) + result;
            d = Math.floor(d / 10.0);
        }
        if (this.fractions >= 0) {
            result = result.substring(0, result.length() - this.fractions) + '.' + result.substring(result.length() - this.fractions);
        }
        return sign + result + this.append;
    }

    public static String ISOtime() {
        return NumberFormatter.ISOtime(new GregorianCalendar());
    }

    public static String ISOtime(Calendar c) {
        return (c.get(0) == 0 ? "-" : "") + fourDigits.format(c.get(1)) + '-' + twoDigits.format(c.get(2) + 1) + '-' + twoDigits.format(c.get(5)) + " T " + twoDigits.format(c.get(11)) + ":" + twoDigits.format(c.get(12)) + ":" + twoDigits.format(c.get(13)) + "." + fourDigits.format(c.get(14));
    }

    public static String ISOdate() {
        return NumberFormatter.ISOdate(new GregorianCalendar());
    }

    public static String ISOdate(Calendar c) {
        return (c.get(0) == 0 ? "-" : "") + fourDigits.format(c.get(1)) + '-' + twoDigits.format(c.get(2) + 1) + '-' + twoDigits.format(c.get(5));
    }

    public static String ISOweekTime() {
        return NumberFormatter.ISOweekTime(new GregorianCalendar());
    }

    public static String ISOweekTime(Calendar c) {
        return (c.get(0) == 0 ? "-" : "") + fourDigits.format(c.get(1)) + "-w" + twoDigits.format(c.get(3)) + '-' + oneDigit.format(c.get(7) - 1) + " T " + twoDigits.format(c.get(11)) + ":" + twoDigits.format(c.get(12)) + ":" + twoDigits.format(c.get(13)) + "." + fourDigits.format(c.get(14));
    }

    public static String timeStamp(String isoTime) {
        return isoTime.substring(0, isoTime.indexOf(46)).replaceAll("\\D", "");
    }

    public static String timeStamp(Calendar c) {
        return NumberFormatter.timeStamp(NumberFormatter.ISOtime(c));
    }

    public static String timeStamp() {
        return NumberFormatter.timeStamp(NumberFormatter.ISOtime());
    }

    public static String formatMS(long ms) {
        if (ms < 100L) {
            return oneDigit.format(ms) + " ms";
        }
        if (ms < 60000L) {
            return twoFractions.format((double)ms / 1000.0) + " s";
        }
        if (ms < 3600000L) {
            return oneDigit.format(ms / 1000L / 60L) + " min, " + oneDigit.format((double)ms / 1000.0 % 60.0) + " s";
        }
        return oneDigit.format(ms / 1000L / 60L / 60L) + " h, " + oneDigit.format((double)ms / 1000.0 / 60.0 % 60.0) + " min";
    }

    public static void main(String[] argv) {
        D.p(NumberFormatter.ISOtime());
        D.p(NumberFormatter.ISOweekTime());
        D.p(NumberFormatter.formatMS(2L));
        D.p(NumberFormatter.formatMS(200L));
        D.p(NumberFormatter.formatMS(3200L));
        D.p(NumberFormatter.formatMS(243200L));
        D.p(NumberFormatter.formatMS(18243200L));
        D.p("Enter a number to be formatted as #'#.###. Press CTRL+C to abort");
        while (true) {
            D.p(new NumberFormatter("#'#.###").format(Double.parseDouble(D.r())));
        }
    }
}

