/*
 * Decompiled with CFR 0.152.
 */
package javatools.parsers;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javatools.administrative.D;
import javatools.datatypes.FinalMap;
import javatools.parsers.PositionTracker;

public class NumberParser {
    public static final Map<String, Double> prefixes = new FinalMap<String, Double>("tera", 1.0E12, "T", 1.0E12, "giga", 1.0E9, "G", 1.0E9, "M", 1000000.0, "mega", 1000000.0, "kilo", 1000.0, "k", 1000.0, "deci", 0.1, "", 1.0, "d", 0.1, "centi", 0.01, "c", 0.01, "milli", 0.001, "m", 0.001, "micro", 1.0E-6, "mu", 1.0E-6, "nano", 1.0E-9, "n", 1.0E-9);
    private static final String DC = "[\\.,]";
    private static final String DOT = "\\.";
    private static final String DIG = "(\\d)";
    private static final String B = "[\\s_]*+";
    private static final String WB = "\\b";
    private static final String NTH = "(\\d+)(?:th|rd|nd|st)\\b";
    private static final String A = "(?:a|one|A|One)[\\s_]*+";
    private static final String P = "(tera|T|giga|G|mega|M|kilo|k|deci|d|centi|c|milli|m|micro|mu|nano|n|)";
    public static final String FLOAT = "([\\-\\+]?\\d++(?:\\.[0-9]++)?(?:[Ee]\\-?[0-9]++)?)";
    public static final String POSINT = "(\\+?[0-9]++)";
    public static final String INT = "([\\-\\+]?[0-9]++)";
    private static final String SINT = "([0-9]{1,3})";
    private static final String UNIT = "([/a-zA-Z\\%]++(?:\\^\\d)?)";
    public static final Pattern NUMBERPATTERN = Pattern.compile(NumberParser.newNumber("([\\-\\+]?\\d++(?:\\.[0-9]++)?(?:[Ee]\\-?[0-9]++)?)(?:", "([/a-zA-Z\\%]++(?:\\^\\d)?))?"));
    private static final FindReplace[] patterns = new FindReplace[]{new FindReplace("\u00a0", " "), new FindReplace("\\bca?\\.? ?(\\d)", "about $1"), new FindReplace("([^-\\d])(\\d+)-(\\d+)([^-\\d])", "$1$2 - $3$4"), new FindReplace("(\\d{1,3}) (\\d{3}) ?(\\d{3})? ?(\\d{3})?", "$1$2$3$4"), new FindReplace(" [\\.,](\\+?[0-9]++)", " 0.$1"), new FindReplace("(\\d+),(\\d{3}),?(\\d{3})?,?(\\d{3})?,?(\\d{3})?", "$1$2$3$4$5"), new FindReplace("(\\d),(\\d)", "$1.$2"), new FindReplace("\\bfirst\\b", NumberParser.newNumber("1", "th")), new FindReplace("\\btwo\\b", "2"), new FindReplace("\\bsecond\\b", NumberParser.newNumber("2", "th")), new FindReplace("\\bthree\\b", "3"), new FindReplace("\\bthird\\b", NumberParser.newNumber("3", "th")), new FindReplace("\\bfour\\b", "4"), new FindReplace("\\bfourth\\b", NumberParser.newNumber("4", "th")), new FindReplace("\\bfive\\b", "5"), new FindReplace("\\bfiveth\\b", NumberParser.newNumber("5", "th")), new FindReplace("\\bsix\\b", "6"), new FindReplace("\\bsixth\\b", NumberParser.newNumber("6", "th")), new FindReplace("\\bseven\\b", "7"), new FindReplace("\\bseventh\\b", NumberParser.newNumber("7", "th")), new FindReplace("\\beight\\b", "8"), new FindReplace("\\beighth\\b", "" + NumberParser.newNumber("8", "th")), new FindReplace("\\bnine\\b", "9"), new FindReplace("\\bnineth\\b", NumberParser.newNumber("9", "th")), new FindReplace("\\bten\\b", "10"), new FindReplace("\\btenth\\b", NumberParser.newNumber("10", "th")), new FindReplace("\\beleven\\b", "11"), new FindReplace("\\beleventh\\b", NumberParser.newNumber("11", "th")), new FindReplace("\\btwelve\\b", "12"), new FindReplace("\\btwelveth\\b", NumberParser.newNumber("12", "th")), new FindReplace("(?i:US\\$|USD|\\$|\\$US)[\\s_]*+([\\-\\+]?\\d++(?:\\.[0-9]++)?(?:[Ee]\\-?[0-9]++)?)[\\s_]*+[Mm]\\b", "$1 million dollar"), new FindReplace("(?i:euro|eur|euros|\u20ac)[\\s_]*+([\\-\\+]?\\d++(?:\\.[0-9]++)?(?:[Ee]\\-?[0-9]++)?)[\\s_]*+[Mm]\\b", "$1 million euro"), new FindReplace("(?i:US\\$|USD|\\$|\\$US)[\\s_]*+([\\-\\+]?\\d++(?:\\.[0-9]++)?(?:[Ee]\\-?[0-9]++)?)[\\s_]*+[bB]\\b", "$1 billion dollar"), new FindReplace("(?i:euro|eur|euros|\u20ac)[\\s_]*+([\\-\\+]?\\d++(?:\\.[0-9]++)?(?:[Ee]\\-?[0-9]++)?)[\\s_]*+[bB]\\b", "$1 billion euro"), new FindReplace("([0-9]{1,3})\\.(\\d)[\\s_]*+[Tt]rillion", "$1$200000000000"), new FindReplace("([0-9]{1,3})\\.(\\d)(\\d)[\\s_]*+[Tt]rillion", "$1$2$30000000000"), new FindReplace("([0-9]{1,3})\\.(\\d)(\\d)(\\d)[\\s_]*+[Tt]rillion", "$1$2$3$4000000000"), new FindReplace("([0-9]{1,3})[\\s_]*+[Tt]rillion", "$1000000000000"), new FindReplace("([0-9]{1,3})\\.(\\d)[\\s_]*+[Bb]illion", "$1$200000000"), new FindReplace("([0-9]{1,3})\\.(\\d)(\\d)[\\s_]*+[Bb]illion", "$1$2$30000000"), new FindReplace("([0-9]{1,3})\\.(\\d)(\\d)(\\d)[\\s_]*+[Bb]illion", "$1$2$3$4000000"), new FindReplace("([0-9]{1,3})[\\s_]*+[Bb]illion", "$1000000000"), new FindReplace("([0-9]{1,3})\\.(\\d)[\\s_]*+[Bb]n?", "$1$200000000"), new FindReplace("([0-9]{1,3})\\.(\\d)(\\d)[\\s_]*+[Bb]n?", "$1$2$30000000"), new FindReplace("([0-9]{1,3})\\.(\\d)(\\d)(\\d)[\\s_]*+[Bb]n?", "$1$2$3$4000000"), new FindReplace("([0-9]{1,3})[\\s_]*+[Bb]n", "$1000000000"), new FindReplace("([0-9]{1,3})\\.(\\d)[\\s_]*+[Mm]illion", "$1$200000"), new FindReplace("([0-9]{1,3})\\.(\\d)(\\d)[\\s_]*+[Mm]illion", "$1$2$30000"), new FindReplace("([0-9]{1,3})\\.(\\d)(\\d)(\\d)[\\s_]*+[Mm]illion", "$1$2$3$4000"), new FindReplace("([0-9]{1,3})[\\s_]*+[Mm]illion", "$1000000"), new FindReplace("([0-9]{1,3})\\.(\\d)[\\s_]*+[Tt]housand", "$1$200"), new FindReplace("([0-9]{1,3})[\\s_]*+[Tt]housand", "$1000"), new FindReplace("([0-9]{1,3})[\\s_]*+[Hh]undred", "$100"), new FindMultiply("[Dd]ozens?", null, 12.0), new FindReplace("(?:a|one|A|One)[\\s_]*+[Bb]illion", "1000000000"), new FindReplace("(?:a|one|A|One)[\\s_]*+[Mm]illion", "1000000"), new FindReplace("(?:a|one|A|One)[\\s_]*+[Tt]housand", "1000"), new FindReplace("(?:a|one|A|One)[\\s_]*+[Hh]undred", "100"), new FindReplace("(?:a|one|A|One)[\\s_]*+[Dd]ozen", "12"), new FindReplace("(\\d+)(?:th|rd|nd|st)\\b", NumberParser.newNumber("$1", "th")), new FindReplace("\u00b9", "^1"), new FindReplace("\u00b2", "^2"), new FindReplace("\u00b3", "^3"), new FindReplace("-?[\\s_]*+([\\d\\.]+)[\\s_]*+(\u00b0|degrees?)[\\s_]*+([\\d\\.]+)?[\\s_]*+('|minutes|min|mn|m)[\\s_]*+([\\d\\.]+)?[\\s_]*+(''|seconds|sec|s|\")[\\s_]*+(N|E|W|S)", null){

        @Override
        public void apply(StringBuilder s, StringBuilder result) {
            result.setLength(0);
            Matcher m = this.pattern.matcher(s);
            if (!m.find()) {
                return;
            }
            int pos = 0;
            do {
                for (int i = pos; i < m.start(); ++i) {
                    result.append(s.charAt(i));
                }
                pos = m.end();
                try {
                    char loc;
                    double num = Double.parseDouble(m.group(1));
                    if (m.group(3) != null) {
                        num += Double.parseDouble(m.group(3)) / 60.0;
                    }
                    if (m.group(5) != null) {
                        num += Double.parseDouble(m.group(5)) / 60.0 / 60.0;
                    }
                    if ((loc = m.group(7).charAt(0)) == 'W') {
                        num = -num;
                    }
                    if (loc == 'S') {
                        num = -num;
                    }
                    result.append(NumberParser.newNumber(Double.toString(num), "degrees"));
                }
                catch (Exception e) {
                    result.append(m.group());
                }
            } while (m.find());
            for (int i = pos; i < s.length(); ++i) {
                result.append(s.charAt(i));
            }
        }

        @Override
        public void apply(StringBuilder s, StringBuilder result, PositionTracker posTracker) {
            Integer difference = 0;
            result.setLength(0);
            Matcher m = this.pattern.matcher(s);
            if (!m.find()) {
                return;
            }
            int pos = 0;
            do {
                for (int i = pos; i < m.start(); ++i) {
                    result.append(s.charAt(i));
                }
                pos = m.end();
                try {
                    char loc;
                    double num = Double.parseDouble(m.group(1));
                    if (m.group(3) != null) {
                        num += Double.parseDouble(m.group(3)) / 60.0;
                    }
                    if (m.group(5) != null) {
                        num += Double.parseDouble(m.group(5)) / 60.0 / 60.0;
                    }
                    if ((loc = m.group(7).charAt(0)) == 'W') {
                        num = -num;
                    }
                    if (loc == 'S') {
                        num = -num;
                    }
                    String add = NumberParser.newNumber(Double.toString(num), "degrees");
                    result.append(add);
                    difference = add.length() - (m.end() - m.start());
                    posTracker.addPositionChange(m.end(), difference);
                }
                catch (Exception e) {
                    result.append(m.group());
                }
            } while (m.find());
            for (int i = pos; i < s.length(); ++i) {
                result.append(s.charAt(i));
            }
            posTracker.closeRun();
        }
    }, new FindReplace("(\\+?[0-9]++):(\\+?[0-9]++)[\\s_]*+pm\\b", null){

        @Override
        public void apply(StringBuilder s, StringBuilder result, PositionTracker posTracker) {
            result.setLength(0);
            Integer difference = 0;
            Matcher m = this.pattern.matcher(s);
            if (!m.find()) {
                return;
            }
            int pos = 0;
            do {
                for (int i = pos; i < m.start(); ++i) {
                    result.append(s.charAt(i));
                }
                pos = m.end();
                String rep = NumberParser.newNumber(Integer.parseInt(m.group(1)) + 12 + "." + m.group(2), "oc");
                result.append(rep);
                difference = rep.length() - (m.end() - m.start());
                posTracker.addPositionChange(m.end(), difference);
            } while (m.find());
            for (int i = pos; i < s.length(); ++i) {
                result.append(s.charAt(i));
            }
            posTracker.closeRun();
        }

        @Override
        public void apply(StringBuilder s, StringBuilder result) {
            int i;
            result.setLength(0);
            Matcher m = this.pattern.matcher(s);
            if (!m.find()) {
                return;
            }
            int pos = 0;
            do {
                for (i = pos; i < m.start(); ++i) {
                    result.append(s.charAt(i));
                }
                pos = m.end();
                result.append(NumberParser.newNumber(Integer.parseInt(m.group(1)) + 12 + "." + m.group(2), "oc"));
            } while (m.find());
            for (i = pos; i < s.length(); ++i) {
                result.append(s.charAt(i));
            }
        }
    }, new FindReplace("(\\d+):(\\d{2})(?::(\\d{2})(?:\\.(\\d+))?)?\\s*h", null){

        @Override
        public void apply(StringBuilder s, StringBuilder result, PositionTracker posTracker) {
            result.setLength(0);
            Matcher m = this.pattern.matcher(s);
            if (!m.find()) {
                return;
            }
            int pos = 0;
            do {
                for (int i = pos; i < m.start(); ++i) {
                    result.append(s.charAt(i));
                }
                pos = m.end();
                double val = Double.parseDouble(m.group(1)) * 3600.0 + Double.parseDouble(m.group(2)) * 60.0;
                if (m.group(3) != null) {
                    val += Double.parseDouble(m.group(3));
                }
                if (m.group(4) != null) {
                    val += Double.parseDouble("0." + m.group(4));
                }
                String rep = NumberParser.newNumber(val, "s");
                result.append(rep).append(' ');
                Integer difference = rep.length() + 1 - (m.end() - m.start());
                posTracker.addPositionChange(m.end(), difference);
            } while (m.find());
            for (int i = pos; i < s.length(); ++i) {
                result.append(s.charAt(i));
            }
            posTracker.closeRun();
        }

        @Override
        public void apply(StringBuilder s, StringBuilder result) {
            result.setLength(0);
            Matcher m = this.pattern.matcher(s);
            if (!m.find()) {
                return;
            }
            int pos = 0;
            do {
                for (int i = pos; i < m.start(); ++i) {
                    result.append(s.charAt(i));
                }
                pos = m.end();
                double val = Double.parseDouble(m.group(1)) * 3600.0 + Double.parseDouble(m.group(2)) * 60.0;
                if (m.group(3) != null) {
                    val += Double.parseDouble(m.group(3));
                }
                if (m.group(4) != null) {
                    val += Double.parseDouble("0." + m.group(4));
                }
                result.append(NumberParser.newNumber(val, "s")).append(' ');
            } while (m.find());
            for (int i = pos; i < s.length(); ++i) {
                result.append(s.charAt(i));
            }
        }
    }, new FindReplace("(\\d++)\\s*+h(?:ours?)?\\W*+(\\d++)\\s*+min(?:utes)?", null){

        @Override
        public void apply(StringBuilder s, StringBuilder result, PositionTracker posTracker) {
            result.setLength(0);
            Matcher m = this.pattern.matcher(s);
            if (!m.find()) {
                return;
            }
            int pos = 0;
            do {
                for (int i = pos; i < m.start(); ++i) {
                    result.append(s.charAt(i));
                }
                pos = m.end();
                double val = Double.parseDouble(m.group(1)) * 3600.0 + Double.parseDouble(m.group(2)) * 60.0;
                String rep = NumberParser.newNumber(val, "s");
                result.append(rep).append(' ');
                Integer difference = rep.length() + 1 - (m.end() - m.start());
                posTracker.addPositionChange(m.end(), difference);
            } while (m.find());
            for (int i = pos; i < s.length(); ++i) {
                result.append(s.charAt(i));
            }
            posTracker.closeRun();
        }

        @Override
        public void apply(StringBuilder s, StringBuilder result) {
            result.setLength(0);
            Matcher m = this.pattern.matcher(s);
            if (!m.find()) {
                return;
            }
            int pos = 0;
            do {
                for (int i = pos; i < m.start(); ++i) {
                    result.append(s.charAt(i));
                }
                pos = m.end();
                double val = Double.parseDouble(m.group(1)) * 3600.0 + Double.parseDouble(m.group(2)) * 60.0;
                result.append(NumberParser.newNumber(val, "s")).append(' ');
            } while (m.find());
            for (int i = pos; i < s.length(); ++i) {
                result.append(s.charAt(i));
            }
        }
    }, new FindReplace("(\\+?[0-9]++)[\\s_]*+(?:[Ss]t\\.?|[Ss]tones?)[\\s_]*+(\\+?[0-9]++)[\\s_]*+(?:[lL]b\\.?)\\b", null){

        @Override
        public void apply(StringBuilder s, StringBuilder result) {
            result.setLength(0);
            Matcher m = this.pattern.matcher(s);
            if (!m.find()) {
                return;
            }
            int pos = 0;
            do {
                for (int i = pos; i < m.start(); ++i) {
                    result.append(s.charAt(i));
                }
                pos = m.end();
                String rep = NumberParser.newNumber((double)Integer.parseInt(m.group(1)) * 6350.29 + (double)Integer.parseInt(m.group(2)) * 453.592, "g");
                result.append(rep);
            } while (m.find());
            for (int i = pos; i < s.length(); ++i) {
                result.append(s.charAt(i));
            }
        }
    }, new FindReplace("(\\+?[0-9]++)[\\s_]*+(?:'|[Ff]t\\.?|[fF]eet)[\\s_]*+(\\+?[0-9]++)[\\s_]*+(?:\"|[iI]ns?\\.?|[iI]nch(?:es))\\b", null){

        @Override
        public void apply(StringBuilder s, StringBuilder result, PositionTracker posTracker) {
            result.setLength(0);
            Matcher m = this.pattern.matcher(s);
            if (!m.find()) {
                return;
            }
            int pos = 0;
            do {
                for (int i = pos; i < m.start(); ++i) {
                    result.append(s.charAt(i));
                }
                pos = m.end();
                String rep = NumberParser.newNumber((double)Integer.parseInt(m.group(1)) * 0.3048 + (double)Integer.parseInt(m.group(2)) * 0.0254, "m");
                result.append(rep);
                Integer difference = rep.length() - (m.end() - m.start());
                posTracker.addPositionChange(m.end(), difference);
            } while (m.find());
            for (int i = pos; i < s.length(); ++i) {
                result.append(s.charAt(i));
            }
        }

        @Override
        public void apply(StringBuilder s, StringBuilder result) {
            int i;
            result.setLength(0);
            Matcher m = this.pattern.matcher(s);
            if (!m.find()) {
                return;
            }
            int pos = 0;
            do {
                for (i = pos; i < m.start(); ++i) {
                    result.append(s.charAt(i));
                }
                pos = m.end();
                result.append(NumberParser.newNumber((double)Integer.parseInt(m.group(1)) * 0.3048 + (double)Integer.parseInt(m.group(2)) * 0.0254, "m"));
            } while (m.find());
            for (i = pos; i < s.length(); ++i) {
                result.append(s.charAt(i));
            }
        }
    }, new FindCompute("(pounds|pound|lb|lbs)", "g", 453.59237, 0.0), new FindReplace("([\\-\\+]?\\d++(?:\\.[0-9]++)?(?:[Ee]\\-?[0-9]++)?)[\\s_]*+/km\\^2", NumberParser.newNumber("$1", "/km^2")), new FindReplace("(\\+?[0-9]++)[\\s_]*+o'?clock am\\b", NumberParser.newNumber("$1", "oc")), new FindAdd("o'?clock pm", "oc", 12.0), new FindReplace("(\\+?[0-9]++)[\\s_]*+o'?clock", NumberParser.newNumber("$1", "oc")), new FindReplace("(\\+?[0-9]++):(\\+?[0-9]++)[\\s_]*+am\\b", NumberParser.newNumber("$1.$2", "oc")), new FindReplace("(\\+?[0-9]++)[\\s_]*+am\\b", NumberParser.newNumber("$1", "oc")), new FindAdd("pm", "oc", 12.0), new FindReplace("([0-9]{1,3}),(\\d)%", NumberParser.newNumber("$1.$2", "%")), new FindReplace("([\\-\\+]?\\d++(?:\\.[0-9]++)?(?:[Ee]\\-?[0-9]++)?)[\\s_]*+%", NumberParser.newNumber("$1", "%")), new FindReplace("(?i:US\\$|USD|\\$|\\$US|US\\$)[\\s_]*+([\\-\\+]?\\d++(?:\\.[0-9]++)?(?:[Ee]\\-?[0-9]++)?)", NumberParser.newNumber("$1", "dollar")), new FindReplace("(?i:eur|euro|euros|\u20ac)[\\s_]*+([\\-\\+]?\\d++(?:\\.[0-9]++)?(?:[Ee]\\-?[0-9]++)?)", NumberParser.newNumber("$1", "euro")), new FindCompute("((?i:dollars|dollar|\\$|US\\$|USD|\\$US))", "dollar"), new FindCompute("((?i:euro?s?))", "euro"), new FindCompute("(metres|meters|meter|metre|m)(\\^)?2", "m^2"), new FindCompute("(metres|meters|meter|metre|m)(\\^)?3", "m^3"), new FindCompute("(metres|meters|meter|metre|m)", "m"), new FindCompute("(square|sq)[\\s_]*+(tera|T|giga|G|mega|M|kilo|k|deci|d|centi|c|milli|m|micro|mu|nano|n|)(metres|meters|meter|metre|m)", "m^2"), new FindCompute("(cubic|cu)[\\s_]*+(tera|T|giga|G|mega|M|kilo|k|deci|d|centi|c|milli|m|micro|mu|nano|n|)(metres|meters|meter|metre|m)", "m^3"), new FindCompute("(g|grams|gram)", "g"), new FindCompute("(seconds|s)", "s"), new FindCompute("(amperes|ampere|A)", "a"), new FindCompute("(Kelvin|K)", "K"), new FindCompute("(Mol|mol)", "mol"), new FindCompute("(candela|cd)", "can"), new FindCompute("(radians|rad)", "rad"), new FindCompute("(hertz|Hz)", "hz"), new FindCompute("(newton|N)", "N"), new FindCompute("(joule|J)", "J"), new FindCompute("(watt|W)", "W"), new FindCompute("(pascal|Pa|pa)", "pa"), new FindCompute("(lumen|lm)", "lm"), new FindCompute("(lux|lx)", "lx"), new FindCompute("(coulomb|C)", "C"), new FindCompute("(volt|V)", "V"), new FindCompute("(ohm|O)", "ohm"), new FindCompute("(farad|F)", "F"), new FindCompute("(weber|Wb)", "Wb"), new FindCompute("(tesla|T)", "T"), new FindCompute("(henry|H)", "H"), new FindCompute("(siemens|S)", "S"), new FindCompute("(becquerel|Bq)", "Bq"), new FindCompute("(gray|Gy)", "Gy"), new FindCompute("(sievert|Sv)", "Sv"), new FindCompute("(katal|kat)", "kat"), new FindCompute("(bytes|b|Bytes|B)", "byte"), new FindCompute("(degrees|degree)[\\s_]*+(Celsius|C)", "kelvin", 1.0, 273.15), new FindCompute("([Mm]inutes|[Mm]inute|[Mm]in|[Mm]ins)", "s", 60.0, 0.0), new FindCompute("(hours|hour|h)", "s", 3600.0, 0.0), new FindCompute("(days|day)", "s", 86400.0, 0.0), new FindCompute("(litres|liters|litre|liter|l|L)", "m^3", 0.001, 0.0), new FindCompute("(metric )?(tonnes|tons|tonne|ton|t)", "g", 1000000.0, 0.0), new FindCompute("nautical (miles|mile)", "m", 1852.0, 0.0), new FindCompute("(knots|knot)", "m/h", 1852.0, 0.0), new FindCompute("(hectares|hectare|ha)", "m^2", 10000.0, 0.0), new FindCompute("bar", "pa", 100000.0, 0.0), new FindCompute("(inches|inch|in)\\^2", "m^2", 6.4516E-4, 0.0), new FindCompute("(foot|ft|feet)\\^2", "m^2", 9.290304E-4, 0.0), new FindCompute("(miles|mile|mi)\\^2", "m^2", 2589988.110336, 0.0), new FindCompute("(inches|inch|in)\\^3", "m^3", 1.6387064E-5, 0.0), new FindCompute("(feet|foot|ft)\\^3", "m^3", 0.028317, 0.0), new FindCompute("(yards|yard|yd)\\^3", "m^3", 0.007646, 0.0), new FindCompute("(inches|inch)", "m", 0.0254, 0.0), new FindCompute("in", "m", 0.0254, 0.0, true), new FindCompute("(foot|feet|ft)", "m", 0.3048, 0.0), new FindCompute("(yards|yard|yd)", "m", 0.9144, 0.0), new FindCompute("(miles|mile|mi)", "m", 1609.344, 0.0), new FindCompute("(square|sq)[\\s_]*+(inches|inch|in)", "m^2", 6.4516E-4, 0.0), new FindCompute("(square|sq)[\\s_]*+(foot|ft|feet)", "m^2", 0.09290304, 0.0), new FindCompute("(acres|acre)", "m^2", 4046.8564224, 0.0), new FindCompute("(square|sq)[\\s_]*+(miles|mile|mi)", "m^2", 2589988.11, 0.0), new FindCompute("(cubic|cu)[\\s_]*+(inches|inch|in)", "m^3", 1.6387064E-5, 0.0), new FindCompute("(cubic|cu)[\\s_]*+(feet|foot|ft)", "m^3", 0.0283168466, 0.0), new FindCompute("(cubic|cu)[\\s_]*+(yards|yard|yd)", "m^3", 0.764554858, 0.0), new FindCompute("acre-foot", "m^2", 12334.818, 0.0), new FindCompute("(gallon|gallons|gal)", "m^2", 0.0037854118, 0.0), new FindCompute("(ounces|ounce|oz)", "g", 28.3495231, 0.0), new FindCompute("(pounds|pound|lb|lbs)", "g", 453.59237, 0.0), new FindCompute("(stones|stone)", "g", 6350.29318, 0.0), new FindCompute("(degrees? Fahrenheit|degrees? F|Fahrenheit)", "K", 0.55555555555, 459.67), new FindCompute("(degrees|degree)", "rad", 0.0174532925, 0.0)};

    public static final String newNumber(String n, String type) {
        return n + '#' + type;
    }

    public static final String newNumber(String n) {
        return n;
    }

    public static final String newNumber(double d, String type) {
        return NumberParser.newNumber(d + "", type);
    }

    public static boolean isFloat(String s) {
        return s.matches(FLOAT);
    }

    public static boolean isInt(String s) {
        return s.matches(INT);
    }

    public static boolean isNonNegativeInt(String s) {
        return s.matches(POSINT);
    }

    public static boolean isNumberAndUnit(String s) {
        return NUMBERPATTERN.matcher(s).matches();
    }

    public static String normalize(CharSequence s) {
        StringBuilder in = new StringBuilder((int)((double)s.length() * 1.1)).append(s);
        StringBuilder result = new StringBuilder((int)((double)s.length() * 1.1));
        for (FindReplace fr : patterns) {
            fr.apply(in, result);
            if (result.length() == 0) continue;
            StringBuilder temp = in;
            in = result;
            result = temp;
        }
        result = null;
        return in.toString();
    }

    public static String normalize(CharSequence s, PositionTracker posTracker) {
        StringBuilder in = new StringBuilder((int)((double)s.length() * 1.1)).append(s);
        StringBuilder result = new StringBuilder((int)((double)s.length() * 1.1));
        for (FindReplace fr : patterns) {
            fr.apply(in, result, posTracker);
            if (result.length() == 0) continue;
            StringBuilder temp = in;
            in = result;
            result = temp;
        }
        result = null;
        return in.toString();
    }

    public static String getNumber(CharSequence d) {
        if (d == null) {
            return null;
        }
        Matcher m = NUMBERPATTERN.matcher(d);
        if (m.find()) {
            return m.group(1);
        }
        return null;
    }

    public static String[] getNumberAndUnit(CharSequence d, int[] pos) {
        Matcher m = NUMBERPATTERN.matcher(d);
        if (!m.find()) {
            return null;
        }
        pos[0] = m.start();
        pos[1] = m.end();
        return new String[]{m.group(1), m.group(2)};
    }

    public static List<String> getNumbers(CharSequence d) {
        ArrayList<String> result = new ArrayList<String>(3);
        Matcher m = NUMBERPATTERN.matcher(d);
        while (m.find()) {
            result.add(m.group());
        }
        return result;
    }

    public static Double getDouble(CharSequence d) {
        String number = NumberParser.getNumber(NumberParser.normalize(d));
        if (number == null) {
            return null;
        }
        return new Double(number);
    }

    public static Long getLong(CharSequence d) {
        String number = NumberParser.getNumber(NumberParser.normalize(d));
        if (number == null) {
            return null;
        }
        return new Double(number).longValue();
    }

    public static Integer getInt(CharSequence d) {
        String number = NumberParser.getNumber(NumberParser.normalize(d));
        if (number == null) {
            return null;
        }
        return new Double(number).intValue();
    }

    public static Integer parseInt(String d) {
        try {
            return Integer.parseInt(d);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Double parseDouble(String d) {
        try {
            return Double.parseDouble(d);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean different(String n1, String n2) {
        double val2;
        String[] num2;
        String[] num1 = NumberParser.getNumberAndUnit(n1, new int[2]);
        if (!D.equal(num1[1], (num2 = NumberParser.getNumberAndUnit(n2, new int[2]))[1])) {
            return true;
        }
        double val1 = Double.parseDouble(num1[0]);
        return Math.abs(val1 - (val2 = Double.parseDouble(num2[0]))) > Math.abs(val1) / 10.0;
    }

    public static void main(String[] argv) throws Exception {
        System.out.println("Enter a string that contains a number and hit ENTER. Press CTRL+C to abort");
        while (true) {
            String in = D.r();
            System.out.println(NumberParser.normalize(in));
            System.out.println(NumberParser.getDouble(in));
        }
    }

    private static class FindMultiply
    extends FindCompute {
        public FindMultiply(String f, String unit, double fac) {
            super(f, unit, fac, 0.0);
        }
    }

    private static class FindAdd
    extends FindCompute {
        public FindAdd(String f, String unit, double sum) {
            super(f, unit, 1.0, sum);
        }
    }

    private static class FindCompute
    extends FindReplace {
        public double factor;
        public double summand;

        public FindCompute(String f, String unit, double fac, double sum) {
            super("([\\-\\+]?\\d++(?:\\.[0-9]++)?(?:[Ee]\\-?[0-9]++)?)[\\s_]*+(tera|T|giga|G|mega|M|kilo|k|deci|d|centi|c|milli|m|micro|mu|nano|n|)" + f + NumberParser.WB, unit);
            this.factor = fac;
            this.summand = sum;
        }

        public FindCompute(String f, String unit, double fac, double sum, boolean dummy) {
            super("([\\-\\+]?\\d++(?:\\.[0-9]++)?(?:[Ee]\\-?[0-9]++)?)(tera|T|giga|G|mega|M|kilo|k|deci|d|centi|c|milli|m|micro|mu|nano|n|)" + f + NumberParser.WB, unit);
            this.factor = fac;
            this.summand = sum;
        }

        public FindCompute(String f, String unit) {
            this(f, unit, 1.0, 0.0);
        }

        @Override
        public void apply(StringBuilder s, StringBuilder result) {
            result.setLength(0);
            Matcher m = this.pattern.matcher(s);
            if (!m.find()) {
                return;
            }
            int pow = this.replacement != null && Character.isDigit(this.replacement.charAt(this.replacement.length() - 1)) ? this.replacement.charAt(this.replacement.length() - 1) - 48 : 1;
            int pos = 0;
            do {
                for (int i = pos; i < m.start(); ++i) {
                    result.append(s.charAt(i));
                }
                pos = m.end();
                double val = Double.parseDouble(m.group(1));
                if (this.replacement == null) {
                    result.append((val + this.summand) * this.factor * prefixes.get(m.group(2)) + "").append(' ');
                    continue;
                }
                result.append(NumberParser.newNumber((val + this.summand) * this.factor * Math.pow(prefixes.get(m.group(2)), pow), this.replacement)).append(' ');
            } while (m.find());
            for (int i = pos; i < s.length(); ++i) {
                result.append(s.charAt(i));
            }
        }

        @Override
        public void apply(StringBuilder s, StringBuilder result, PositionTracker posTracker) {
            Integer difference = 0;
            result.setLength(0);
            Matcher m = this.pattern.matcher(s);
            if (!m.find()) {
                return;
            }
            int pow = this.replacement != null && Character.isDigit(this.replacement.charAt(this.replacement.length() - 1)) ? this.replacement.charAt(this.replacement.length() - 1) - 48 : 1;
            int pos = 0;
            do {
                String rep;
                for (int i = pos; i < m.start(); ++i) {
                    result.append(s.charAt(i));
                }
                pos = m.end();
                double val = Double.parseDouble(m.group(1));
                if (this.replacement == null) {
                    rep = (val + this.summand) * this.factor * prefixes.get(m.group(2)) + " ";
                    result.append(rep);
                    difference = rep.length() - (m.end() - m.start());
                    posTracker.addPositionChange(m.end(), difference);
                    continue;
                }
                rep = NumberParser.newNumber((val + this.summand) * this.factor * Math.pow(prefixes.get(m.group(2)), pow), this.replacement) + ' ';
                result.append(rep);
                difference = rep.length() - (m.end() - m.start());
                posTracker.addPositionChange(m.end(), difference);
            } while (m.find());
            for (int i = pos; i < s.length(); ++i) {
                result.append(s.charAt(i));
            }
            posTracker.closeRun();
        }
    }

    private static class FindReplace {
        public Pattern pattern;
        public String replacement;

        public String toString() {
            return this.pattern + "   -->   " + this.replacement;
        }

        public FindReplace(String f, String r) {
            this.pattern = Pattern.compile(f);
            this.replacement = r;
        }

        public void apply(StringBuilder s, StringBuilder result) {
            int i;
            result.setLength(0);
            Matcher m = this.pattern.matcher(s);
            if (!m.find()) {
                return;
            }
            int pos = 0;
            do {
                for (i = pos; i < m.start(); ++i) {
                    result.append(s.charAt(i));
                }
                pos = m.end();
                for (i = 0; i < this.replacement.length(); ++i) {
                    if (this.replacement.charAt(i) == '$') {
                        String rep = m.group(this.replacement.charAt(i + 1) - 48);
                        if (rep != null) {
                            result.append(rep);
                        }
                        ++i;
                        continue;
                    }
                    result.append(this.replacement.charAt(i));
                }
            } while (m.find());
            for (i = pos; i < s.length(); ++i) {
                result.append(s.charAt(i));
            }
        }

        public void apply(StringBuilder s, StringBuilder result, PositionTracker posTracker) {
            int i;
            result.setLength(0);
            Matcher m = this.pattern.matcher(s);
            if (!m.find()) {
                return;
            }
            int pos = 0;
            int adddiff = 0;
            int difference = 0;
            do {
                for (i = pos; i < m.start(); ++i) {
                    result.append(s.charAt(i));
                }
                pos = m.end();
                adddiff = 0;
                for (i = 0; i < this.replacement.length(); ++i) {
                    if (this.replacement.charAt(i) == '$') {
                        String rep = m.group(this.replacement.charAt(i + 1) - 48);
                        adddiff -= 2;
                        if (rep != null) {
                            adddiff += rep.length();
                            result.append(rep);
                        }
                        ++i;
                        continue;
                    }
                    result.append(this.replacement.charAt(i));
                }
                difference = this.replacement.length() + adddiff - (m.end() - m.start());
                posTracker.addPositionChange(m.end(), difference);
            } while (m.find());
            for (i = pos; i < s.length(); ++i) {
                result.append(s.charAt(i));
            }
            posTracker.closeRun();
        }
    }
}

