/*
 * Decompiled with CFR 0.152.
 */
package org.videolan.libvlc;

import android.annotation.TargetApi;
import android.graphics.SurfaceTexture;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.MainThread;
import android.util.Log;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.TextureView;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.videolan.libvlc.AWindowNativeHandler;
import org.videolan.libvlc.IVLCVout;
import org.videolan.libvlc.util.AndroidUtil;

public class AWindow
implements IVLCVout {
    private static final String TAG = "AWindow";
    private static final int ID_VIDEO = 0;
    private static final int ID_SUBTITLES = 1;
    private static final int ID_MAX = 2;
    private static final int SURFACE_STATE_INIT = 0;
    private static final int SURFACE_STATE_ATTACHED = 1;
    private static final int SURFACE_STATE_READY = 2;
    private final SurfaceHelper[] mSurfaceHelpers;
    private final SurfaceCallback mSurfaceCallback;
    private final AtomicInteger mSurfacesState = new AtomicInteger(0);
    private ArrayList<IVLCVout.Callback> mIVLCVoutCallbacks = new ArrayList();
    private final Handler mHandler = new Handler(Looper.getMainLooper());
    private final Object mNativeLock = new Object();
    private final Surface[] mSurfaces;
    private long mCallbackNativeHandle = 0L;
    private int mMouseAction = -1;
    private int mMouseButton = -1;
    private int mMouseX = -1;
    private int mMouseY = -1;
    private int mWindowWidth = -1;
    private int mWindowHeight = -1;
    private final BuffersGeometryCond mBuffersGeometryCond = new BuffersGeometryCond();
    private final AWindowNativeHandler mAWindowNativeHandler = new AWindowNativeHandler(){

        @Override
        protected native void nativeOnMouseEvent(long var1, int var3, int var4, int var5, int var6);

        @Override
        protected native void nativeOnWindowSize(long var1, int var3, int var4);

        @Override
        public Surface getVideoSurface() {
            return AWindow.this.getNativeSurface(0);
        }

        @Override
        public Surface getSubtitlesSurface() {
            return AWindow.this.getNativeSurface(1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean setCallback(long nativeHandle) {
            Object object = AWindow.this.mNativeLock;
            synchronized (object) {
                if (AWindow.this.mCallbackNativeHandle != 0L && nativeHandle != 0L) {
                    return false;
                }
                AWindow.this.mCallbackNativeHandle = nativeHandle;
                if (AWindow.this.mCallbackNativeHandle != 0L) {
                    if (AWindow.this.mMouseAction != -1) {
                        this.nativeOnMouseEvent(AWindow.this.mCallbackNativeHandle, AWindow.this.mMouseAction, AWindow.this.mMouseButton, AWindow.this.mMouseX, AWindow.this.mMouseY);
                    }
                    if (AWindow.this.mWindowWidth != -1 && AWindow.this.mWindowHeight != -1) {
                        this.nativeOnWindowSize(AWindow.this.mCallbackNativeHandle, AWindow.this.mWindowWidth, AWindow.this.mWindowHeight);
                    }
                }
                AWindow.this.mMouseAction = (AWindow.this.mMouseButton = (AWindow.this.mMouseX = (AWindow.this.mMouseY = -1)));
                AWindow.this.mWindowWidth = (AWindow.this.mWindowHeight = -1);
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean setBuffersGeometry(final Surface surface, final int width, final int height, final int format) {
            if (AndroidUtil.isICSOrLater()) {
                return false;
            }
            if (width * height == 0) {
                return false;
            }
            Log.d((String)AWindow.TAG, (String)("configureSurface: " + width + "x" + height));
            BuffersGeometryCond buffersGeometryCond = AWindow.this.mBuffersGeometryCond;
            synchronized (buffersGeometryCond) {
                if (AWindow.this.mBuffersGeometryCond.configured || AWindow.this.mBuffersGeometryCond.abort) {
                    return false;
                }
            }
            AWindow.this.mHandler.post(new Runnable(){

                private SurfaceHelper getSurfaceHelper(Surface surface2) {
                    for (int id = 0; id < 2; ++id) {
                        SurfaceHelper surfaceHelper = AWindow.this.mSurfaceHelpers[id];
                        if (surfaceHelper == null || surfaceHelper.getSurface() != surface2) continue;
                        return surfaceHelper;
                    }
                    return null;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    SurfaceHolder surfaceHolder;
                    SurfaceHelper surfaceHelper = this.getSurfaceHelper(surface);
                    SurfaceHolder surfaceHolder2 = surfaceHolder = surfaceHelper != null ? surfaceHelper.getSurfaceHolder() : null;
                    if (surfaceHolder != null && surfaceHolder.getSurface().isValid()) {
                        if (format != 0) {
                            surfaceHolder.setFormat(format);
                        }
                        surfaceHolder.setFixedSize(width, height);
                    }
                    BuffersGeometryCond buffersGeometryCond = AWindow.this.mBuffersGeometryCond;
                    synchronized (buffersGeometryCond) {
                        AWindow.this.mBuffersGeometryCond.configured = true;
                        AWindow.this.mBuffersGeometryCond.notifyAll();
                    }
                }
            });
            try {
                buffersGeometryCond = AWindow.this.mBuffersGeometryCond;
                synchronized (buffersGeometryCond) {
                    while (!AWindow.this.mBuffersGeometryCond.configured && !AWindow.this.mBuffersGeometryCond.abort) {
                        AWindow.this.mBuffersGeometryCond.wait();
                    }
                    AWindow.this.mBuffersGeometryCond.configured = false;
                }
            }
            catch (InterruptedException e) {
                return false;
            }
            return true;
        }

        @Override
        public void setWindowLayout(final int width, final int height, final int visibleWidth, final int visibleHeight, final int sarNum, final int sarDen) {
            AWindow.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    for (IVLCVout.Callback cb : AWindow.this.mIVLCVoutCallbacks) {
                        cb.onNewLayout(AWindow.this, width, height, visibleWidth, visibleHeight, sarNum, sarDen);
                    }
                }
            });
        }

        @Override
        public void sendHardwareAccelerationError() {
            AWindow.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    for (IVLCVout.Callback cb : AWindow.this.mIVLCVoutCallbacks) {
                        cb.onHardwareAccelerationError(AWindow.this);
                    }
                }
            });
        }
    };

    public AWindow(SurfaceCallback surfaceCallback) {
        this.mSurfaceCallback = surfaceCallback;
        this.mSurfaceHelpers = new SurfaceHelper[2];
        this.mSurfaceHelpers[0] = null;
        this.mSurfaceHelpers[1] = null;
        this.mSurfaces = new Surface[2];
        this.mSurfaces[0] = null;
        this.mSurfaces[1] = null;
    }

    private void ensureInitState() throws IllegalStateException {
        if (this.mSurfacesState.get() != 0) {
            throw new IllegalStateException("Can't set view when already attached. Current state: " + this.mSurfacesState.get() + ", mSurfaces[ID_VIDEO]: " + this.mSurfaceHelpers[0] + " / " + this.mSurfaces[0] + ", mSurfaces[ID_SUBTITLES]: " + this.mSurfaceHelpers[1] + " / " + this.mSurfaces[1]);
        }
    }

    private void setView(int id, SurfaceView view) {
        this.ensureInitState();
        if (view == null) {
            throw new NullPointerException("view is null");
        }
        SurfaceHelper surfaceHelper = this.mSurfaceHelpers[id];
        if (surfaceHelper != null) {
            surfaceHelper.release();
        }
        this.mSurfaceHelpers[id] = new SurfaceHelper(id, view);
    }

    private void setView(int id, TextureView view) {
        if (!AndroidUtil.isICSOrLater()) {
            throw new IllegalArgumentException("TextureView not implemented in this android version");
        }
        this.ensureInitState();
        if (view == null) {
            throw new NullPointerException("view is null");
        }
        SurfaceHelper surfaceHelper = this.mSurfaceHelpers[id];
        if (surfaceHelper != null) {
            surfaceHelper.release();
        }
        this.mSurfaceHelpers[id] = new SurfaceHelper(id, view);
    }

    private void setSurface(int id, Surface surface, SurfaceHolder surfaceHolder) {
        this.ensureInitState();
        if (!surface.isValid() && surfaceHolder == null) {
            throw new IllegalStateException("surface is not attached and holder is null");
        }
        SurfaceHelper surfaceHelper = this.mSurfaceHelpers[id];
        if (surfaceHelper != null) {
            surfaceHelper.release();
        }
        this.mSurfaceHelpers[id] = new SurfaceHelper(id, surface, surfaceHolder);
    }

    @Override
    @MainThread
    public void setVideoView(SurfaceView videoSurfaceView) {
        this.setView(0, videoSurfaceView);
    }

    @Override
    @MainThread
    public void setVideoView(TextureView videoTextureView) {
        this.setView(0, videoTextureView);
    }

    @Override
    public void setVideoSurface(Surface videoSurface, SurfaceHolder surfaceHolder) {
        this.setSurface(0, videoSurface, surfaceHolder);
    }

    @Override
    @TargetApi(value=14)
    public void setVideoSurface(SurfaceTexture videoSurfaceTexture) {
        this.setSurface(0, new Surface(videoSurfaceTexture), null);
    }

    @Override
    @MainThread
    public void setSubtitlesView(SurfaceView subtitlesSurfaceView) {
        this.setView(1, subtitlesSurfaceView);
    }

    @Override
    @MainThread
    public void setSubtitlesView(TextureView subtitlesTextureView) {
        this.setView(1, subtitlesTextureView);
    }

    @Override
    public void setSubtitlesSurface(Surface subtitlesSurface, SurfaceHolder surfaceHolder) {
        this.setSurface(1, subtitlesSurface, surfaceHolder);
    }

    @Override
    @TargetApi(value=14)
    public void setSubtitlesSurface(SurfaceTexture subtitlesSurfaceTexture) {
        this.setSurface(1, new Surface(subtitlesSurfaceTexture), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @MainThread
    public void attachViews() {
        if (this.mSurfacesState.get() != 0 || this.mSurfaceHelpers[0] == null) {
            throw new IllegalStateException("already attached or video view not configured");
        }
        this.mSurfacesState.set(1);
        BuffersGeometryCond buffersGeometryCond = this.mBuffersGeometryCond;
        synchronized (buffersGeometryCond) {
            this.mBuffersGeometryCond.configured = false;
            this.mBuffersGeometryCond.abort = false;
        }
        for (int id = 0; id < 2; ++id) {
            SurfaceHelper surfaceHelper = this.mSurfaceHelpers[id];
            if (surfaceHelper == null) continue;
            surfaceHelper.attach();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @MainThread
    public void detachViews() {
        if (this.mSurfacesState.get() == 0) {
            return;
        }
        this.mSurfacesState.set(0);
        this.mHandler.removeCallbacksAndMessages(null);
        BuffersGeometryCond buffersGeometryCond = this.mBuffersGeometryCond;
        synchronized (buffersGeometryCond) {
            this.mBuffersGeometryCond.abort = true;
            this.mBuffersGeometryCond.notifyAll();
        }
        for (int id = 0; id < 2; ++id) {
            SurfaceHelper surfaceHelper = this.mSurfaceHelpers[id];
            if (surfaceHelper != null) {
                surfaceHelper.release();
            }
            this.mSurfaceHelpers[id] = null;
        }
        for (IVLCVout.Callback cb : this.mIVLCVoutCallbacks) {
            cb.onSurfacesDestroyed(this);
        }
        if (this.mSurfaceCallback != null) {
            this.mSurfaceCallback.onSurfacesDestroyed(this);
        }
    }

    @Override
    @MainThread
    public boolean areViewsAttached() {
        return this.mSurfacesState.get() != 0;
    }

    @MainThread
    private void onSurfaceCreated() {
        if (this.mSurfacesState.get() != 1) {
            throw new IllegalArgumentException("invalid state");
        }
        SurfaceHelper videoHelper = this.mSurfaceHelpers[0];
        SurfaceHelper subtitlesHelper = this.mSurfaceHelpers[1];
        if (videoHelper == null) {
            throw new NullPointerException("videoHelper shouldn't be null here");
        }
        if (videoHelper.isReady() && (subtitlesHelper == null || subtitlesHelper.isReady())) {
            this.mSurfacesState.set(2);
            for (IVLCVout.Callback cb : this.mIVLCVoutCallbacks) {
                cb.onSurfacesCreated(this);
            }
            if (this.mSurfaceCallback != null) {
                this.mSurfaceCallback.onSurfacesCreated(this);
            }
        }
    }

    @MainThread
    private void onSurfaceDestroyed() {
        this.detachViews();
    }

    protected boolean areSurfacesWaiting() {
        return this.mSurfacesState.get() == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendMouseEvent(int action, int button, int x, int y) {
        Object object = this.mNativeLock;
        synchronized (object) {
            if (this.mCallbackNativeHandle != 0L) {
                this.mAWindowNativeHandler.nativeOnMouseEvent(this.mCallbackNativeHandle, action, button, x, y);
            } else {
                this.mMouseAction = action;
                this.mMouseButton = button;
                this.mMouseX = x;
                this.mMouseY = y;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setWindowSize(int width, int height) {
        Object object = this.mNativeLock;
        synchronized (object) {
            if (this.mCallbackNativeHandle != 0L) {
                this.mAWindowNativeHandler.nativeOnWindowSize(this.mCallbackNativeHandle, width, height);
            } else {
                this.mWindowWidth = width;
                this.mWindowHeight = height;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setNativeSurface(int id, Surface surface) {
        Object object = this.mNativeLock;
        synchronized (object) {
            this.mSurfaces[id] = surface;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Surface getNativeSurface(int id) {
        Object object = this.mNativeLock;
        synchronized (object) {
            return this.mSurfaces[id];
        }
    }

    @Override
    public void addCallback(IVLCVout.Callback callback) {
        if (!this.mIVLCVoutCallbacks.contains(callback)) {
            this.mIVLCVoutCallbacks.add(callback);
        }
    }

    @Override
    public void removeCallback(IVLCVout.Callback callback) {
        this.mIVLCVoutCallbacks.remove(callback);
    }

    public AWindowNativeHandler getNativeHandler() {
        return this.mAWindowNativeHandler;
    }

    private static class BuffersGeometryCond {
        private boolean configured = false;
        private boolean abort = false;

        private BuffersGeometryCond() {
        }
    }

    private class SurfaceHelper {
        private final int mId;
        private final SurfaceView mSurfaceView;
        private final TextureView mTextureView;
        private final SurfaceHolder mSurfaceHolder;
        private Surface mSurface;
        private final SurfaceHolder.Callback mSurfaceHolderCallback = new SurfaceHolder.Callback(){

            public void surfaceCreated(SurfaceHolder holder) {
                if (holder != SurfaceHelper.this.mSurfaceHolder) {
                    throw new IllegalStateException("holders are different");
                }
                SurfaceHelper.this.setSurface(holder.getSurface());
            }

            public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
            }

            public void surfaceDestroyed(SurfaceHolder holder) {
                AWindow.this.onSurfaceDestroyed();
            }
        };
        private final TextureView.SurfaceTextureListener mSurfaceTextureListener = AndroidUtil.isICSOrLater() ? this.createSurfaceTextureListener() : null;

        private SurfaceHelper(int id, SurfaceView surfaceView) {
            this.mId = id;
            this.mTextureView = null;
            this.mSurfaceView = surfaceView;
            this.mSurfaceHolder = this.mSurfaceView.getHolder();
        }

        private SurfaceHelper(int id, TextureView textureView) {
            this.mId = id;
            this.mSurfaceView = null;
            this.mSurfaceHolder = null;
            this.mTextureView = textureView;
        }

        private SurfaceHelper(int id, Surface surface, SurfaceHolder surfaceHolder) {
            this.mId = id;
            this.mSurfaceView = null;
            this.mTextureView = null;
            this.mSurfaceHolder = surfaceHolder;
            this.mSurface = surface;
        }

        private void setSurface(Surface surface) {
            if (surface.isValid() && AWindow.this.getNativeSurface(this.mId) == null) {
                this.mSurface = surface;
                AWindow.this.setNativeSurface(this.mId, this.mSurface);
                AWindow.this.onSurfaceCreated();
            }
        }

        private void attachSurfaceView() {
            this.mSurfaceHolder.addCallback(this.mSurfaceHolderCallback);
            this.setSurface(this.mSurfaceHolder.getSurface());
        }

        @TargetApi(value=14)
        private void attachTextureView() {
            this.mTextureView.setSurfaceTextureListener(this.mSurfaceTextureListener);
            this.setSurface(new Surface(this.mTextureView.getSurfaceTexture()));
        }

        private void attachSurface() {
            if (this.mSurfaceHolder != null) {
                this.mSurfaceHolder.addCallback(this.mSurfaceHolderCallback);
            }
            this.setSurface(this.mSurface);
        }

        public void attach() {
            if (this.mSurfaceView != null) {
                this.attachSurfaceView();
            } else if (this.mTextureView != null) {
                this.attachTextureView();
            } else if (this.mSurface != null) {
                this.attachSurface();
            } else {
                throw new IllegalStateException();
            }
        }

        @TargetApi(value=14)
        private void releaseSurfaceTexture() {
            if (this.mTextureView != null) {
                this.mTextureView.setSurfaceTextureListener(null);
            }
        }

        public void release() {
            this.mSurface = null;
            AWindow.this.setNativeSurface(this.mId, null);
            if (this.mSurfaceHolder != null) {
                this.mSurfaceHolder.removeCallback(this.mSurfaceHolderCallback);
            }
            this.releaseSurfaceTexture();
        }

        public boolean isReady() {
            return this.mSurfaceView == null || this.mSurface != null;
        }

        public Surface getSurface() {
            return this.mSurface;
        }

        public SurfaceHolder getSurfaceHolder() {
            return this.mSurfaceHolder;
        }

        @TargetApi(value=14)
        private TextureView.SurfaceTextureListener createSurfaceTextureListener() {
            return new TextureView.SurfaceTextureListener(){

                public void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int width, int height) {
                    SurfaceHelper.this.setSurface(new Surface(surfaceTexture));
                }

                public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
                }

                public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
                    AWindow.this.onSurfaceDestroyed();
                    return true;
                }

                public void onSurfaceTextureUpdated(SurfaceTexture surface) {
                }
            };
        }
    }

    public static interface SurfaceCallback {
        @MainThread
        public void onSurfacesCreated(AWindow var1);

        @MainThread
        public void onSurfacesDestroyed(AWindow var1);
    }
}

