package jama.gpu;
import com.nativelibs4java.opencl.CLAbstractUserProgram;
import com.nativelibs4java.opencl.CLBuffer;
import com.nativelibs4java.opencl.CLBuildException;
import com.nativelibs4java.opencl.CLContext;
import com.nativelibs4java.opencl.CLEvent;
import com.nativelibs4java.opencl.CLKernel;
import com.nativelibs4java.opencl.CLProgram;
import com.nativelibs4java.opencl.CLQueue;
import java.io.IOException;
/// Wrapper around the OpenCL program MultiplicationKernel
public class MultiplicationKernel extends CLAbstractUserProgram {
	public MultiplicationKernel(CLContext context) throws IOException {
		super(context, readRawSourceForClass(MultiplicationKernel.class));
	}
	public MultiplicationKernel(CLProgram program) throws IOException {
		super(program, readRawSourceForClass(MultiplicationKernel.class));
	}
	CLKernel floatMatrixMult_kernel;
	public synchronized CLEvent floatMatrixMult(CLQueue commandQueue, CLBuffer<Float > MResp, CLBuffer<Float > M1, CLBuffer<Float > M2, CLBuffer<Integer > q, int globalWorkSizes[], int localWorkSizes[], CLEvent... eventsToWaitFor) throws CLBuildException {
		if (floatMatrixMult_kernel == null) 
			floatMatrixMult_kernel = createKernel("floatMatrixMult");
		floatMatrixMult_kernel.setArgs(MResp, M1, M2, q);
		return floatMatrixMult_kernel.enqueueNDRange(commandQueue, globalWorkSizes, localWorkSizes, eventsToWaitFor);
	}
	CLKernel floatMatrixMultLocals_kernel;
	public synchronized CLEvent floatMatrixMultLocals(CLQueue commandQueue, CLBuffer<Float > MResp, CLBuffer<Float > M1, CLBuffer<Float > M2, CLBuffer<Integer > q, int globalWorkSizes[], int localWorkSizes[], CLEvent... eventsToWaitFor) throws CLBuildException {
		if (floatMatrixMultLocals_kernel == null) 
			floatMatrixMultLocals_kernel = createKernel("floatMatrixMultLocals");
		floatMatrixMultLocals_kernel.setArgs(MResp, M1, M2, q);
		return floatMatrixMultLocals_kernel.enqueueNDRange(commandQueue, globalWorkSizes, localWorkSizes, eventsToWaitFor);
	}
	/// <i>native declaration : jama/gpu/MultiplicationKernel.cl</i>
	public static final int BLOCK_SIZE = (int)16;
}
