/*
 * Decompiled with CFR 0.152.
 */
package jama.util;

import jama.Matrix;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.util.Vector;

public class MatrixReader
extends LineNumberReader {
    public MatrixReader(Reader in) {
        super(in);
    }

    public Matrix readMatrix() throws IOException {
        int j;
        StreamTokenizer tokenizer = new StreamTokenizer(this);
        tokenizer.resetSyntax();
        tokenizer.wordChars(0, 255);
        tokenizer.whitespaceChars(0, 32);
        tokenizer.eolIsSignificant(true);
        Vector<Object> v = new Vector<Object>();
        while (tokenizer.nextToken() == 10) {
        }
        if (tokenizer.ttype == -1) {
            throw new IOException("Unexpected EOF on matrix read.");
        }
        do {
            v.addElement(Double.valueOf(tokenizer.sval));
        } while (tokenizer.nextToken() == -3);
        int n = v.size();
        double[] row = new double[n];
        for (j = 0; j < n; ++j) {
            row[j] = (Double)v.elementAt(j);
        }
        v.removeAllElements();
        v.addElement(row);
        while (tokenizer.nextToken() == -3) {
            row = new double[n];
            v.addElement(row);
            j = 0;
            do {
                if (j >= n) {
                    throw new IOException("Row " + v.size() + " is too long.");
                }
                row[j++] = Double.valueOf(tokenizer.sval);
            } while (tokenizer.nextToken() == -3);
            if (j >= n) continue;
            throw new IOException("Row " + v.size() + " is too short.");
        }
        int m = v.size();
        double[][] A = new double[m][];
        v.copyInto((Object[])A);
        return new Matrix(A);
    }
}

